/**
 * Copyright OneInchPunch ( http://wonderfl.net/user/OneInchPunch )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oihR
 */

// タイポでなにかしてみたい
// なんかもっさりしてる。ビットマップ化したほうがよさそう

package {
    import flash.display.*;
    import flash.events.*;
    import flash.utils.Timer;
    import flash.text.*;
    import caurina.transitions.Tweener;
    import caurina.transitions.properties.TextShortcuts;
    TextShortcuts.init();
    
    [SWF(backgroundColor="#000000", frameRate=30)]
    
    public class TextOverflow extends Sprite {
        
        [Embed(systemFont="serif", fontName="font", unicodeRange="U+0041-U+005A", mimeType="application/x-font")]
        private var font:Class;
        
        public function TextOverflow() {
            var _timer:Timer = new Timer(1000, 8);
            _timer.addEventListener(TimerEvent.TIMER, textSet);
            _timer.start();
        }
        
        
        public function textSet(e:TimerEvent):void {
            var typoContainer:Sprite = new Sprite();
            var typo:Array = new Array();
            
            typo = 'E M B D'.split(' ');
            
            // ダイナミックテキストにアルファ効かす
            blendMode = BlendMode.LAYER;
            
            var tfm:TextFormat = new TextFormat();
            tfm.size = 100;
            tfm.font = "font";
            tfm.align = TextFormatAlign.CENTER;
            
            for (var i:int=0; i<typo.length; i++) {
                var textRGB:Number = Math.random() * 0xffffff;
                tfm.color = textRGB;
                
                var textPosX:Number = Math.floor(Math.random()*(stage.stageWidth-200));
                var textPosY:Number = Math.floor(Math.random()*(stage.stageHeight-200));
                var textScale:Number = Math.floor((Math.random()*10)+3);
                var tf:TextField = new TextField();
                
                tf.defaultTextFormat = tfm;
                tf.background = false;
                tf.selectable = false;
                tf.wordWrap = false;
                
                tf.x = textPosX;
                tf.y = textPosY;
                tf.scaleX = textScale;
                tf.scaleY = textScale;
                tf.alpha = 0;
                
                tf.text = typo[i];
                
                Tweener.addTween(tf, {alpha:0.3, time:2, transition:"liner"});
                
                typoContainer.width = stage.stageWidth;
                typoContainer.height = stage.stageHeight;
                typoContainer.x = 0;
                typoContainer.y = 0;
                typoContainer.blendMode = BlendMode.ADD;
                typoContainer.addChild(tf);
                
                addChild(typoContainer);
            }
        }
    }
}
