/**
 * Copyright esukei ( http://wonderfl.net/user/esukei )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oiSk
 */

package {
    import flash.geom.Rectangle;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        private var p1:Point3D;
        private var p2:Point3D;
        private var p3:Point3D;
        private var p4:Point3D;
        
        private var canvasData:BitmapData;
        private var canvas:Bitmap;
        
        public function FlashTest() {
            // write as3 code here..
            p1 = new Point3D(0,0,100);
            p2 = new Point3D(0,100,0);
            p3 = new Point3D(100,0,0);
            p4 = new Point3D(-50,-50,-100);
            
            canvasData = new BitmapData(465,465,false,0xFF000000);
            canvas = new Bitmap(canvasData);
   
           //canvas.x = 240;
           //canvas.y = 240;
            
            addChild(canvas);
            
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void
        {
            canvasData.lock();
            canvasData.fillRect(new Rectangle(0,0,465,465), 0xFF000000);
            drawPoint(rotate(p1));
            drawPoint(rotate(p2));
            drawPoint(rotate(p3));
            drawPoint(rotate(p4));
            canvasData.unlock();
        }

        
        private function drawPoint(p:Point3D):void
        {
            canvasData.setPixel32(p.x+200,p.y+200,0xFFFFFFFF);
        }

        
        private function rotate(p:Point3D):Point3D
        {
            var ret:Point3D = new Point3D(p.x, p.y, p.z);
            var tmpP:Point;
            
            tmpP = rotate2D(new Point(ret.z, ret.x), stage.mouseX / 180 * Math.PI);
            ret.z = tmpP.x;
            ret.x = tmpP.y;
            
            tmpP = rotate2D(new Point(ret.x, ret.y), -stage.mouseY / 180 * Math.PI);
            ret.x = tmpP.x;
            ret.y = tmpP.y;
            
            return ret;
        }

        private function rotate2D(p:Point, rad:Number):Point
        {
           var tmpP:Point = p;
           tmpP.x = Math.cos(rad) * p.x + Math.sin(rad) * p.y;
           tmpP.y = -Math.sin(rad) * p.x + Math.cos(rad) * p.y;
           return tmpP;
        }

        
    }
}

class Point3D {
    
    public var x:Number;
    public var y:Number;
    public var z:Number;
    
    public function Point3D(x:Number = 0, y:Number = 0, z:Number = 0) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

}
