/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oiHp
 */

/*
FrocessingによるSVGデータ読み込みの練習 その2です。
参考：http://www.adobe.com/jp/devnet/flash/articles/spark_project_svg.html

ステージ上でマウスをダウンせずにカーソル移動させると描画。
マウスをダウンした状態でカーソル移動させると色が白になります。

でも未だによく分かっていない部分が…
*/

package {
    import frocessing.display.F5MovieClip3DBmp
    import flash.events.Event;
    import flash.display.Sprite;
    import flash.geom.ColorTransform;
    import flash.system.Security;
    import frocessing.shape.FShapeSVG;
    import frocessing.shape.FShapeSVGLoader;
    
    [SWF(width="465", height="465", frameRate="30")]

    public class Main extends F5MovieClip3DBmp {
        
        private static const W:Number  = 465;
        private static const H:Number = 465;
        private static const SVG_DATA:String = "http://www.digifie.jp/files/test.svg"
        private var _svg:FShapeSVG;
        private var _darkCt:ColorTransform

        public function Main() {
            Security.loadPolicyFile("http://www.digifie.jp/crossdomain.xml");
            super();
        }
        
        public function setup():void{
            _svg = new FShapeSVGLoader(SVG_DATA);
            _svg.fillAlpha = 0.05
            _darkCt = new ColorTransform(0.9, 0.9, 0.9, 1, 0, 0, 0, 0);
            size(W, H);
            background(0);
        }

        public function draw():void {
            var xh:Number = W/2;
            var yh:Number = H/2;
            translate(xh, yh);            
            bitmapData.colorTransform( bitmapData.rect, _darkCt);
            //
            var a:Number = (mouseY-yh) * 0.05;
            rotateY((mouseX-xh)*0.02);
            rotateZ(a * .1);
            translate(-W/2+(mouseX-xh)/10, -H/2, -a * 100 );
            //
            var n:int = _svg.getChildCount();
            for( var i:int=0; i<n; i++ ){
                translate(0, 0, a + i * 1.5);
                shape(_svg.getChildAt(i));
            }
        }
        
        public function mouseReleased():void {
            _svg.enableStyle();
        }
        
        public function mousePressed():void {
            _svg.disableStyle();
            stroke(255, 0.01);
            fill(255, 0.05);
        }
    }
}