/**
 * Copyright arithma ( http://wonderfl.net/user/arithma )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oi6R
 */

package  {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    /**
     * ...
     * @author arithma
     */
    public class Main extends Sprite {
        
        private var bitmap:Bitmap;
        private var data:BitmapData;
        
        public function Main() {
            data = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xFF);
            for (var i:int = 0; i < stage.stageWidth; i++) {
                var x:Number = i / stage.stageWidth;
                for (var j:int = 0; j < stage.stageHeight; j++) {
                    var y:Number = j / stage.stageHeight;
                    
                    var u:Number = (x - .5) * 100;
                    var v:Number = (y - .5) * 100;
                    
                    var theta:Number = Math.atan2(u, v);
                    var radius:Number = Math.sqrt(u * u + v * v);
                    
                    var u2:Number = Math.floor(theta * 10 / Math.PI);
                    var v2:Number = Math.floor(radius);
                    
                    var intensity:Number =
                        Math.exp(
                            Math.abs(
                                (Math.exp(-theta) * radius * .1 % 20)
                                /
                                (.2+radius*.1) * 100)
                           )
                           %
                           1;
                    data.setPixel(i, j, intensity / 1 * 0xFF & 0xFF);
                }
            }
            
            stage.addChild(new Bitmap(data));
        }
        
    }

}