/**
 * Copyright takashi ( http://wonderfl.net/user/takashi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oi2Y
 */

/*
http://livedocs.adobe.com/flash/9.0_jp/ActionScriptLangRefV3/index.html?class-summary.html&all-classes.html
*/
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.geom.Point;
    import flash.geom.Rectangle;
	import flash.display.Sprite;
	import flash.events.Event;
    
	[SWF(width="440", height="270", backgroundColor="0xFFFFFF", frameRate="24")]
    public class MyPerlinNoise extends Sprite {
		private var _bm:Bitmap;
		private var _bd:BitmapData;
		private var _width:Number = 900; //BitmapDataWidth
		private var _height:Number = 700; //BitmapDataHeight
		
		//perlinNoise() args
		private var _nX:Number = 0; 			//x 方向で使用する周波数。
		private var _nY:Number = 0; 			//y 方向で使用する周波数。
		private var _octaves:Number = 1; 		//numOctaves このノイズを作成するために組み合わせるオクターブ (つまり個々のノイズ関数) の数
		private var _channels:uint; 			//color channelOptions 任意の 4 つのカラーチャンネル値の組み合わせである数値
		private var _seed:int; 					//randomSeed ランダムシード (乱数の種) として使用する数値
		private var _offset:Array = new Array(); //各オクターブの x オフセットと y オフセットに対応するポイントの配列

		private var _speed:Array = new Array();
		
		public function MyPerlinNoise () {
			_bd = new BitmapData(_width, _height, true, 0xFFFFFF);
            _bm = new Bitmap(_bd);
            addChild(_bm);
			doPerlinNoise();
        }
		
		public function doPerlinNoise():void{
            _seed = Math.floor(Math.random() * 10);
            _channels = BitmapDataChannel.RED | BitmapDataChannel.BLUE | BitmapDataChannel.GREEN;
			
			for (var i:Number = 0; i < _octaves; i++) {
				_offset[i] = new Point(Math.random() * _width / 2, Math.random() * _height / 2);
				_speed[i] = new Point(Math.random() * 2, Math.random() * 2);
			}
			
			_nX = _width / 2 * Math.random();
			_nY = _height / 2 * Math.random();
			
			addEventListener(Event.ENTER_FRAME, perlinNoiseEnterFrame );
		}
		
		public function perlinNoiseEnterFrame(e:Event):void {
			
			for (var i:Number = 0; i < _octaves; i++) {
				_offset[i].x += _speed[i].x;
				_offset[i].y += _speed[i].y;
			}
			
			_nX += _width / 1000;
			_nY += _width / 1000;
			
			_bd.perlinNoise(_nX, _nY, _octaves, _seed, false, true, _channels , false, _offset);
		}
    }
}