/**
 * Copyright and ( http://wonderfl.net/user/and )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ohyu
 */

package
{
    import flash.text.TextField;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.utils.setTimeout;
    import flash.utils.getTimer;
    
    public class FlashTest extends Sprite
    {
        
        private const ARRAY_LENGTH:int = 10000;
        private var txt:TextField;
        
        public function FlashTest()
        {
            // write as3 code here..
            init();
        }
        
        private function init():void
        {
            var s:Sprite = new Sprite();
            addChild(s);
            
            s.graphics.beginFill(0);
            s.graphics.drawCircle(20,20,10);
            s.graphics.endFill();             
            
            txt = new TextField();
            txt.y = 30;
            txt.width = 400;
            txt.height = 300;
            addChild(txt);
            
            s.addEventListener(MouseEvent.CLICK, onClick);
        }
        
        private function onClick(event:MouseEvent):void
        {
            
            txt.appendText("Working...\n");
            setTimeout(tests, 500);
        }
        
        private function tests():void
        {
            test1();
            test2();
            test3();
        }
        
        private function test1():void
        {
            var map:Array = [];
            var line:Array = [];
            
            // засекаем время
            var t:int = getTimer();
            
            /* НАЧАЛО ТЕСТА */
            for (var i:int = 0; i < ARRAY_LENGTH; i++)
                line[i] = 0;
            for (i = 0; i < ARRAY_LENGTH; i++)
                map[i] = line.slice();
            /* КОНЕЦ ТЕСТА */
            
            t = getTimer() - t;
            txt.appendText("Test1 (Zebestov): " + t + "\n");
        }
        
        private function test2():void
        {
            var a2d_len:int = ARRAY_LENGTH;
            var a2d:Array = new Array(a2d_len);
            
            //  засекаем время
            var t:int = getTimer();
            
            /* НАЧАЛО ТЕСТА */
            for (var i:int = 0; i < a2d_len; i++)
            {
                a2d[i] = new Array(a2d_len);
                for (var k:int = 0; k < a2d_len; k++)
                {
                    a2d[i][k] = 0;
                }
            }
            /* КОНЕЦ ТЕСТА */
            
            t = getTimer() - t;
            txt.appendText("Test2 (TheRabbit): " + t + "\n");
        }
        
        private function test3():void
        {
            var map:Array = [];
            
            //  засекаем время
            var t:int = getTimer();
            
            /* НАЧАЛО ТЕСТА */
            for (var i:int = 0; i < ARRAY_LENGTH; ++i)
            {
                var temp:Array = [];
                for (var j:int = 0; j < ARRAY_LENGTH; ++j)
                    temp[j] = 0;
                map[i] = temp;
            }
            /* КОНЕЦ ТЕСТА */
            
            t = getTimer() - t;
            txt.appendText("Test3 (wizard оптимизированный): " + t + "\n");
        }
    }
}