/**
 * Copyright clockmaker ( http://wonderfl.net/user/clockmaker )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oh9i
 */

//------------------------------------------------------------------------------
// Math.min / Math.max Performance Test
// Mathクラスのビルドインの処理が遅すぎるのでテストしてみた
// (1) Mathクラス : 遅い
// (2) MyMathクラス : 早くなると思ったけどビルドインより遅かった
// (3) インライン : 最強
//------------------------------------------------------------------------------
package {
    import com.bit101.components.PushButton;
    import com.bit101.components.Text;
    
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.utils.getTimer;
    public class Main extends Sprite {
        private static const MAX:int = 3000000;
        
        public function Main() {
            btnA = new PushButton(this, 250, 10, "Buildin Math", _onClick);
            btnB = new PushButton(this, 250, 110, "Orijinal MyMath", _onClick);
            btnC = new PushButton(this, 250, 210, "Inline", _onClick);
            text = new Text(this, 10, 10, "MIN/MAX Performance Test");
            for (var i:int = 0; i < MAX; i++) pool[ i ] = Math.random() * 100;
        }
        private var btnA:PushButton;
        private var btnB:PushButton;
        private var btnC:PushButton;
        private var pool:Vector.<Number> = new Vector.<Number>(MAX, true);
        private var text:Text;
        
        private function _calcA():void {
            var oldTime:Number = getTimer();
            for (var i:int = 0; i < MAX; i++)
                var val:Number = Math.max(0, Math.min(100, pool[ i ]))
            text.text = "CALC TIME for " + MAX + " step: \n" + (getTimer() - oldTime) + "msec";
        }
        
        private function _calcB():void {
            var oldTime:Number = getTimer();
            for (var i:int = 0; i < MAX; i++)
                var val:Number = MyMath.max(0, MyMath.min(100, pool[ i ]));
            text.text = "CALC TIME for " + MAX + " step: \n" + (getTimer() - oldTime) + "msec";
        }
        
        private function _calcC():void {
            var oldTime:Number = getTimer();
            for (var i:int = 0; i < MAX; i++)
                var val:Number = (0 > pool[ i ]) ? 0 : (pool[ i ] > 100) ? 100 : pool[ i ];
            text.text = "CALC TIME for " + MAX + " step: \n" + (getTimer() - oldTime) + "msec";
        }
        
        private function _onClick(e:Event):void {
            if (e.currentTarget == btnA) _calcA();
            if (e.currentTarget == btnB) _calcB();
            if (e.currentTarget == btnC) _calcC();
        }
    }
}
class MyMath {
    public static function max(val1:Number, val2:Number):Number {
        return val1 > val2 ? val1 : val2;
    }
    
    public static function min(val1:Number, val2:Number):Number {
        return val1 < val2 ? val1 : val2;
    }
}