/**
 * Copyright FLASHMAFIA ( http://wonderfl.net/user/FLASHMAFIA )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oh32
 */

package {
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.geom.Rectangle;

    [SWF(width = '465', height = '465')]
    public class DOF3D01 extends Sprite
     {
        function DOF3D01()
         {
            var sw : int = stage.stageWidth;
            var sh : int = stage.stageHeight;

            stage.stageFocusRect = mouseEnabled = mouseChildren = tabEnabled = tabChildren = false;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.fullScreenSourceRect = new Rectangle(0, 0, sw, sh);
            stage.quality = StageQuality.LOW;
            stage.frameRate = 64;
            opaqueBackground = 0x0;

            /* */

            var dof : Space3D = new Space3D(sw, sh, 0xE0E0E0);
            dof.opaqueBackground = 0x0;
            addChild(dof);
        }
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
import flash.display.Shape;
import flash.events.Event;
import flash.filters.BlurFilter;
import flash.geom.Point;
import flash.geom.Rectangle;


internal class Space3D extends Bitmap
{
    public var ooo : Vector.<O3D>;
    /* */
    private const FOV : Number = 70;
    private const NEAR_Z : Number = 1;
    private const TEX_SIZE : Number = 32;
    private const Z_STEPS : int = 40;
    private const VZ_DIV : Number = (3.141592653589793);
    private const VZ_MAX : Number = Z_STEPS / VZ_DIV;
    private const BLUR_SIZE : Number = 16.0;
    private const GRID_SIZE : Number = 16;
    private const NUM_P : uint = 8;
    private const NUM_P3 : uint = NUM_P * NUM_P * NUM_P;
    private const TRANS_SPEED : uint = NUM_P3 >> 6;
    /* */
    private var ooo_depths : Array;
    private var motion : Motion3D;
    private var motionF : Function;
    private var grid_p : Vector.<Vec3D>;
    private var grid_lines : Array = [[0, 1], [1, 2], [2, 8], [0, 3], [1, 5], [3, 5], [5, 8], [3, 4], [5, 6], [8, 7], [4, 6], [6, 7], [2, 11], [11, 19], [8, 15], [15, 25], [7, 16], [16, 24], [2, 8], [11, 15], [19, 25], [8, 7], [15, 16], [25, 24], [17, 18], [18, 19], [9, 10], [10, 11], [17, 9], [18, 10], [9, 0], [10, 1], [18, 23], [17, 20], [25, 23], [23, 20], [24, 22], [22, 21], [23, 22], [20, 21], [20, 12], [21, 13], [12, 3], [13, 4], [20, 21], [12, 13], [22, 14], [16, 14], [14, 13], [6, 14]];
    private var grid_sh : Shape;
    private var grid_g : Graphics;
    private var dofs : Vector.<BitmapData> = new Vector.<BitmapData>(Z_STEPS, true);
    private var dstp : Point = new Point();
    private var fillColor : uint;
    private var ws : Number;
    private var stateCnt : int;
    private var stateDuration : int;
    private var rot0 : Number = 0.0;
    private var onum : uint;

    function Space3D(width : int, height : int, fillColor : uint) /* */
     {
        super(new BitmapData(width, height, false));

        this.fillColor = fillColor;

        ws = (width * NEAR_Z) / (Math.tan(FOV * (3.141592653589793) / 360) * NEAR_Z * 2);

        /* DOF BMDS */

        var blur : BlurFilter = new BlurFilter(0, 0, 3);
        var i : uint = Z_STEPS;

        while (i-- != 0) {
            var f : Number = 1 - (i / Z_STEPS);
            var t : Number = Math.abs(-1 + 2 * f);

            var opacity : uint = ((0.75 + 0.25 * t) * 0xFF) >> 0;
            var lum : uint = 0xFF;
            var c : uint = (opacity << 24) | (lum << 16) | (lum << 8) | lum;

            var tex : BitmapData = new BitmapData((TEX_SIZE * (0.1 + 0.9 * f)), (TEX_SIZE * (0.1 + 0.9 * f)), true, c);

            blur.blurX = t * BLUR_SIZE;
            blur.blurY = t * BLUR_SIZE;

            var bounds : Rectangle = tex.generateFilterRect(tex.rect, blur);
            dofs[i] = new BitmapData(bounds.width, bounds.height, true);
            dofs[i].applyFilter(tex, bounds, dstp, blur);

            tex.dispose();
        }

        /* */

        ooo = new Vector.<O3D>(NUM_P3, true);
        i = ooo.length;
        while (i-- != 0) {
            ooo[i] = new O3D(this, dofs);
        }

        /* */

        grid_sh = new Shape();
        grid_g = grid_sh.graphics;
        grid_p = Vector.<Vec3D>([new Vec3D(0, 0, 0, GRID_SIZE, GRID_SIZE, GRID_SIZE), new Vec3D(0, 0, 0, 0, GRID_SIZE, GRID_SIZE), new Vec3D(0, 0, 0, -GRID_SIZE, GRID_SIZE, GRID_SIZE), new Vec3D(0, 0, 0, GRID_SIZE, 0, GRID_SIZE), new Vec3D(0, 0, 0, GRID_SIZE, -GRID_SIZE, GRID_SIZE), new Vec3D(0, 0, 0, 0, 0, GRID_SIZE), new Vec3D(0, 0, 0, 0, -GRID_SIZE, GRID_SIZE), new Vec3D(0, 0, 0, -GRID_SIZE, -GRID_SIZE, GRID_SIZE), new Vec3D(0, 0, 0, -GRID_SIZE, 0, GRID_SIZE), new Vec3D(0, 0, 0, GRID_SIZE, GRID_SIZE, 0), new Vec3D(0, 0, 0, 0, GRID_SIZE, 0), new Vec3D(0, 0, 0, -GRID_SIZE, GRID_SIZE, 0), new Vec3D(0, 0, 0, GRID_SIZE, 0, 0), new Vec3D(0, 0, 0, GRID_SIZE, -GRID_SIZE, 0), new Vec3D(0, 0, 0, 0, -GRID_SIZE, 0), new Vec3D(0, 0, 0, -GRID_SIZE, 0, 0), new Vec3D(0, 0, 0, -GRID_SIZE, -GRID_SIZE, 0), new Vec3D(0, 0, 0, GRID_SIZE, GRID_SIZE, -GRID_SIZE), new Vec3D(0, 0, 0, 0, GRID_SIZE, -GRID_SIZE), new Vec3D(0, 0, 0, -GRID_SIZE, GRID_SIZE, -GRID_SIZE), new Vec3D(0, 0, 0, GRID_SIZE, 0, -GRID_SIZE), new Vec3D(0, 0, 0, GRID_SIZE, -GRID_SIZE, -GRID_SIZE), new Vec3D(0, 0, 0, 0, -GRID_SIZE, -GRID_SIZE), new Vec3D(0, 0, 0, 0, 0, -GRID_SIZE), new Vec3D(0, 0, 0, -GRID_SIZE, -GRID_SIZE, -GRID_SIZE), new Vec3D(0, 0, 0, -GRID_SIZE, 0, -GRID_SIZE)]);

        /* */

        changeState();
        motion = new Motion3D(this);

        addEventListener(Event.ENTER_FRAME, oef);
    }

    private function oef(e : Event) : void {
        /* MOTION */

        var w : Number = bitmapData.width;
        var h : Number = bitmapData.height;
        var cx : Number = w / 2;
        var cy : Number = h / 2;

        var camx : Number = motion.camX;
        var camy : Number = motion.camY;
        var camz : Number = motion.camZ;

        var xsa : Number = motion.lookX - camx;
        var zsa : Number = motion.lookZ - camz;

        motion.rotX = -1 * (Math.atan2(camy - motion.lookY, Math.sqrt(xsa * xsa + zsa * zsa)));
        motion.rotY = -1 * ((Math.atan2(-zsa, xsa) + (1.5707963267948966)));

        var cosX : Number = Math.cos(motion.rotX);
        var sinX : Number = Math.sin(motion.rotX);
        var cosY : Number = Math.cos(motion.rotY);
        var sinY : Number = Math.sin(motion.rotY);
        var cxcy : Number = cosX * cosY;
        var sxcy : Number = sinX * cosY;
        var cxsy : Number = cosX * sinY;
        var sxsy : Number = sinX * sinY;
        var s : Number = ws;
        var zoom : Number = 1.0;

        /* DRAW */

        bitmapData.lock();
        bitmapData.fillRect(bitmapData.rect, fillColor);

        /* --> GRID */

        var gp0 : Vec3D;
        var gp1 : Vec3D;
        var len : uint = grid_p.length;

        var i : uint = 0;
        while (i < len) {
            var p : Vec3D = grid_p[i];

            var sx : Number = p.dx - camx;
            var sy : Number = p.dy - camy;
            var sz : Number = p.dz - camz;
            var ssz : Number = -(sx * cxsy) + (sy * sinX) + (sz * cxcy);

            p.z = ssz;

            if (ssz > 0) {
                zoom = s / ssz;
                p.x = cx + (sx * cosY + sz * sinY) * zoom;
                p.y = cy - (sx * sxsy + sy * cosX - sz * sxcy) * zoom;
            }

            i++;
        }

        grid_g.clear();
        grid_g.lineStyle(1, 0xFFFFFF, 1.0, false, 'none', 'none');

        len = grid_lines.length;

        i = 0;
        while (i < len) {
            gp0 = grid_p[grid_lines[i][0]];
            gp1 = grid_p[grid_lines[i][1]];

            if ((gp0.z > 0) && (gp1.z > 0)) {
                grid_g.moveTo(gp0.x, gp0.y);
                grid_g.lineTo(gp1.x, gp1.y);
            }

            i++;
        }

        bitmapData.draw(grid_sh);

        /* OOO : DEPTH SORTING */

        ooo_depths = [];

        var ocnt : uint;
        for each (var o : O3D in ooo) //
        {
            sx = o.dx - camx;
            sy = o.dy - camy;
            sz = o.dz - camz;
            ssz = -sx * cxsy + sy * sinX + sz * cxcy;

            o.z = ssz;

            if ((o.z > 0) && (o.z < VZ_MAX)) //
            {
                zoom = (s / ssz);
                o.x = cx + (sx * cosY + sz * sinY) * zoom;

                if ((o.x > -64) && (o.x < w)) //
                {
                    o.y = cy - (sx * sxsy + sy * cosX - sz * sxcy) * zoom;

                    if ((o.y > -64) && (o.y < h)) //
                    {
                        ocnt++;
                        ooo_depths[ocnt] = [o, ssz];
                    }
                }
            }
        }

        ooo_depths.sortOn("1", Array.NUMERIC | Array.DESCENDING);

        i = 0;
        while (i < ocnt) {
            o = ooo_depths[i][0];
            dstp.x = o.x;
            dstp.y = o.y;
            var currBrush : BitmapData = o.dofs[(o.z * VZ_DIV) >> 0];
            bitmapData.copyPixels(currBrush, currBrush.rect, dstp);

            i++;
        }

        bitmapData.unlock();
    }

    public function changeState() : void //
    {
        if (motionF != null) removeEventListener(Event.ENTER_FRAME, motionF);

        stateCnt = 0;
        stateDuration = 128 + ((256 * Math.random()) >> 1);
        onum = 0;

        var id : uint = (Math.random() * 7) >> 0;
        trace('id: ' + (id));

        if (id == 0) {
            startF0();
        } else if (id == 1) {
            startF1();
        } else if (id == 2) {
            startF2();
        } else if (id == 3) {
            startF3();
        } else if (id == 4) {
            startF4();
        } else if (id == 5) {
            startF5();
        } else {
            startF6();
        }

        id = (Math.random() * 3) >> 0;

        if (id == 0) {
            motionF = motionF0123;
        } else if (id == 1) {
            // XXX motionF = motionF4;
            motionF = motionF6;
        } else if (id == 2) {
            motionF = motionF5;
        } else {
            motionF = motionF6;
        }

        addEventListener(Event.ENTER_FRAME, motionF, false, 0, true);
    }

    /*
    ============================================================================================== MOTION : START
    =============================================================================================================
     */
    private function startF0() : void //
    {
        var a : Number = 0.0;
        var va : Number = ((6.283185307179586) / NUM_P3) * (1 + ((4 * Math.random()) >> 0));
        var sp : Number = 0.025 + 0.05 * Math.random();

        var i : uint = 0;
        while (i < NUM_P3) {
            var o : O3D = ooo[i];
            o.s = 0;
            o.sp = sp;
            o.gx = Math.cos(a) * 4;
            o.gy = -(NUM_P3 * 0.004) + (i * 0.008);
            o.gz = Math.sin(a) * 4;

            a += va;
            ++i;
        }
    }

    private function startF1() : void //
    {
        var loc9 : Number = 0;
        var loc10 : Number = 0;
        var loc11 : Number = (6.283185307179586) / NUM_P3;
        var loc12 : Number = (loc11) * (Math.random() * 40 + 1 >> 0);
        var loc13 : Number = 3 + Math.random() * 5;
        var loc15 : Number = Math.random() * 0.05 + 0.022;

        var i : uint;
        while (i < NUM_P3) {
            var o : O3D = ooo[i];
            o.s = 0;
            o.sp = loc15;
            var loc14 : Number = Math.cos(loc9) * loc13;

            o.gx = Math.cos(loc10) * loc14;
            o.gy = Math.sin(loc9) * loc13;
            o.gz = Math.sin(loc10) * loc14;

            loc9 += loc11;
            loc10 += loc12;

            ++i;
        }
    }

    private function startF2() : void //
    {
        var nump : Number = NUM_P;
        var sp : Number = Math.random() * 0.05 + 0.025;
        var f : Number = 0.8 + 0.05 * Math.random();
        var offst : Number = -1 * (nump - 1) * f * 0.5;

        var i : uint;
        var gx : uint = nump;
        while (gx-- != 0) {
            var gy : uint = nump;
            while (gy-- != 0) {
                var gz : uint = nump;
                while (gz-- != 0) {
                    var o : O3D = ooo[i];
                    o.s = 0;
                    o.sp = sp;
                    o.gx = gx * f + offst;
                    o.gy = gy * f + offst;
                    o.gz = gz * f + offst;

                    ++i;
                }
            }
        }
    }

    private function startF3() : void {
        var sp : Number;
        var gxmul : Number;
        var gxadd : Number;
        var gyzmul : Number;

        sp = Math.random() * 0.05 + 0.022;
        gxmul = 0.02 + Math.random() * 0.025;
        gxadd = -gxmul * NUM_P3 * 0.44;
        gyzmul = 1.2 + Math.random();

        var i : int = NUM_P3;
        while (i-- != 0) {
            var o : O3D = ooo[i];
            o.s = 0;
            o.sp = sp;
            o.gx = i * gxmul + gxadd;
            o.gy = -0.6 + Math.random() * gyzmul;
            o.gz = -0.6 + Math.random() * gyzmul;
        }
    }

    private function startF4() : void //
    {
        var lensqrt : uint = (Math.sqrt(NUM_P3)) >> 0;
        var sp : Number = Math.random() * 0.05 + 0.022;
        var ga : Number = (-(lensqrt - 1)) * 0.55 * 0.5;
        var a : Number = 0;
        var va : Number = Math.random() * 0.3 + 0.05;
        var vgy : Number = Math.random() * 1 + 1;

        var i : uint;
        var n : uint;
        while (n < lensqrt) {
            var gy : Number = Math.cos(a) * vgy;
            a += va;
            var nn : uint = 0;
            while (nn < lensqrt) {
                var o : O3D = ooo[i];

                i++;

                o.s = 0;
                o.sp = sp;
                o.vz = 0;
                o.vy = 0;
                o.vx = 0;
                o.gx = n * 0.55 + ga;
                o.gy = gy;
                o.gz = nn * 0.55 + ga;

                nn++;
            }
            n++;
        }
    }

    private function startF5() : void {
        var i : int = NUM_P3;
        while (i-- != 0) {
            var o : O3D = ooo[i];
            o.s = 0.0;
            o.sp = 0.5;
            o.vx = 0;
            o.vy = -0.2 * Math.random();
            o.vz = 0;
        }
    }

    private function startF6() : void {
        var i : int = NUM_P3;
        while (i-- != 0) {
            var o : O3D = ooo[i];
            o.s = 0.0;
            o.sp = 0.5;
            o.vx = Math.random() * 0.25 - 0.125;
            o.vy = Math.random() * 0.25 - 0.125;
            o.vz = Math.random() * 0.25 - 0.125;
        }
    }

    /*
    ====================================================================================================== MOTION
    =============================================================================================================
     */
    private function motionF0123(e : Event) : void {
        rot0 += 0.08;

        var i : uint;
        while (i < onum) {
            var o : O3D = ooo[i];
            o.gy = Math.cos(rot0 + (i / NUM_P3) * ((6.283185307179586)));
            o.s += (o.sp - o.s) * 0.1;
            o.dx += (o.gx - o.dx) * o.s;
            o.dy += (o.gy - o.dy) * o.s;
            o.dz += (o.gz - o.dz) * o.s;

            i++;
        }

        /* */

        onum += TRANS_SPEED;
        if (onum > NUM_P3) onum = NUM_P3;
        if (++stateCnt > stateDuration) changeState();
    }

    private function motionF4(e : Event) : void //
    {
        var len : uint = Math.sqrt(NUM_P3);
        var ocnt : uint;
        var i : uint;
        while (i < len) {
            var gy : Number = Math.cos(rot0 + (i / NUM_P3) * ((6.283185307179586))) * 1;

            var ii : uint = 0;
            while (ii < len) {
                var o : O3D = ooo[ocnt++];
                o.gy = gy;
                ii++;
            }
            i++;
        }

        rot0 = rot0 + 0.11;

        i = 0;
        while (i < onum) {
            o = ooo[i];
            if (o.s < 0.5) o.s += o.sp;
            o.dx += (o.gx - o.dx) * o.s;
            o.dy += (o.gy - o.dy) * o.s;
            o.dz += (o.gz - o.dz) * o.s;
            i++;
        }

        /* */

        onum += TRANS_SPEED;
        if (onum > NUM_P3) onum = NUM_P3;
        if (++stateCnt > stateDuration) changeState();
    }

    private function motionF5(e : Event) : void //
    {
        var i : uint = 0;
        while (i < NUM_P3) {
            var o : O3D = ooo[i];
            o.dy += o.vy;
            o.vy -= 0.06;

            if (o.dy < -9) {
                o.dy = -9;
                o.vy *= -o.sp;
                o.sp *= 0.9;
            }

            i++;
        }

        /* */

        onum += TRANS_SPEED;
        if (onum > NUM_P3) onum = NUM_P3;
        if (++stateCnt > stateDuration) changeState();
    }

    private function motionF6(e : Event) : void //
    {
        var i : uint = 0;
        while (i < onum) {
            var o : O3D = ooo[i];
            o.dx += o.vx;
            o.dy += o.vy;
            o.dz += o.vz;
            i++;
        }

        /* */

        onum += TRANS_SPEED;
        if (onum > NUM_P3) onum = NUM_P3;
        if (++stateCnt > stateDuration) changeState();
    }
}

internal class Motion3D {
    /* */
    public var lookX : Number = 0.0;
    public var lookY : Number = 0.0;
    public var lookZ : Number = 0.0;
    public var rotX : Number = 0.0;
    public var rotY : Number = 0.0;
    public var rotZ : Number = 0;
    public var vr : Number = 0.0;
    public var vy : Number = 0.0;
    public var camX : Number = 0.0;
    public var camY : Number = 0.0;
    public var camZ : Number = 0.0;
    /* */
    private var r : Number = -2.4;
    private var amp : Number = 6;
    private var ampT : Number = 0.0;
    private var zoom : Number = 0.0;
    private var rp : Number = 0.03;
    private var ovx : Number = 0.0;
    private var ovz : Number = 0.0;
    private var s : Number = 0.0;
    private var o : O3D;
    private var space : Space3D;
    private var fcnt : int;
    private var delay : int;

    function Motion3D(space : Space3D) {
        this.space = space;

        camX = Math.cos(r) * amp;
        camY = -22;
        camZ = Math.sin(r) * amp;

        space.addEventListener(Event.ENTER_FRAME, oef);
    }

    private function oef(e : Event) : void //
    {
        ++fcnt;

        if (fcnt > delay) {
            fcnt = 0;
            delay = 32 + ((64 * Math.random()) >> 0);

            o = space.ooo[(Math.random() * space.ooo.length) >> 0];
            s = Math.random() * 0.1;
            ovx = Math.random() * 0.07 - 0.035;
            ovz = Math.random() * 0.07 - 0.035;

            zoom = 0.1 * Math.random();
            rp = -0.03 + 0.06 * Math.random();
            ampT = 7 + Math.random() * 4;
        }

        if (s < 0.5) s += 0.005;

        lookX += (o.dx - lookX) * s;
        lookY += (o.dy - lookY) * s;
        lookZ += (o.dz - lookZ) * s;

        r += rp;
        amp += (ampT - amp) * 0.1;
        if (zoom < 0.5) zoom += 0.005;

        camX += ((Math.cos(r) * amp) + (o.dx - camX)) * zoom;
        camY += (o.dy - camY) * zoom;
        camZ += ((Math.sin(r) * amp) + (o.dz - camZ)) * zoom;
    }
}

internal class O3D {
    public var dofs : Vector.<BitmapData>;
    public var s : Number = 0.0;
    public var sp : Number = 0.0;
    public var x : Number = 0.0;
    public var y : Number = 0.0;
    public var z : Number = 0.0;
    public var gx : Number = 0.0;
    public var gy : Number = 0.0;
    public var gz : Number = 0.0;
    public var dx : Number = 0.0;
    public var dy : Number = 0.0;
    public var dz : Number = 0.0;
    public var vx : Number = 0.0;
    public var vy : Number = 0.0;
    public var vz : Number = 0.0;
    /* */
    private var space : Space3D;

    function O3D(space : Space3D, dofs : Vector.<BitmapData>) {
        this.dofs = dofs;
        this.space = space;
        space.addEventListener(Event.ENTER_FRAME, oef);
    }

    private function oef(e : Event) : void {
        if (s < 0.9) s += 0.015;
        dx += (gx - dx) * s + (vx *= 0.9);
        dy += (gy - dy) * s + (vy *= 0.9);
        dz += (gz - dz) * s + (vz *= 0.9);
    }
}

internal class Vec3D {
    public var x : Number;
    public var y : Number;
    public var z : Number;
    public var dx : Number;
    public var dy : Number;
    public var dz : Number;

    function Vec3D(x : Number = 0.0, y : Number = 0.0, z : Number = 0.0, dx : Number = 0.0, dy : Number = 0.0, dz : Number = 0.0) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
    }
}