/**
 * Copyright spanvega ( http://wonderfl.net/user/spanvega )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ognO
 */

package
{
    import flash.events.Event;
    import flash.display.Sprite;

    import starling.core.Starling;

    public class TEXTURE extends Sprite
    {
        public function TEXTURE () { addEventListener (Event.ADDED_TO_STAGE, init); }

        private function init (e : Event) : void
        {
            Wonderfl.disable_capture ();

            removeEventListener (Event.ADDED_TO_STAGE, init);

            with (stage) { align = 'TL'; frameRate = 60; scaleMode = 'noScale'; }

            new Starling (Main, stage).start ();
        }
    }
}


import flash.display.*;
import flash.geom.Point;

import starling.display.*;
import starling.events.Event;
import starling.core.Starling;
import starling.textures.Texture;

class Main extends starling.display.Sprite
{
    private var quadBatch : QuadBatch = new QuadBatch ();
    private var o : Array = [new Point (), new Point ()];
    private var w : uint, h : uint;
    private var scale : int = 6;
    private var b : BitmapData;
    private var image : Image;

    public function Main ()
    {
        w = Starling.current.stage.stageWidth;
        h = Starling.current.stage.stageHeight;

        var shape : Shape = new Shape ();
        shape.graphics.beginFill (0x000000, 0.50);
        shape.graphics.lineStyle (1, 0xFF2000, 1);
        shape.graphics.drawRoundRect (0, 0, 100, 100, 20, 20);

        var bitmap : BitmapData = new BitmapData (shape.width, shape.height, true, 0);
        bitmap.draw (shape);

        image = new Image (Texture.fromBitmapData (bitmap));
        // image.alignPivot ();
        image.pivotY = image.height >> 1;
        image.pivotX = image.width  >> 1;

        b = new BitmapData (w / scale, h / scale, false, 0);

        addChild (new Quad (w, h, 0xFF2000));

        addChild (quadBatch);

        addEventListener (Event.ENTER_FRAME, frame);
    }
    
    private function frame (e : Event) : void
    {
        Point (o [0]).x += 0.30;

        b.perlinNoise (100 / scale, 100 / scale, 2, 0xFFFF, false, false, 1, true, o);

        quadBatch.reset ();

        var i : int, j : int, v : Number;

        for (i = 0; i < w; i += scale) for (j = 0; j < h; j += scale)
        {
            v = (b.getPixel (i / scale, j / scale) >> 16) / 0xFF;

            image.scaleX = image.scaleY = image.alpha = 0.1 + (v * 0.9);
            image.rotation = v * PI;
            image.x = i; 
            image.y = j;

            quadBatch.addImage (image);
        }
    }

    private const PI : Number = 3.1415926535;
}