/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ofmX
 */

// forked from hacker_7daxapax's ButtonTest02:　ボタン作成機能をオブジェクトにまとめる
//[error]couldnt connect with server, try again later!
//とエラーメッセージが出てWonderflが使えなくなった。。。　
//↑今回もまたavastのせいだった。。。　　
//前回はavast更新すれば使えるようになったけど、今回はavast停止させないと動かせなくなった。。。

package {
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;

    public class ButtonTest extends Sprite {
        
        private var button01 : SimpleButton;//ボタン1 
        private var button02 : SimpleButton;//ボタン2
        private var button03 : SimpleButton;//ボタン3
        private var label : TextField;    //ラベル
        private var target : CustomButton; //マウスイベントでターゲット情報取得用
            
        public function ButtonTest() {
            label = new TextField;
            label.text = "ButtonTest!";
            label.width = 150;
            addChild(label);
            
            button01 = new CustomButton("Button01");
            button01.y = 20;
            button02 = new CustomButton("Button02");
            button02.y = 50;
            button03 = new CustomButton("Button03");
            button03.y = 80;

            button01.addEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
            button02.addEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
            button03.addEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
            
            button01.addEventListener(MouseEvent.MOUSE_UP,onMouseUp);
            button02.addEventListener(MouseEvent.MOUSE_UP,onMouseUp);
            button03.addEventListener(MouseEvent.MOUSE_UP,onMouseUp);
            
            addChild(button01);
            addChild(button02);
            addChild(button03);
        }
   
        //マウスダウンイベントの処理
        private function onMouseDown(evt:MouseEvent):void {
            target = CustomButton(evt.currentTarget); 
            label.text = "Mouse Down " + target.getBtnName();
        }

        //マウスアップイベントの処理
        private function onMouseUp(evt:MouseEvent):void {
            label.text = "Mouse Up";
        }        
    }
}

import flash.display.*;
import flash.system.*;
import flash.text.*;

//カスタムボタン
class CustomButton extends SimpleButton {
        private var btnName : String = "";//ボタン名
        //コンストラクタ    
        public function CustomButton(label:String="") {
            btnName = label;
            //状態
            upState = makeSprite(label,0x0000FF);
            overState = upState;
            downState = makeSprite(label,0xFF0000);
            hitTestState = upState;
        }
        
        public function getBtnName():String {
            return btnName;
        }
        
        //ボタン用スプライト作成
        private function makeSprite(text:String,color:uint):Sprite{
            //ボタン用ラベル作成
            var label : TextField = new TextField();
            label.text = text;
            label.autoSize = TextFieldAutoSize.CENTER;
            label.selectable = false;

            //ボタン用スプライト作成
            var sp:Sprite = new Sprite();
            sp.graphics.beginFill(color);
            sp.graphics.drawRoundRect(0, 0, 100, 20, 15);
            sp.graphics.endFill();
            sp.alpha = 0.8;            
            sp.addChild(label);
            
            //ラベル用フォーマット設定
            var format:TextFormat=new TextFormat();
            format.font = "Courier New";
            format.bold = true;
            format.size = 13;
            label.setTextFormat(format);

            return sp;
        }    
}



