/**
 * Copyright northprint ( http://wonderfl.net/user/northprint )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ofDn
 */

// forked from checkmate's Progression4 Professional
// forked from test_doke's flash on 2009-9-29
// 10/20 3枚目に血しぶき追加。これでいいかな
// パーティクルはdokeさんの習作を大変参考にさせていただきました。重いけど
// http://wonderfl.net/code/463cf04958f4ec265ce639a22d87a905af7c60e3
package {
        import caurina.transitions.Equations;
        import flash.display.*;
        import jp.progression.commands.*;
        import jp.progression.commands.display.*;
        import jp.progression.commands.lists.*;
        import jp.progression.commands.net.*;
        import jp.progression.commands.tweens.*;
        import jp.progression.*;

        [SWF( width=465, height=465, backgroundColor=0xFFFFFF, frameRate=30 )]
        public class Professional extends Sprite {

                public var manager:Progression, self:Professional;
                
                // Graphics
                public var scene1_Balloon1:MovieClip, scene1_Balloon2:MovieClip, scene1_Brother:MovieClip;
                public var scene2_Brother:MovieClip, scene2_Shout:MovieClip;
                public var scene3_Brother:MovieClip, scene3_CutIn1:MovieClip, scene3_CutIn2:MovieClip, scene3_SE:MovieClip, scene3_Sister:MovieClip;
                public var scene4_Balloon:MovieClip, scene4_Brother:MovieClip, scene4_Sister:MovieClip;

                public var scene1_Light:LightBar;
                
                // First Scene
                public function introduction():void {
                        manager.current.addCommand(
                                new RemoveAllChildren( self ),
                                [
                                        
                                        [
                                                new Prop( scene1_Brother, { y:-100 } ),
                                                new AddChild( self, scene1_Brother ),
                                                new DoTweener( scene1_Brother, { y:335, time:5 } )
                                        ],
                                        [
                                               new  AddChild( self, new LightBar() ),
                                        ],
                                        [
                                                1,
                                                new Prop( scene1_Balloon1, { alpha:0 } ),
                                                new AddChild( self, scene1_Balloon1 ),
                                                new DoTweener( scene1_Balloon1, { alpha:1, time:1 } )
                                        ],
                                        [
                                                2,
                                                new Prop( scene1_Balloon2, { alpha:0 } ),
                                                new AddChild( self, scene1_Balloon2 ),
                                                new DoTweener( scene1_Balloon2, { alpha:1, time:1 } )
                                        ]
                                ]
                        );
                }

                // Second Scene
                public function development():void {
                        manager.current.addCommand(
                                new RemoveAllChildren( self ),
                                [
                                        [
                                               new  AddChild( self, new NoiseBase() ),
                                        ],
                                        [
                                                new Prop( scene2_Brother, { scaleX:0.3, scaleY:0.3 } ),
                                                new AddChild( self, scene2_Brother ),
                                                new DoTweener( scene2_Brother, { scaleX:1, scaleY:1, time:1, transition:Equations.easeOutElastic } )
                                        ],
                                        [
                                                0.1,
                                                new Prop( scene2_Shout, { scaleX:0.3, scaleY:0.3 } ),
                                                new AddChild( self, scene2_Shout ),
                                                new DoTweener( scene2_Shout, { scaleX:1, scaleY:1, time:1, transition:Equations.easeOutElastic } )
                                        ]
                                ]
                        );
                }

                // Third Scene
                public function turn():void {
                        var bd1:BitmapData = new BitmapData( stage.stageWidth, stage.stageHeight, true, 0x00 );
                        var bd2:BitmapData = new BitmapData( stage.stageWidth, stage.stageHeight, true, 0x00 );
                        var bd3:BitmapData = new BitmapData( stage.stageWidth, stage.stageHeight, true, 0x00 );
                        var bd4:BitmapData = new BitmapData( stage.stageWidth, stage.stageHeight, true, 0x00 );
                        var bd5:BitmapData = new BitmapData( stage.stageWidth, stage.stageHeight, true, 0x00 );
                        var bm1:Bitmap = new Bitmap(bd1);
                        var bm2:Bitmap = new Bitmap(bd2);
                        var bm3:Bitmap = new Bitmap(bd3);
                        var bm4:Bitmap = new Bitmap(bd4);
                        var bm5:Bitmap = new Bitmap(bd5);
                        var mc:MovieClip = new MovieClip();
                        var base:Sprite = new Sprite();
                        manager.current.addCommand(
                                new RemoveAllChildren( self ),
                                [
                                        [
                                                new Prop( scene3_Brother, { x:130, scaleX:0.7, scaleY:0.7 } ),
                                                new AddChild( self, scene3_Brother ),
                                                new DoTweener( scene3_Brother, { x:310, scaleX:1, scaleY:1, time:1, transition:Equations.easeOutElastic } )
                                        ],
                                        [
                                                new Prop( scene3_Sister, { x:-300, scaleX:0.7, scaleY:0.7 } ),
                                                new AddChild( self, scene3_Sister ),
                                                new DoTweener( scene3_Sister, { x:0, scaleX:1, scaleY:1, time:1, transition:Equations.easeOutElastic } )
                                        ],
                                        new AddChild( self, scene3_CutIn1 ),
                                        new AddChild( self, scene3_CutIn2 ),
                                        [
                                                new Prop( scene3_SE, { scaleX:0.3, scaleY:0.3 } ),
                                                new AddChild( self, scene3_SE ),
                                                new DoTweener( scene3_SE, { scaleX:1, scaleY:1, time:1, transition:Equations.easeOutElastic } ),
                                                [
                                                new AddChild(base, mc),
                                                new AddChild(base, bm1),
                                                new AddChild(base, bm2),
                                                new AddChild(base, bm3),
                                                new AddChild(base, bm4),
                                                new AddChild(base, bm5),
                                                new AddChild(self, base)
                                                ],
                                                new Bloodstain(base, mc, bd1, Math.random() * (stage.stageWidth), Math.random() * 200 + 100, Math.random() * 10 + 5, 0xff0000, Math.random() * 10 + 20, Math.random() * 20 + 5),
                                                new Bloodstain(base, mc, bd2, Math.random() * (stage.stageWidth), Math.random() * 200 + 100, Math.random() * 15 + 15, 0xff0000, Math.random() * 10 + 20, Math.random() * 20 + 5),
                                                new Wait(0.3),
                                                new Bloodstain(base, mc, bd3, Math.random() * (stage.stageWidth), Math.random() * 200 + 100, Math.random() * 10 + 10, 0xff0000, Math.random() * 10 + 20, Math.random() * 20 + 5),
                                                new Bloodstain(base, mc, bd4, Math.random() * (stage.stageWidth), Math.random() * 200 + 100, Math.random() * 10 + 20, 0xff0000, Math.random() * 10 + 20, Math.random() * 20 + 5),
                                                new Bloodstain(base, mc, bd5, Math.random() * (stage.stageWidth), Math.random() * 200 + 100, Math.random() * 10 + 10, 0xff0000, Math.random() * 10 + 20, Math.random() * 20 + 5)
                                        ]
                                ]
                        );
                }

                // Fourth Scene
                public function conclusion():void {
                        manager.current.addCommand(
                                new RemoveAllChildren( self ),
                                [
                                        [
                                                new Prop( scene4_Brother, { x:162, y:266, scaleX:1.5, scaleY:1.5 } ),
                                                new AddChild( self, scene4_Brother ),
                                                new DoTweener( scene4_Brother, { x:112, y:136, scaleX:1, scaleY:1, time:4, transition:Equations.easeOutCubic } )
                                        ],
                                        [
                                                1,
                                                new Prop( scene4_Sister, { x:416, y:505, scaleX:1.3, scaleY:1.3 } ),
                                                new AddChild( self, scene4_Sister ),
                                                new DoTweener( scene4_Sister, { x:316, y:485, scaleX:1, scaleY:1, time:3, transition:Equations.easeOutCubic } )
                                        ],
                                        [
                                                2,
                                                new Prop( scene4_Balloon, { rotation:-5, scaleX:0.7, scaleY:0.7 } ),
                                                new AddChild( self, scene4_Balloon ),
                                                new DoTweener( scene4_Balloon, { rotation:0, scaleX:1, scaleY:1, time:0.5, transition:Equations.easeOutElastic } )
                                        ]
                                ]
                        );
                }



                public function Professional() {
                        CheckmateBuilder.initialize( this );
                }
        }
}


import flash.system.*;
import flash.display.*;
import flash.events.*;
import flash.filters.*;
import flash.net.URLRequest;
import flash.system.ApplicationDomain;
import flash.text.*;
import flash.utils.Timer;
import jp.progression.casts.*;
import jp.progression.commands.*;
import jp.progression.commands.lists.*;
import jp.progression.commands.net.*;
import jp.progression.commands.tweens.*;
import jp.progression.config.*;
import jp.progression.data.*;
import jp.progression.events.*;
import jp.progression.scenes.*;
import jp.progression.*;

class CheckmateBuilder extends EventDispatcher {

        public static var GRAPHICS_URL:String = "http://swf.wonderfl.net/static/assets/checkmate04/ProfessionalAssets.swf";
        public static var GRAPHICS_URL2:String = "http://www.northprint.net/progression_test/alien.swf";

        private static var _target:Professional;
        private static var _manager:Progression;

        private static var _button:CastButton;

        public static function initialize( target:Professional ):void {
                if ( _target ) { return; }
                
                Security.allowDomain("http://www.northprint.net/");
                
                _target = target;
                _target.self = target;

                Progression.initialize( new BasicAppConfig() );
                _manager = new Progression( "index", _target.stage );

                var introduction:SceneObject = _manager.root.addScene( new SceneObject( "introduction" ) );
                var development:SceneObject = _manager.root.addScene( new SceneObject( "development" ) );
                var turn:SceneObject = _manager.root.addScene( new SceneObject( "turn" ) );
                var conclusion:SceneObject = _manager.root.addScene( new SceneObject( "conclusion" ) );

                _manager.root.addEventListener( SceneEvent.SCENE_LOAD, _rootSceneLoad );
                introduction.addEventListener( SceneEvent.SCENE_INIT, _introduction );
                development.addEventListener( SceneEvent.SCENE_INIT, _development );
                turn.addEventListener( SceneEvent.SCENE_INIT, _turn );
                conclusion.addEventListener( SceneEvent.SCENE_INIT, _conclusion );

                _target.manager = _manager;

                _manager.goto( introduction.sceneId );
        }

        private static function _rootSceneLoad( e:SceneEvent ):void {
                _manager.current.addCommand(
                        new LoadSWF( new URLRequest( GRAPHICS_URL ) ),
                        function():void {
                                var loader:Loader = Loader( this.latestData );
                                var domain:ApplicationDomain = loader.contentLoaderInfo.applicationDomain;
                                _target.scene3_CutIn1 = new ( domain.getDefinition( "scene3.CutIn1" ) as Class );
                                _target.scene3_CutIn1.x = -226;
                                _target.scene3_CutIn1.y = -70;

                                _target.scene3_CutIn2 = new ( domain.getDefinition( "scene3.CutIn2" ) as Class );
                                _target.scene3_CutIn2.x = -226;
                                _target.scene3_CutIn2.y = 312;
                                _target.scene3_SE = new ( domain.getDefinition( "scene3.SE" ) as Class );
                                _target.scene3_SE.x = 259;
                                _target.scene3_SE.y = 237;

                                _target.scene3_Sister = new ( domain.getDefinition( "scene3.Sister" ) as Class );
                                _target.scene3_Sister.x = 0;
                                _target.scene3_Sister.y = 387;
                                _target.scene4_Sister = new ( domain.getDefinition( "scene4.Sister" ) as Class );
                                _target.scene4_Sister.x = 316;
                                _target.scene4_Sister.y = 485;

                                var frameBorder:MovieClip = new ( domain.getDefinition( "ui.FrameBorder" ) as Class );

                                var nextButton:MovieClip = new ( domain.getDefinition( "ui.NextButton" ) as Class );
                                nextButton.managerId = "index";
                                nextButton.x = 435;
                                nextButton.y = 30;
                                nextButton.addEventListener( CastMouseEvent.CAST_NAVIGATE_BEFORE, _castNavigateBefore );

                                var previousButton:MovieClip = new ( domain.getDefinition( "ui.PreviousButton" ) as Class );
                                previousButton.managerId = "index";
                                previousButton.x = 30;
                                previousButton.y = 30;
                                previousButton.addEventListener( CastMouseEvent.CAST_NAVIGATE_BEFORE, _castNavigateBefore );

                                _target.stage.addChild( frameBorder );
                                _target.stage.addChild( nextButton );
                                _target.stage.addChild( previousButton );
                        },
                        new LoadSWF( new URLRequest( GRAPHICS_URL2 ), null, {context:new LoaderContext(true, ApplicationDomain.currentDomain)}),
                        function():void {
                                var loader:Loader = Loader( this.latestData );
                                var domain:ApplicationDomain = loader.contentLoaderInfo.applicationDomain;

                                _target.scene1_Balloon1 = new ( domain.getDefinition( "scene1.Balloon3" ) as Class );
                                _target.scene1_Balloon1.x = 106;
                                _target.scene1_Balloon1.y = 200;

                                _target.scene1_Balloon2 = new ( domain.getDefinition( "scene1.Balloon4" ) as Class );
                                _target.scene1_Balloon2.x = 345;
                                _target.scene1_Balloon2.y = 237;

                                _target.scene1_Brother = new ( domain.getDefinition( "scene1.Alien" ) as Class );
                                _target.scene1_Brother.x = 228;
                                _target.scene1_Brother.y = 302;

                                _target.scene2_Brother = new ( domain.getDefinition( "scene2.Alien" ) as Class );
                                _target.scene2_Brother.x = 240;
                                _target.scene2_Brother.y = 325;

                                _target.scene2_Shout = new ( domain.getDefinition( "scene2.Shout2" ) as Class );
                                _target.scene2_Shout.x = 235;
                                _target.scene2_Shout.y = 140;

                                _target.scene3_Brother = new ( domain.getDefinition( "scene3.Alien" ) as Class );
                                _target.scene3_Brother.x = 230;
                                _target.scene3_Brother.y = 230;
                                
                                _target.scene4_Balloon = new ( domain.getDefinition( "scene4.Balloon2" ) as Class );
                                _target.scene4_Balloon.x = 80;
                                _target.scene4_Balloon.y = 370;

                                _target.scene4_Brother = new ( domain.getDefinition( "scene4.Alien" ) as Class );
                                _target.scene4_Brother.x = 112;
                                _target.scene4_Brother.y = 156;                               
                        }                        
                );
        }

        private static function _introduction( e:SceneEvent ):void {
                _target.introduction();
        }

        private static function _introductionInit( e:SceneEvent ):void {
                _target.introduction();
        }

        private static function _development( e:SceneEvent ):void {
                _target.development();
        }

        private static function _turn( e:SceneEvent ):void {
                _target.turn();
        }

        private static function _conclusion( e:SceneEvent ):void {
                _target.conclusion();
        }

        private static function _castNavigateBefore( e:CastMouseEvent ):void {
                _target.manager.stop();
        }
}

class LightBar extends CastSprite {
    public function LightBar(initObject:Object = null) {
        super(initObject);
        graphics.beginFill(0xffff00);
        graphics.drawRect(0,0,200,465);
        graphics.endFill();
        alpha = 0.6;
    }
    protected override function atCastAdded():void {
        addCommand(
            new Prop(this,{x:132,y:-460}),
            new DoTweener(this,{y:0,time:2,transition:"Liner"})
        );
    }
}

class NoiseBase extends CastMovieClip{
    private var _noiseBitmapdata:BitmapData;
    private var _noiseBitMap:Bitmap;
    private var _channelOptions:Number;
    public function NoiseBase(initObject:Object = null){
        super(initObject);
    }
    protected override function atCastAdded():void {
        _channelOptions = (1 * 0) + (2 * 1) + (4 * 1);
        _noiseBitmapdata = new BitmapData(stage.width, stage.height, true, 0x00ffffff);
        _noiseBitMap = new Bitmap(_noiseBitmapdata);
        addEventListener(Event.ENTER_FRAME, noiseChange);
        addChild(_noiseBitMap);
    }
    protected override function atCastRemoved():void {
        removeEventListener(Event.ENTER_FRAME, noiseChange);
        _noiseBitmapdata.dispose();
        removeChild(_noiseBitMap);
        _noiseBitMap = null;
    }
    private function noiseChange(e:Event):void {
        var randomSeed:Number = int(Math.random() * 100);
        _noiseBitmapdata.noise(randomSeed, 0, 255, _channelOptions, false);
    }
}

class Bloodstain extends Command {
	private var _stage:DisplayObjectContainer;
	private var _containerMc:MovieClip;
	private var _canvas:BitmapData;
	private var _x:int;
	private var _y:int;
	private var _radius:int;
	private var _color:int;
	private var _splashNum:int;
	private var _splashLen:int;
	private var _b:Blood;
		
	public function Bloodstain(stage:DisplayObjectContainer,containerMc:MovieClip, canvas:BitmapData, x:int = 0, y:int = 0, radius:int = 0, color:int = 0xff0000, splashNum:int = 10, splashLen:int = 10, initObject:Object = null ) {
		super( _execute, _interrupt, initObject );
		_stage = stage;
		_containerMc = containerMc;
		_canvas = canvas;
		_x = x;
		_y = y;
		_radius = radius;
		_color = color;
		_splashNum = splashNum;
		_splashLen = splashLen;
	}
		
	private function _execute():void {			
		_b = new Blood(_splashNum, _splashLen, _radius, _color);
		_containerMc.addEventListener(Event.ENTER_FRAME, enterframeHandler);
		_b.x = _x;
		_b.y = _y;
		_b.add(DisplayObjectContainer(_containerMc), _radius, _color);
			
		executeComplete();
	}
		
	private function enterframeHandler(e:Event):void {
		_canvas.lock();
		_b.draw( _stage , _canvas );
		_canvas.unlock();
			
		if (_b.status == 1) {
			_containerMc.removeEventListener(Event.ENTER_FRAME, enterframeHandler);
		}
			
	}
		
	private function _interrupt():void {
		if (_b.status == 0) {
			_containerMc.removeEventListener(Event.ENTER_FRAME, enterframeHandler);
		}
	}
		
	public override function clone():Command {
		return new Bloodstain(_stage, _containerMc, _canvas, _x, _y, _radius, _color, _splashNum, _splashLen);
	}		
}

class Blood {
    public var x:Number = 0;
    public var y:Number = 0;
	private var _particles:Array = new Array();
	private var _status:int = 0;
	private var _baseradius:int;
	
    public function Blood(volume:int, radius:int ,baseradius:int = 10, color:int = 0xff0000) {
        const RADIAN :Number = 2 * Math.PI;
		_baseradius = baseradius;
        for( var i:int=0; i<volume; ++i ) {
            var angle:Number = Math.random() * RADIAN;
            var p:Particle = new Particle(color);
            p.x  = 0;
            p.y  = 0;
            p.vx = Math.cos(angle);
            p.vy = Math.sin(angle);	
            p.life = (Math.random() * _baseradius + radius) / 5;
            _particles.push(p);
        }
    }
	public function add(container:DisplayObjectContainer , radius:int, color:int = 0xff0000):void {
		var circle:Sprite = new Sprite();
		circle.graphics.beginFill(color);
		circle.graphics.drawCircle(0, 0, radius);
		circle.graphics.endFill();
		circle.x = x;
		circle.y = y;
		container.addChild(circle);
		
		for each( var p:Particle in _particles ) {
            p.x  = x +  (p.vx * _baseradius);
            p.y  = y +  (p.vy * _baseradius);
			container.addChild(p);
		}
	}
	public function draw( container:DisplayObjectContainer, canvas:BitmapData ) :void {	
		for each( var p:Particle in _particles ) {
			if( p.life > 0 ) {
				p.x += p.vx * 3;
				p.y += p.vy * 3;
				p.scaleX -= 0.2;
				p.scaleY -= 0.2;
								
				canvas.draw(container);
				p.life--;
				_status = 0;
			} else {
				_status = 1;
			}
		}    
	}
	
	public function get status():int { return _status; }
}

class Particle extends Sprite{
	public var vx:Number;
	public var vy:Number;
	public var life:Number;
	public function Particle(color:int = 0xff0000) {
		graphics.beginFill(color);
		graphics.drawCircle(0, 0, 2);
		graphics.endFill();
	}
}