/**
 * Copyright aaharu ( http://wonderfl.net/user/aaharu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oe2z
 */

// forked from aaharu's Away3D test
/*
Away3Dが使えるようになったらしいので、適当に流用
いろいろと無駄が多いよ！
*/

package {
    import away3d.cameras.HoverCamera3D;
    import away3d.containers.ObjectContainer3D;
    import away3d.containers.Scene3D;
    import away3d.containers.View3D;
    import away3d.events.MouseEvent3D;
    import away3d.lights.DirectionalLight3D;
    import away3d.loaders.Collada;
    import away3d.materials.PhongMovieMaterial;
    
    import flash.geom.Vector3D;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    public class PaintModel extends Sprite {
        public var scene:Scene3D;
        private var camera:HoverCamera3D;
        private var view:View3D;
        // ライト
        public var light:DirectionalLight3D;
        private var isMouseDown:Boolean = false;
        // カメラ移動用変数
        private var lastPanAngle:Number;
        private var lastTiltAngle:Number;
        private var lastMouseX:Number;
        private var lastMouseY:Number;
        // モデルオブジェクト
        public var model:ObjectContainer3D;
        private var mc:MovieClip;
        
        /**
         * constructor
         */
        public function PaintModel() {
            if(stage) {
                initEngine();
            } else {
                addEventListener(Event.ADDED_TO_STAGE, onAdded);
            }
        }
        
        private function onAdded(e:Event):void {
            removeEventListener(Event.ADDED_TO_STAGE, onAdded);
            initEngine();
        }
        
        /**
         * Initialize the engine
         */
        private function initEngine():void {
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            stage.addEventListener(Event.RESIZE, onResize);
            
            scene = new Scene3D();
            // カメラ初期設定
            camera = new HoverCamera3D();
            camera.zoom = 2;
            camera.focus = 100;
            camera.distance = 300;
            camera.minTiltAngle = -90;
            camera.panAngle = -10;
            camera.tiltAngle = 20;
            
            view = new View3D({camera: camera, scene: scene, stats: true, x: stage.stageWidth / 2, y: stage.stageHeight / 2});
            addChild(view);
            LoadModel();
            initLights();
        }
        
        private function LoadModel():void {
            var collada:XML = <COLLADA xmlns="http://www.collada.org/2005/11/COLLADASchema" version="1.4.1">
  <asset>
    <contributor>
      <author>s1140131</author>
      <authoring_tool>3dsMax 8 - Feeling ColladaMax v3.05B.</authoring_tool>
      <comments>ColladaMax Export Options: ExportNormals=1;ExportEPolyAsTriangles=1;ExportXRefs=1;ExportSelected=0;ExportTangents=0;ExportAnimations=0;SampleAnim=0;ExportAnimClip=0;BakeMatrices=0;ExportRelativePaths=1;AnimStart=0;AnimEnd=3.33333;</comments>
      <source_data>file:///C:/Documents%20and%20Settings/s1140131/%83f%83X%83N%83g%83b%83v/otake.max</source_data>
    </contributor>
    <created>2010-02-12T11:24:36Z</created>
    <modified>2010-02-12T11:24:44Z</modified>
    <unit meter="0.0254" name="inch"/>
    <up_axis>Z_UP</up_axis>
  </asset>
  <library_images>
    <image id="lena.jpg" name="lena_jpg">
      <init_from></init_from>
    </image>
  </library_images>
  <library_materials>
    <material id="mat1" name="mat1">
      <instance_effect url="#mat1-fx"/>
      <extra>
        <technique profile="FCOLLADA">
          <dynamic_attributes>
            <DirectX____l___W__ sid="DirectX____l___W__">
              <enabled type="bool">0</enabled>
              <effect type="int">0</effect>
              <dxStdMat type="bool">0</dxStdMat>
            </DirectX____l___W__>
          </dynamic_attributes>
        </technique>
      </extra>
    </material>
  </library_materials>
  <library_effects>
    <effect id="mat1-fx" name="mat1">
      <profile_COMMON>
        <newparam sid="lena_jpg-surface">
          <surface type="2D">
            <init_from>lena.jpg</init_from>
            <format>A8R8G8B8</format>
          </surface>
        </newparam>
        <newparam sid="lena_jpg-sampler">
          <sampler2D>
            <source>lena_jpg-surface</source>
            <wrap_s>WRAP</wrap_s>
            <wrap_t>WRAP</wrap_t>
            <minfilter>NONE</minfilter>
            <magfilter>NONE</magfilter>
            <mipfilter>NONE</mipfilter>
          </sampler2D>
        </newparam>
        <technique sid="common">
          <blinn>
            <ambient>
              <color>0.588 0.588 0.588 1</color>
            </ambient>
            <diffuse>
              <texture texture="lena_jpg-sampler" texcoord="CHANNEL1">
                <extra>
                  <technique profile="MAYA">
                    <mirrorU>0</mirrorU>
                    <mirrorV>0</mirrorV>
                    <wrapU>1</wrapU>
                    <wrapV>1</wrapV>
                    <repeatU>-4.1</repeatU>
                    <repeatV>-4.1</repeatV>
                    <offsetU>2.55</offsetU>
                    <offsetV>2.55</offsetV>
                    <rotateUV>0</rotateUV>
                  </technique>
                  <technique profile="MAX3D">
                    <amount>1</amount>
                  </technique>
                </extra>
              </texture>
            </diffuse>
            <specular>
              <color>0.9 0.9 0.9 1</color>
            </specular>
            <shininess>
              <float>0.1</float>
            </shininess>
            <reflective>
              <color>0 0 0 1</color>
            </reflective>
            <reflectivity>
              <float>1</float>
            </reflectivity>
            <transparent opaque="A_ONE">
              <color>1 1 1 1</color>
            </transparent>
            <transparency>
              <float>1</float>
            </transparency>
          </blinn>
          <extra>
            <technique profile="FCOLLADA">
              <spec_level>
                <float>0</float>
              </spec_level>
              <emission_level>
                <float>0</float>
              </emission_level>
            </technique>
          </extra>
        </technique>
      </profile_COMMON>
      <extra>
        <technique profile="MAX3D">
          <faceted>0</faceted>
          <double_sided>0</double_sided>
          <wireframe>0</wireframe>
          <face_map>0</face_map>
        </technique>
      </extra>
    </effect>
  </library_effects>
  <library_geometries>
    <geometry id="___C_____layer1-mesh" name="___C_____layer1">
      <mesh>
        <source id="___C_____layer1-mesh-positions">
          <float_array id="___C_____layer1-mesh-positions-array" count="1140">-224.322 109.352 81.6464 -117.1 -80.392 42.621 -95.4609 -80.392 80.1012 -182.869 109.352 153.445 -41.4529 109.352 235.091 -21.6392 -80.392 122.722 21.6392 -80.392 122.722 119.359 109.352 206.736 182.869 109.352 153.445 124.615 -80.392 0 238.718 109.352 0 117.1 -80.392 -42.621 224.322 109.352 -81.6464 182.868 109.352 -153.445 119.359 109.352 -206.736 62.3077 -80.392 -107.92 -41.453 109.352 -235.091 -119.359 109.352 -206.736 -182.869 109.352 -153.445 -224.322 109.352 -81.6463 -237.636 116.804 0 -234.164 117.071 0 -220.042 117.071 80.0888 -118.818 116.804 205.799 -117.082 117.071 202.792 -40.6621 117.071 230.607 -41.2651 116.804 234.026 40.6622 117.071 230.607 117.082 117.071 202.792 182.04 116.804 152.749 179.38 117.071 150.518 220.042 117.071 80.0888 223.305 116.804 81.2763 223.305 116.804 -81.2764 179.38 117.071 -150.518 118.818 116.804 -205.799 117.082 117.071 -202.792 41.2651 116.804 -234.026 -40.6623 117.071 -230.607 -41.2652 116.804 -234.026 -118.818 116.804 -205.799 -117.082 117.071 -202.792 -223.305 116.804 -81.2763 -220.042 117.071 -80.0887 -238.718 109.352 0 -223.305 116.804 81.2764 -182.04 116.804 152.75 -119.359 109.352 206.736 41.2651 116.804 234.026 41.453 109.352 235.091 118.818 116.804 205.799 224.322 109.352 81.6463 237.636 116.804 0 182.04 116.804 -152.75 41.4529 109.352 -235.091 -182.04 116.804 -152.749 -56.2794 -45.0554 0 -43.1125 -45.0554 36.1757 -9.7728 -45.0554 55.4244 5.5986 -48.2605 31.7511 28.1397 -45.0554 48.7394 24.698 -48.2605 20.7241 43.1125 -45.0554 36.1757 56.2794 -45.0554 0 32.2409 -48.2605 0 43.1125 -45.0554 -36.1757 9.7728 -45.0554 -55.4244 16.1205 -48.2605 -27.9215 -9.7728 -45.0554 -55.4244 -16.1205 -48.2605 -27.9215 -52.8853 -45.0554 -19.2487 -24.698 -48.2605 -20.7241 -74.2191 -40.2477 27.0136 -52.8853 -45.0554 19.2487 -60.504 -40.2477 50.7689 -28.1397 -45.0554 48.7394 9.7728 -45.0554 55.4244 74.2192 -40.2477 27.0135 52.8853 -45.0554 19.2487 74.2191 -40.2477 -27.0136 52.8853 -45.0554 -19.2487 28.1397 -45.0554 -48.7394 13.7151 -40.2477 -77.7825 -39.4912 -40.2477 -68.4007 -28.1397 -45.0554 -48.7394 -60.504 -40.2477 -50.7689 -43.1125 -45.0554 -36.1757 -108.363 -25.5575 0 -101.828 -25.5575 37.0622 -54.1814 -25.5575 93.8449 -39.4912 -40.2477 68.4007 -18.817 -25.5575 106.716 -13.7151 -40.2477 77.7825 18.817 -25.5575 106.716 13.7152 -40.2477 77.7824 39.4912 -40.2477 68.4007 60.504 -40.2477 50.7689 101.828 -25.5575 37.0622 108.363 -25.5575 0 78.9824 -40.2477 0 83.0107 -25.5575 -69.6542 60.504 -40.2477 -50.7689 39.4912 -40.2477 -68.4007 18.817 -25.5575 -106.716 -18.817 -25.5575 -106.716 -13.7152 -40.2477 -77.7824 -54.1814 -25.5575 -93.8448 -83.0107 -25.5575 -69.6542 -74.2192 -40.2477 -27.0135 -101.828 -25.5575 -37.0622 -78.9824 -40.2477 0 -129.73 -11.1344 0 -99.3791 -11.1344 83.389 -83.0107 -25.5575 69.6542 64.8651 -11.1344 112.35 54.1814 -25.5575 93.8449 83.0107 -25.5575 69.6542 101.828 -25.5575 -37.0623 99.3791 -11.1344 -83.389 54.1814 -25.5575 -93.8449 -99.3791 -11.1344 -83.3889 -121.907 -11.1344 -44.3703 -121.907 -11.1344 44.3703 -113.701 7.5622 95.4069 -74.2134 7.5622 128.541 -25.774 7.5622 146.172 -64.8651 -11.1344 112.35 25.7741 7.5622 146.172 -22.5274 -11.1344 127.759 74.2134 7.5622 128.541 22.5274 -11.1344 127.759 99.3791 -11.1344 83.3889 121.907 -11.1344 44.3703 148.427 7.5622 0 139.475 7.5622 -50.765 129.73 -11.1344 0 121.907 -11.1344 -44.3704 113.701 7.5622 -95.4069 74.2134 7.5622 -128.541 64.8651 -11.1344 -112.35 22.5274 -11.1344 -127.759 -22.5275 -11.1344 -127.759 -25.7741 7.5622 -146.172 -64.8651 -11.1344 -112.35 -74.2134 7.5622 -128.541 -113.701 7.5622 -95.4069 -148.427 7.5622 0 -139.475 7.5622 50.7649 -83.0275 29.1968 143.808 -28.8351 29.1968 163.532 28.8352 29.1968 163.532 113.701 7.5622 95.4069 156.041 29.1968 56.7941 139.476 7.5622 50.7649 166.055 29.1968 0 156.041 29.1968 -56.7942 127.205 29.1968 -106.738 83.0275 29.1968 -143.808 25.774 7.5622 -146.172 -28.8352 29.1968 -163.532 -83.0275 29.1968 -143.808 -127.205 29.1968 -106.738 -139.476 7.5622 -50.7649 -166.055 29.1968 0 -156.041 29.1968 56.7941 -127.205 29.1968 106.738 -110.405 102.114 191.226 110.405 102.114 191.226 83.0275 29.1968 143.808 207.493 102.114 75.5212 127.205 29.1968 106.738 28.8351 29.1968 -163.532 -110.405 102.114 -191.226 -169.15 102.114 -141.933 -220.809 102.114 0 -156.041 29.1968 -56.7941 -179.38 117.071 150.518 -207.493 102.114 75.5212 -169.15 102.114 141.934 -38.3431 102.114 217.455 38.3432 102.114 217.455 169.15 102.114 141.933 234.164 117.071 0 220.042 117.071 -80.0888 220.809 102.114 0 207.493 102.114 -75.5213 169.15 102.114 -141.934 110.405 102.114 -191.226 40.6621 117.071 -230.607 38.3431 102.114 -217.455 -38.3432 102.114 -217.455 -179.38 117.071 -150.518 -207.493 102.114 -75.5212 -94.7008 -80.8193 0 -72.5451 -80.8193 60.8725 -62.3077 -80.392 107.92 -47.3504 -80.8193 82.0133 47.3504 -80.8193 82.0133 62.3077 -80.392 107.92 88.9897 -80.8193 32.3896 95.4609 -80.392 80.1012 117.1 -80.392 42.621 94.7008 -80.8193 0 95.4609 -80.392 -80.1012 47.3504 -80.8193 -82.0133 16.4446 -80.8193 -93.2621 -16.4447 -80.8193 -93.2621 21.6392 -80.392 -122.722 -47.3505 -80.8193 -82.0133 -21.6393 -80.392 -122.722 -72.5451 -80.8193 -60.8725 -62.3077 -80.392 -107.92 -95.4609 -80.392 -80.1012 -117.1 -80.392 -42.6209 -88.9897 -80.8193 -32.3896 -124.615 -80.392 0 -90.596 -113.725 32.9743 -88.9897 -80.8193 32.3896 -48.2051 -113.725 83.4937 -16.4446 -80.8193 93.2621 16.7415 -113.725 94.9456 48.2051 -113.725 83.4937 16.4446 -80.8193 93.2621 72.5451 -80.8193 60.8725 90.596 -113.725 -32.9743 88.9897 -80.8193 -32.3896 73.8545 -113.725 -61.9713 72.545 -80.8193 -60.8725 -16.7415 -113.725 -94.9456 -90.596 -113.725 -32.9742 -96.4103 -113.725 0 -87.7724 -117.071 31.9466 -73.8545 -113.725 61.9713 -71.5527 -117.071 60.0399 -16.7415 -113.725 94.9456 -16.2197 -117.071 91.9864 46.7027 -117.071 80.8915 73.8546 -113.725 61.9713 71.5527 -117.071 60.0399 90.596 -113.725 32.9742 96.4103 -113.725 0 93.4055 -117.071 0 48.2051 -113.725 -83.4937 16.7415 -113.725 -94.9456 -16.2197 -117.071 -91.9864 -48.2052 -113.725 -83.4937 -73.8546 -113.725 -61.9713 -87.7724 -117.071 -31.9465 -93.4055 -117.071 0 -90.0668 -116.403 0 -68.9952 -116.403 57.8938 -46.7027 -117.071 80.8915 -45.0334 -116.403 78.0001 15.6399 -116.403 88.6985 16.2197 -117.071 91.9864 45.0334 -116.403 78.0001 68.9952 -116.403 57.8938 84.6351 -116.403 30.8046 90.0668 -116.403 0 87.7724 -117.071 31.9465 87.7724 -117.071 -31.9466 84.6351 -116.403 -30.8047 71.5527 -117.071 -60.0399 68.9951 -116.403 -57.8938 46.7027 -117.071 -80.8915 16.2197 -117.071 -91.9864 -46.7028 -117.071 -80.8915 -68.9952 -116.403 -57.8938 -71.5527 -117.071 -60.0399 -87.062 -113.231 0 -81.8115 -113.231 29.7769 -66.6933 -113.231 55.9624 -84.6351 -116.403 30.8047 -43.531 -113.231 75.3979 -15.1181 -113.231 85.7393 -15.6399 -116.403 88.6985 43.531 -113.231 75.3979 66.6934 -113.231 55.9623 87.062 -113.231 0 43.531 -113.231 -75.3979 45.0334 -116.403 -78.0001 15.1181 -113.231 -85.7393 -15.1182 -113.231 -85.7393 15.6399 -116.403 -88.6985 -15.64 -116.403 -88.6985 -45.0334 -116.403 -78.0001 -81.8115 -113.231 -29.7769 -84.6351 -116.403 -30.8046 -62.2176 -96.037 52.2068 -40.6096 -96.037 70.338 -14.1036 -96.037 79.9854 15.1182 -113.231 85.7393 40.6096 -96.037 70.338 76.3212 -96.037 27.7786 81.8115 -113.231 29.7769 81.2193 -96.037 0 76.3212 -96.037 -27.7787 81.8115 -113.231 -29.777 40.6096 -96.037 -70.338 66.6933 -113.231 -55.9624 -14.1036 -96.037 -79.9854 -43.531 -113.231 -75.3979 -40.6097 -96.037 -70.338 -76.3212 -96.037 -27.7786 -66.6934 -113.231 -55.9623 -81.2193 -96.037 0 -74.2819 -84.5186 27.0364 -76.3212 -96.037 27.7786 13.7268 -84.5186 77.8482 14.1036 -96.037 79.9854 60.5552 -84.5186 50.8118 62.2176 -96.037 52.2067 79.0492 -84.5186 0 62.2176 -96.037 -52.2068 14.1036 -96.037 -79.9854 -62.2176 -96.037 -52.2067 -74.2819 -84.5186 -27.0364 -79.0492 -84.5186 0 -60.5552 -84.5186 50.8118 -39.5246 -84.5186 68.4586 -30.1763 -86.3549 52.2669 -13.7267 -84.5186 77.8482 -10.4801 -86.3549 59.4357 39.5246 -84.5186 68.4586 46.2328 -86.3549 38.7939 60.3526 -86.3549 0 74.2819 -84.5186 27.0364 56.7129 -86.3549 -20.6418 74.2819 -84.5186 -27.0364 60.5552 -84.5186 -50.8118 46.2327 -86.3549 -38.7939 30.1763 -86.3549 -52.2669 39.5246 -84.5186 -68.4586 13.7267 -84.5186 -77.8482 -13.7268 -84.5186 -77.8482 -39.5246 -84.5186 -68.4586 -60.5552 -84.5186 -50.8118 -60.3526 -86.3549 0 -27.222 -87.6903 9.908 -56.7129 -86.3549 20.6418 -46.2328 -86.3549 38.7939 -22.1916 -87.6903 18.6209 -14.4845 -87.6903 25.0879 -5.0304 -87.6903 28.5289 14.4845 -87.6903 25.0879 10.4801 -86.3549 59.4357 30.1763 -86.3549 52.2669 28.969 -87.6903 0 56.7129 -86.3549 20.6418 14.4845 -87.6903 -25.0879 5.0304 -87.6903 -28.5289 10.4801 -86.3549 -59.4357 -10.4801 -86.3549 -59.4357 -30.1763 -86.3549 -52.2669 -14.4845 -87.6903 -25.0879 -27.222 -87.6903 -9.908 -46.2328 -86.3549 -38.7939 -56.7129 -86.3549 -20.6418 -32.2409 -48.2605 0 -30.2966 -48.2605 11.027 -24.698 -48.2605 20.7241 -16.1205 -48.2605 27.9215 -5.5986 -48.2605 31.7511 16.1205 -48.2605 27.9215 30.2966 -48.2605 11.027 -0.000001 -49.9616 0 30.2966 -48.2605 -11.0271 24.698 -48.2605 -20.7241 5.5986 -48.2605 -31.7511 -5.5986 -48.2605 -31.7511 -30.2966 -48.2605 -11.027 -28.969 -87.6903 0 -0.000001 -87.1916 0 5.0304 -87.6903 28.5289 22.1916 -87.6903 18.6209 27.222 -87.6903 9.908 27.222 -87.6903 -9.908 22.1916 -87.6903 -18.6209 -5.0304 -87.6903 -28.5289 -22.1916 -87.6903 -18.6209</float_array>
          <technique_common>
            <accessor source="#___C_____layer1-mesh-positions-array" count="380" stride="3">
              <param name="X" type="float"/>
              <param name="Y" type="float"/>
              <param name="Z" type="float"/>
            </accessor>
          </technique_common>
        </source>
        <source id="___C_____layer1-mesh-normals">
          <float_array id="___C_____layer1-mesh-normals-array" count="6804">-0.847362 -0.509562 0.149413 -0.847362 -0.509562 0.149413 -0.847362 -0.509562 0.149413 -0.847362 -0.509562 0.149412 -0.847362 -0.509562 0.149412 -0.847362 -0.509562 0.149412 -0.745157 -0.509562 0.430217 -0.745157 -0.509562 0.430217 -0.745157 -0.509562 0.430217 -0.745157 -0.509562 0.430219 -0.745157 -0.509562 0.430219 -0.745157 -0.509562 0.430219 -0.553076 -0.509562 0.659131 -0.553076 -0.509562 0.659131 -0.553076 -0.509562 0.659131 -0.553077 -0.509562 0.65913 -0.553077 -0.509562 0.65913 -0.553077 -0.509562 0.65913 -0.294286 -0.509562 0.808543 -0.294286 -0.509562 0.808543 -0.294286 -0.509562 0.808543 -0.294285 -0.509562 0.808544 -0.294285 -0.509562 0.808544 -0.294285 -0.509562 0.808544 0 -0.509562 0.860434 0 -0.509562 0.860434 0 -0.509562 0.860434 0 -0.509562 0.860434 0 -0.509562 0.860434 0 -0.509562 0.860434 0.294286 -0.509562 0.808543 0.294286 -0.509562 0.808543 0.294286 -0.509562 0.808543 0.294285 -0.509562 0.808543 0.294285 -0.509562 0.808543 0.294285 -0.509562 0.808543 0.553076 -0.509562 0.65913 0.553076 -0.509562 0.65913 0.553076 -0.509562 0.65913 0.553077 -0.509562 0.65913 0.553077 -0.509562 0.65913 0.553077 -0.509562 0.65913 0.745158 -0.509562 0.430217 0.745158 -0.509562 0.430217 0.745158 -0.509562 0.430217 0.745157 -0.509562 0.430218 0.745157 -0.509562 0.430218 0.745157 -0.509562 0.430218 0.847362 -0.509562 0.149413 0.847362 -0.509562 0.149413 0.847362 -0.509562 0.149413 0.847362 -0.509562 0.149412 0.847362 -0.509562 0.149412 0.847362 -0.509562 0.149412 0.847362 -0.509562 -0.149413 0.847362 -0.509562 -0.149413 0.847362 -0.509562 -0.149413 0.847362 -0.509562 -0.149414 0.847362 -0.509562 -0.149414 0.847362 -0.509562 -0.149414 0.745157 -0.509562 -0.430217 0.745157 -0.509562 -0.430217 0.745157 -0.509562 -0.430217 0.745157 -0.509562 -0.430217 0.745157 -0.509562 -0.430217 0.745157 -0.509562 -0.430217 0.553076 -0.509562 -0.659131 0.553076 -0.509562 -0.659131 0.553076 -0.509562 -0.659131 0.553077 -0.509562 -0.65913 0.553077 -0.509562 -0.65913 0.553077 -0.509562 -0.65913 0.294286 -0.509562 -0.808543 0.294286 -0.509562 -0.808543 0.294286 -0.509562 -0.808543 0.294285 -0.509562 -0.808544 0.294285 -0.509562 -0.808544 0.294285 -0.509562 -0.808543 0 -0.509562 -0.860434 0 -0.509562 -0.860434 0 -0.509562 -0.860434 0 -0.509562 -0.860434 0 -0.509562 -0.860434 0 -0.509562 -0.860434 -0.294286 -0.509562 -0.808543 -0.294286 -0.509562 -0.808543 -0.294286 -0.509562 -0.808543 -0.294286 -0.509562 -0.808543 -0.294286 -0.509562 -0.808543 -0.294286 -0.509562 -0.808543 -0.553077 -0.509562 -0.65913 -0.553077 -0.509562 -0.65913 -0.553077 -0.509562 -0.65913 -0.553077 -0.509562 -0.65913 -0.553077 -0.509562 -0.65913 -0.553077 -0.509562 -0.65913 -0.745158 -0.509562 -0.430217 -0.745158 -0.509562 -0.430217 -0.745158 -0.509562 -0.430217 -0.745157 -0.509562 -0.430218 -0.745157 -0.509562 -0.430218 -0.745157 -0.509562 -0.430218 -0.847362 -0.509562 -0.149413 -0.847362 -0.509562 -0.149413 -0.847362 -0.509562 -0.149413 -0.847362 -0.509562 -0.149412 -0.847362 -0.509562 -0.149412 -0.847362 -0.509562 -0.149412 -0.07669 0.996963 0.013522 -0.07669 0.996963 0.013522 -0.07669 0.996963 0.013522 -0.076691 0.996963 0.013522 -0.076691 0.996963 0.013522 -0.076691 0.996963 0.013522 -0.06744 0.996963 0.038936 -0.06744 0.996963 0.038936 -0.06744 0.996963 0.038936 -0.06744 0.996963 0.038936 -0.06744 0.996963 0.038936 -0.06744 0.996963 0.038936 -0.050055 0.996963 0.059653 -0.050055 0.996963 0.059653 -0.050055 0.996963 0.059653 -0.050055 0.996963 0.059654 -0.050055 0.996963 0.059654 -0.050055 0.996963 0.059654 -0.026634 0.996963 0.073176 -0.026634 0.996963 0.073176 -0.026634 0.996963 0.073176 -0.026633 0.996963 0.073176 -0.026633 0.996963 0.073176 -0.026633 0.996963 0.073176 0 0.996963 0.077875 0 0.996963 0.077875 0 0.996963 0.077875 0 0.996963 0.077873 0 0.996963 0.077873 0 0.996963 0.077873 0.026634 0.996963 0.073176 0.026634 0.996963 0.073176 0.026634 0.996963 0.073176 0.026635 0.996963 0.073179 0.026635 0.996963 0.073179 0.026635 0.996963 0.073179 0.050057 0.996963 0.059655 0.050057 0.996963 0.059655 0.050057 0.996963 0.059655 0.050055 0.996963 0.059653 0.050055 0.996963 0.059653 0.050055 0.996963 0.059653 0.067441 0.996963 0.038937 0.067441 0.996963 0.038937 0.067441 0.996963 0.038937 0.067441 0.996963 0.038937 0.067441 0.996963 0.038937 0.067441 0.996963 0.038937 0.076691 0.996963 0.013522 0.076691 0.996963 0.013522 0.076691 0.996963 0.013522 0.076691 0.996963 0.013522 0.076691 0.996963 0.013522 0.076691 0.996963 0.013522 0.07669 0.996963 -0.013522 0.07669 0.996963 -0.013522 0.07669 0.996963 -0.013522 0.076691 0.996963 -0.013522 0.076691 0.996963 -0.013522 0.076691 0.996963 -0.013522 0.067441 0.996963 -0.038937 0.067441 0.996963 -0.038937 0.067441 0.996963 -0.038937 0.06744 0.996963 -0.038936 0.06744 0.996963 -0.038936 0.06744 0.996963 -0.038936 0.050055 0.996963 -0.059653 0.050055 0.996963 -0.059653 0.050055 0.996963 -0.059653 0.050057 0.996963 -0.059655 0.050057 0.996963 -0.059655 0.050057 0.996963 -0.059655 0.026634 0.996963 -0.073176 0.026634 0.996963 -0.073176 0.026634 0.996963 -0.073176 0.026633 0.996963 -0.073176 0.026633 0.996963 -0.073176 0.026633 0.996963 -0.073176 0 0.996963 -0.077875 0 0.996963 -0.077875 0 0.996963 -0.077875 0 0.996963 -0.077873 0 0.996963 -0.077873 0 0.996963 -0.077873 -0.026634 0.996963 -0.073177 -0.026634 0.996963 -0.073177 -0.026634 0.996963 -0.073177 -0.026635 0.996963 -0.073179 -0.026635 0.996963 -0.073179 -0.026635 0.996963 -0.073179 -0.050056 0.996963 -0.059654 -0.050056 0.996963 -0.059654 -0.050056 0.996963 -0.059654 -0.050056 0.996963 -0.059655 -0.050056 0.996963 -0.059655 -0.050056 0.996963 -0.059655 -0.06744 0.996963 -0.038936 -0.06744 0.996963 -0.038936 -0.06744 0.996963 -0.038936 -0.06744 0.996963 -0.038936 -0.06744 0.996963 -0.038936 -0.06744 0.996963 -0.038936 -0.076691 0.996963 -0.013522 -0.076691 0.996963 -0.013522 -0.076691 0.996963 -0.013522 -0.07669 0.996963 -0.013522 -0.07669 0.996963 -0.013522 -0.07669 0.996963 -0.013522 -0.974894 0.14153 0.171901 -0.974895 0.14153 0.171901 -0.974894 0.14153 0.171901 -0.974895 0.141525 0.171901 -0.974895 0.141525 0.171901 -0.974895 0.141525 0.171901 -0.85731 0.14152 0.494967 -0.85731 0.14152 0.494967 -0.85731 0.14152 0.494967 -0.857308 0.14153 0.494967 -0.857308 0.14153 0.494967 -0.857308 0.14153 0.494967 -0.636318 0.141518 0.758335 -0.636318 0.141518 0.758335 -0.636318 0.141518 0.758335 -0.636318 0.141517 0.758335 -0.636319 0.141517 0.758335 -0.636319 0.141517 0.758335 -0.338578 0.141513 0.930236 -0.338578 0.141513 0.930236 -0.338578 0.141513 0.930236 -0.338578 0.141516 0.930236 -0.338578 0.141516 0.930235 -0.338578 0.141516 0.930236 0.000001 0.141529 0.989934 0.000001 0.141529 0.989934 0.000001 0.141529 0.989934 0 0.141515 0.989936 0 0.141515 0.989936 0 0.141515 0.989936 0.338577 0.141516 0.930236 0.338577 0.141516 0.930236 0.338577 0.141516 0.930236 0.338578 0.141531 0.930233 0.338578 0.141531 0.930233 0.338578 0.141531 0.930233 0.636318 0.141527 0.758333 0.636318 0.141527 0.758333 0.636318 0.141527 0.758333 0.636319 0.141518 0.758335 0.636319 0.141518 0.758335 0.636319 0.141518 0.758335 0.857309 0.141519 0.494968 0.857309 0.141519 0.494968 0.857309 0.141519 0.494968 0.857309 0.141525 0.494967 0.857309 0.141525 0.494967 0.857309 0.141525 0.494967 0.974895 0.141525 0.1719 0.974895 0.141525 0.1719 0.974895 0.141525 0.1719 0.974896 0.141518 0.171901 0.974896 0.141518 0.171901 0.974896 0.141518 0.171901 0.974894 0.14153 -0.171901 0.974895 0.14153 -0.171901 0.974894 0.14153 -0.171901 0.974895 0.141525 -0.171901 0.974895 0.141525 -0.171901 0.974895 0.141525 -0.171901 0.857308 0.141527 -0.494967 0.857308 0.141527 -0.494967 0.857308 0.141527 -0.494968 0.857308 0.14153 -0.494967 0.857308 0.14153 -0.494968 0.857308 0.14153 -0.494967 0.636319 0.141518 -0.758334 0.636319 0.141518 -0.758334 0.636319 0.141518 -0.758334 0.636317 0.141528 -0.758334 0.636317 0.141528 -0.758334 0.636317 0.141528 -0.758334 0.338578 0.141513 -0.930236 0.338578 0.141513 -0.930236 0.338578 0.141513 -0.930236 0.338578 0.141516 -0.930236 0.338578 0.141516 -0.930235 0.338578 0.141516 -0.930236 -0.000001 0.141529 -0.989934 -0.000001 0.141529 -0.989934 -0.000001 0.141529 -0.989934 0 0.141515 -0.989936 0 0.141515 -0.989936 0 0.141515 -0.989936 -0.338578 0.141528 -0.930234 -0.338578 0.141528 -0.930234 -0.338578 0.141528 -0.930234 -0.338578 0.141527 -0.930234 -0.338577 0.141526 -0.930234 -0.338577 0.141527 -0.930234 -0.636318 0.141528 -0.758333 -0.636318 0.141528 -0.758333 -0.636318 0.141528 -0.758333 -0.636318 0.141527 -0.758333 -0.636318 0.141527 -0.758333 -0.636318 0.141527 -0.758333 -0.857309 0.141518 -0.494968 -0.857309 0.141518 -0.494968 -0.857309 0.141518 -0.494968 -0.857309 0.141527 -0.494967 -0.857309 0.141527 -0.494967 -0.857309 0.141527 -0.494967 -0.974895 0.141525 -0.1719 -0.974895 0.141525 -0.1719 -0.974895 0.141525 -0.1719 -0.974896 0.141516 -0.171901 -0.974896 0.141516 -0.171901 -0.974896 0.141516 -0.171901 0.132127 0.990959 -0.023296 0.132127 0.990959 -0.023296 0.132127 0.990959 -0.023296 0.132127 0.990959 -0.023297 0.132127 0.990959 -0.023297 0.132127 0.990959 -0.023297 0.116191 0.990959 -0.067082 0.116191 0.990959 -0.067082 0.116191 0.990959 -0.067082 0.11619 0.990959 -0.067082 0.11619 0.990959 -0.067082 0.11619 0.990959 -0.067082 0.086239 0.990959 -0.102776 0.086239 0.990959 -0.102776 0.086239 0.990959 -0.102776 0.086239 0.990959 -0.102776 0.086239 0.990959 -0.102776 0.086239 0.990959 -0.102776 0.045886 0.990959 -0.126074 0.045886 0.990959 -0.126074 0.045886 0.990959 -0.126074 0.045887 0.990959 -0.126074 0.045887 0.990959 -0.126074 0.045887 0.990959 -0.126074 0 0.990959 -0.134165 0 0.990959 -0.134165 0 0.990959 -0.134165 0 0.990959 -0.134165 0 0.990959 -0.134165 0 0.990959 -0.134165 -0.045886 0.990959 -0.126074 -0.045886 0.990959 -0.126074 -0.045886 0.990959 -0.126074 -0.045887 0.990959 -0.126074 -0.045887 0.990959 -0.126074 -0.045887 0.990959 -0.126074 -0.086239 0.990959 -0.102776 -0.086239 0.990959 -0.102776 -0.086239 0.990959 -0.102776 -0.086239 0.990959 -0.102776 -0.086239 0.990959 -0.102776 -0.086239 0.990959 -0.102776 -0.116191 0.990959 -0.067082 -0.116191 0.990959 -0.067082 -0.116191 0.990959 -0.067082 -0.116191 0.990959 -0.067082 -0.116191 0.990959 -0.067082 -0.116191 0.990959 -0.067082 -0.132127 0.990959 -0.023296 -0.132127 0.990959 -0.023296 -0.132127 0.990959 -0.023296 -0.132127 0.990959 -0.023297 -0.132127 0.990959 -0.023297 -0.132127 0.990959 -0.023297 -0.132127 0.990959 0.023296 -0.132127 0.990959 0.023296 -0.132127 0.990959 0.023296 -0.132127 0.990959 0.023297 -0.132127 0.990959 0.023297 -0.132127 0.990959 0.023297 -0.11619 0.990959 0.067082 -0.11619 0.990959 0.067082 -0.11619 0.990959 0.067082 -0.116191 0.990959 0.067082 -0.116191 0.990959 0.067082 -0.116191 0.990959 0.067082 -0.086239 0.990959 0.102776 -0.086239 0.990959 0.102776 -0.086239 0.990959 0.102776 -0.086239 0.990959 0.102776 -0.086239 0.990959 0.102776 -0.086239 0.990959 0.102776 -0.045886 0.990959 0.126074 -0.045886 0.990959 0.126074 -0.045886 0.990959 0.126074 -0.045887 0.990959 0.126074 -0.045887 0.990959 0.126074 -0.045887 0.990959 0.126074 0 0.990959 0.134165 0 0.990959 0.134165 0 0.990959 0.134165 0 0.990959 0.134165 0 0.990959 0.134165 0 0.990959 0.134165 0.045886 0.990959 0.126074 0.045886 0.990959 0.126074 0.045886 0.990959 0.126074 0.045887 0.990959 0.126074 0.045887 0.990959 0.126074 0.045887 0.990959 0.126074 0.086239 0.990959 0.102776 0.086239 0.990959 0.102776 0.086239 0.990959 0.102776 0.086239 0.990959 0.102776 0.086239 0.990959 0.102776 0.086239 0.990959 0.102776 0.116191 0.990959 0.067082 0.116191 0.990959 0.067082 0.116191 0.990959 0.067082 0.116191 0.990959 0.067082 0.116191 0.990959 0.067082 0.116191 0.990959 0.067082 0.132127 0.990959 0.023296 0.132127 0.990959 0.023296 0.132127 0.990959 0.023296 0.132127 0.990959 0.023297 0.132127 0.990959 0.023297 0.132127 0.990959 0.023297 0.207033 0.977653 -0.036505 0.207033 0.977653 -0.036505 0.207033 0.977653 -0.036505 0.207033 0.977653 -0.036506 0.207033 0.977653 -0.036506 0.207033 0.977653 -0.036506 0.182062 0.977653 -0.105113 0.182062 0.977653 -0.105113 0.182062 0.977653 -0.105113 0.182062 0.977653 -0.105113 0.182062 0.977653 -0.105113 0.182062 0.977653 -0.105113 0.135131 0.977653 -0.161043 0.135131 0.977653 -0.161043 0.135131 0.977653 -0.161043 0.135131 0.977653 -0.161043 0.135131 0.977653 -0.161043 0.135131 0.977653 -0.161043 0.071901 0.977653 -0.197548 0.071901 0.977653 -0.197548 0.071901 0.977653 -0.197548 0.071902 0.977653 -0.197549 0.071902 0.977653 -0.197549 0.071902 0.977653 -0.197549 0 0.977652 -0.210227 0 0.977653 -0.210227 0 0.977653 -0.210227 -0.000000 0.977653 -0.210226 -0.000000 0.977653 -0.210226 -0.000000 0.977653 -0.210227 -0.071901 0.977653 -0.197549 -0.071901 0.977653 -0.197549 -0.071901 0.977653 -0.197549 -0.071901 0.977653 -0.197549 -0.071901 0.977653 -0.197549 -0.071901 0.977653 -0.197549 -0.135131 0.977653 -0.161043 -0.135131 0.977653 -0.161043 -0.135131 0.977653 -0.161043 -0.135131 0.977653 -0.161043 -0.135131 0.977653 -0.161043 -0.135131 0.977653 -0.161043 -0.182061 0.977653 -0.105113 -0.182061 0.977653 -0.105113 -0.182061 0.977653 -0.105113 -0.182061 0.977653 -0.105113 -0.182061 0.977653 -0.105113 -0.182061 0.977653 -0.105113 -0.207033 0.977653 -0.036505 -0.207033 0.977653 -0.036505 -0.207033 0.977653 -0.036505 -0.207032 0.977653 -0.036505 -0.207032 0.977653 -0.036505 -0.207032 0.977653 -0.036505 -0.207033 0.977653 0.036505 -0.207033 0.977653 0.036505 -0.207033 0.977653 0.036505 -0.207033 0.977653 0.036506 -0.207033 0.977653 0.036506 -0.207033 0.977653 0.036506 -0.182062 0.977653 0.105113 -0.182062 0.977653 0.105113 -0.182062 0.977653 0.105113 -0.182062 0.977653 0.105113 -0.182062 0.977653 0.105113 -0.182062 0.977653 0.105113 -0.135131 0.977653 0.161043 -0.135131 0.977653 0.161043 -0.135131 0.977653 0.161043 -0.135131 0.977653 0.161043 -0.135131 0.977653 0.161043 -0.135131 0.977653 0.161043 -0.071901 0.977653 0.197548 -0.071901 0.977653 0.197548 -0.071901 0.977653 0.197548 -0.071902 0.977653 0.197549 -0.071902 0.977653 0.197549 -0.071902 0.977653 0.197549 0 0.977652 0.210227 0 0.977653 0.210227 0 0.977653 0.210227 0.000000 0.977653 0.210226 0.000000 0.977653 0.210226 0.000000 0.977653 0.210227 0.071901 0.977653 0.197549 0.071901 0.977653 0.197549 0.071901 0.977653 0.197549 0.071901 0.977653 0.197549 0.071901 0.977653 0.197549 0.071901 0.977653 0.197549 0.135131 0.977653 0.161043 0.135131 0.977653 0.161043 0.135131 0.977653 0.161043 0.135131 0.977653 0.161043 0.135131 0.977653 0.161043 0.135131 0.977653 0.161043 0.182061 0.977653 0.105113 0.182061 0.977653 0.105113 0.182061 0.977653 0.105113 0.182061 0.977653 0.105113 0.182061 0.977653 0.105113 0.182061 0.977653 0.105113 0.207033 0.977653 0.036505 0.207033 0.977653 0.036505 0.207033 0.977653 0.036505 0.207032 0.977653 0.036505 0.207032 0.977653 0.036505 0.207032 0.977653 0.036505 0.445829 0.89166 -0.078612 0.445829 0.89166 -0.078612 0.445829 0.89166 -0.078612 0.445831 0.891659 -0.078611 0.445831 0.891659 -0.078611 0.445831 0.891659 -0.078611 0.392056 0.891659 -0.226353 0.392056 0.891659 -0.226353 0.392056 0.891659 -0.226353 0.392056 0.891659 -0.226353 0.392056 0.891659 -0.226353 0.392056 0.891659 -0.226353 0.290994 0.891659 -0.346794 0.290994 0.891659 -0.346794 0.290994 0.891659 -0.346794 0.290995 0.891659 -0.346794 0.290995 0.891659 -0.346794 0.290995 0.891659 -0.346794 0.154836 0.891659 -0.425406 0.154836 0.891659 -0.425406 0.154836 0.891659 -0.425406 0.154835 0.891659 -0.425405 0.154835 0.891659 -0.425405 0.154835 0.891659 -0.425405 -0.000001 0.891659 -0.452707 -0.000001 0.891659 -0.452707 -0.000001 0.891659 -0.452707 -0.000001 0.891659 -0.452708 -0.000001 0.891659 -0.452708 -0.000001 0.891659 -0.452708 -0.154835 0.891659 -0.425405 -0.154835 0.891659 -0.425405 -0.154835 0.891659 -0.425405 -0.154834 0.891659 -0.425406 -0.154834 0.891659 -0.425406 -0.154834 0.891659 -0.425406 -0.290995 0.891659 -0.346794 -0.290995 0.891659 -0.346794 -0.290995 0.891659 -0.346794 -0.290995 0.891659 -0.346793 -0.290995 0.891659 -0.346793 -0.290995 0.891659 -0.346793 -0.392056 0.891659 -0.226354 -0.392056 0.891659 -0.226354 -0.392056 0.891659 -0.226354 -0.392056 0.891659 -0.226354 -0.392056 0.891659 -0.226354 -0.392056 0.891659 -0.226354 -0.445831 0.891659 -0.078611 -0.445831 0.891659 -0.078611 -0.445831 0.891659 -0.078611 -0.44583 0.891659 -0.078611 -0.44583 0.891659 -0.078611 -0.44583 0.891659 -0.078611 -0.44583 0.891659 0.078613 -0.44583 0.891659 0.078613 -0.44583 0.891659 0.078613 -0.445831 0.891659 0.078612 -0.445831 0.891659 0.078612 -0.445831 0.891659 0.078612 -0.392056 0.891659 0.226353 -0.392056 0.891659 0.226353 -0.392056 0.891659 0.226353 -0.392056 0.891659 0.226353 -0.392056 0.891659 0.226353 -0.392056 0.891659 0.226353 -0.290994 0.891659 0.346794 -0.290994 0.891659 0.346794 -0.290994 0.891659 0.346794 -0.290995 0.891659 0.346794 -0.290995 0.891659 0.346794 -0.290995 0.891659 0.346794 -0.154836 0.891659 0.425406 -0.154836 0.891659 0.425406 -0.154836 0.891659 0.425406 -0.154835 0.891659 0.425405 -0.154835 0.891659 0.425405 -0.154835 0.891659 0.425405 0.000001 0.891659 0.452707 0.000001 0.891659 0.452707 0.000001 0.891659 0.452707 0.000001 0.891659 0.452708 0.000001 0.891659 0.452708 0.000001 0.891659 0.452708 0.154835 0.891659 0.425406 0.154835 0.891659 0.425406 0.154835 0.891659 0.425406 0.154835 0.891659 0.425406 0.154835 0.891659 0.425406 0.154835 0.891659 0.425406 0.290995 0.891659 0.346794 0.290995 0.891659 0.346794 0.290995 0.891659 0.346794 0.290995 0.891659 0.346795 0.290995 0.891659 0.346795 0.290995 0.891659 0.346795 0.392056 0.891659 0.226354 0.392056 0.891659 0.226354 0.392056 0.891659 0.226354 0.392056 0.891659 0.226354 0.392056 0.891659 0.226354 0.392056 0.891659 0.226354 0.445831 0.891659 0.078611 0.445831 0.891659 0.078611 0.445831 0.891659 0.078611 0.44583 0.891659 0.078611 0.44583 0.891659 0.078611 0.44583 0.891659 0.078611 0.556773 0.824843 -0.098173 0.556773 0.824843 -0.098173 0.556773 0.824843 -0.098173 0.556771 0.824844 -0.098174 0.556771 0.824844 -0.098174 0.556771 0.824844 -0.098174 0.489617 0.824844 -0.28268 0.489617 0.824844 -0.28268 0.489617 0.824844 -0.28268 0.489618 0.824843 -0.28268 0.489618 0.824843 -0.28268 0.489618 0.824843 -0.28268 0.363408 0.824843 -0.433092 0.363408 0.824843 -0.433092 0.363408 0.824843 -0.433092 0.363406 0.824844 -0.433092 0.363406 0.824844 -0.433092 0.363406 0.824844 -0.433092 0.193365 0.824843 -0.531266 0.193365 0.824843 -0.531266 0.193365 0.824843 -0.531266 0.193366 0.824843 -0.531267 0.193366 0.824843 -0.531267 0.193366 0.824843 -0.531267 -0.000001 0.824844 -0.56536 -0.000001 0.824844 -0.56536 -0.000001 0.824844 -0.56536 0 0.824843 -0.565362 0 0.824843 -0.565362 0 0.824843 -0.565362 -0.193364 0.824843 -0.531267 -0.193364 0.824843 -0.531267 -0.193364 0.824843 -0.531267 -0.193365 0.824844 -0.531265 -0.193365 0.824844 -0.531265 -0.193365 0.824844 -0.531265 -0.363408 0.824843 -0.433092 -0.363408 0.824843 -0.433092 -0.363408 0.824843 -0.433092 -0.363408 0.824843 -0.433093 -0.363408 0.824843 -0.433093 -0.363408 0.824843 -0.433093 -0.489618 0.824843 -0.282681 -0.489618 0.824843 -0.282681 -0.489618 0.824843 -0.282681 -0.489618 0.824843 -0.282681 -0.489618 0.824843 -0.282681 -0.489618 0.824843 -0.282681 -0.556771 0.824844 -0.098172 -0.556771 0.824844 -0.098172 -0.556771 0.824844 -0.098172 -0.556773 0.824843 -0.098174 -0.556773 0.824843 -0.098174 -0.556773 0.824843 -0.098174 -0.556771 0.824844 0.098174 -0.556771 0.824844 0.098174 -0.556771 0.824844 0.098174 -0.556771 0.824844 0.098173 -0.556771 0.824844 0.098173 -0.556771 0.824844 0.098173 -0.489617 0.824844 0.28268 -0.489617 0.824844 0.28268 -0.489617 0.824844 0.28268 -0.489616 0.824844 0.28268 -0.489616 0.824844 0.28268 -0.489616 0.824844 0.28268 -0.363408 0.824843 0.433092 -0.363408 0.824843 0.433092 -0.363408 0.824843 0.433092 -0.363406 0.824844 0.433092 -0.363406 0.824844 0.433092 -0.363406 0.824844 0.433092 -0.193365 0.824843 0.531266 -0.193365 0.824843 0.531266 -0.193365 0.824843 0.531266 -0.193366 0.824843 0.531267 -0.193366 0.824843 0.531267 -0.193366 0.824843 0.531267 0.000001 0.824844 0.56536 0.000001 0.824844 0.56536 0.000001 0.824844 0.56536 0 0.824843 0.565362 0 0.824843 0.565362 0 0.824843 0.565362 0.193365 0.824844 0.531265 0.193365 0.824844 0.531265 0.193365 0.824844 0.531265 0.193365 0.824844 0.531264 0.193365 0.824844 0.531264 0.193365 0.824845 0.531264 0.363407 0.824843 0.433093 0.363407 0.824843 0.433093 0.363407 0.824843 0.433093 0.363407 0.824844 0.433091 0.363407 0.824844 0.433092 0.363407 0.824844 0.433091 0.489618 0.824843 0.282681 0.489618 0.824843 0.282681 0.489618 0.824843 0.282681 0.489618 0.824843 0.282681 0.489618 0.824843 0.282681 0.489618 0.824843 0.282681 0.556771 0.824844 0.098172 0.556771 0.824844 0.098172 0.556771 0.824844 0.098172 0.556773 0.824843 0.098174 0.556773 0.824843 0.098174 0.556773 0.824843 0.098174 0.701675 0.701673 -0.123724 0.701675 0.701673 -0.123724 0.701675 0.701673 -0.123724 0.701674 0.701674 -0.123725 0.701674 0.701674 -0.123725 0.701674 0.701674 -0.123725 0.617043 0.701673 -0.356249 0.617043 0.701673 -0.356249 0.617043 0.701673 -0.356249 0.617043 0.701673 -0.356249 0.617043 0.701673 -0.356249 0.617043 0.701673 -0.356249 0.457984 0.701675 -0.545805 0.457984 0.701675 -0.545805 0.457984 0.701675 -0.545805 0.457986 0.701673 -0.545806 0.457986 0.701673 -0.545806 0.457986 0.701673 -0.545806 0.24369 0.701672 -0.66953 0.24369 0.701672 -0.66953 0.24369 0.701672 -0.66953 0.243687 0.701675 -0.669529 0.243687 0.701675 -0.669529 0.243687 0.701675 -0.669529 0 0.701673 -0.712499 0 0.701673 -0.712499 0 0.701673 -0.712499 0 0.701673 -0.712499 0 0.701673 -0.712499 0 0.701673 -0.712499 -0.243689 0.701675 -0.669528 -0.243689 0.701675 -0.669528 -0.243689 0.701675 -0.669528 -0.243688 0.701673 -0.66953 -0.243688 0.701673 -0.66953 -0.243688 0.701673 -0.66953 -0.457985 0.701674 -0.545805 -0.457985 0.701674 -0.545805 -0.457985 0.701674 -0.545805 -0.457985 0.701675 -0.545804 -0.457985 0.701675 -0.545804 -0.457985 0.701675 -0.545804 -0.617041 0.701674 -0.356249 -0.617041 0.701674 -0.356249 -0.617041 0.701674 -0.356249 -0.617041 0.701674 -0.356249 -0.617041 0.701674 -0.356249 -0.617041 0.701674 -0.356249 -0.701674 0.701674 -0.123724 -0.701674 0.701674 -0.123724 -0.701674 0.701674 -0.123724 -0.701673 0.701675 -0.123724 -0.701673 0.701675 -0.123724 -0.701673 0.701675 -0.123724 -0.701675 0.701673 0.123724 -0.701675 0.701673 0.123724 -0.701675 0.701673 0.123724 -0.701674 0.701674 0.123725 -0.701674 0.701674 0.123725 -0.701674 0.701674 0.123725 -0.617042 0.701673 0.35625 -0.617042 0.701673 0.35625 -0.617042 0.701673 0.35625 -0.617043 0.701673 0.35625 -0.617043 0.701673 0.35625 -0.617043 0.701673 0.35625 -0.457984 0.701675 0.545805 -0.457984 0.701675 0.545805 -0.457984 0.701675 0.545805 -0.457986 0.701673 0.545806 -0.457986 0.701673 0.545806 -0.457986 0.701673 0.545806 -0.24369 0.701672 0.66953 -0.24369 0.701672 0.66953 -0.24369 0.701672 0.66953 -0.243687 0.701675 0.669529 -0.243687 0.701675 0.669529 -0.243687 0.701675 0.669529 0 0.701673 0.712499 0 0.701673 0.712499 0 0.701673 0.712499 0 0.701673 0.712499 0 0.701673 0.712499 0 0.701673 0.712499 0.24369 0.701673 0.669529 0.24369 0.701673 0.669529 0.24369 0.701673 0.669529 0.24369 0.701672 0.66953 0.24369 0.701673 0.66953 0.24369 0.701673 0.66953 0.457985 0.701674 0.545805 0.457985 0.701674 0.545805 0.457985 0.701674 0.545805 0.457985 0.701673 0.545806 0.457985 0.701673 0.545806 0.457985 0.701673 0.545806 0.617041 0.701674 0.356249 0.617041 0.701674 0.356249 0.617041 0.701674 0.356249 0.617041 0.701674 0.356249 0.617041 0.701674 0.356249 0.617041 0.701674 0.356249 0.701674 0.701674 0.123724 0.701674 0.701674 0.123724 0.701674 0.701674 0.123724 0.701673 0.701675 0.123724 0.701673 0.701675 0.123724 0.701673 0.701675 0.123724 0.768091 0.625854 -0.135437 0.768091 0.625854 -0.135437 0.768091 0.625854 -0.135437 0.768092 0.625853 -0.135436 0.768092 0.625853 -0.135436 0.768092 0.625853 -0.135436 0.675449 0.625853 -0.38997 0.675449 0.625853 -0.38997 0.675449 0.625853 -0.38997 0.675449 0.625853 -0.38997 0.675449 0.625853 -0.38997 0.675449 0.625853 -0.38997 0.501337 0.625852 -0.59747 0.501337 0.625852 -0.59747 0.501337 0.625852 -0.59747 0.501336 0.625853 -0.59747 0.501336 0.625853 -0.59747 0.501336 0.625853 -0.59747 0.266754 0.625853 -0.732905 0.266754 0.625853 -0.732905 0.266754 0.625853 -0.732905 0.266756 0.625852 -0.732906 0.266756 0.625852 -0.732906 0.266756 0.625852 -0.732906 0 0.625853 -0.779941 0 0.625853 -0.779941 0 0.625853 -0.779941 0 0.625853 -0.779941 0 0.625853 -0.779941 0 0.625853 -0.779941 -0.266755 0.625852 -0.732906 -0.266755 0.625852 -0.732906 -0.266755 0.625852 -0.732906 -0.266756 0.625853 -0.732905 -0.266756 0.625853 -0.732905 -0.266756 0.625853 -0.732905 -0.501337 0.625853 -0.597469 -0.501337 0.625853 -0.597469 -0.501337 0.625853 -0.597469 -0.501337 0.625852 -0.59747 -0.501337 0.625852 -0.597471 -0.501337 0.625852 -0.59747 -0.67545 0.625851 -0.389972 -0.67545 0.625851 -0.389972 -0.67545 0.625851 -0.389972 -0.675449 0.625853 -0.38997 -0.675449 0.625853 -0.38997 -0.675449 0.625853 -0.38997 -0.768092 0.625853 -0.135435 -0.768092 0.625853 -0.135435 -0.768092 0.625853 -0.135435 -0.768093 0.625851 -0.135436 -0.768093 0.625851 -0.135436 -0.768093 0.625851 -0.135436 -0.768091 0.625853 0.135436 -0.768091 0.625854 0.135436 -0.768091 0.625854 0.135436 -0.768092 0.625853 0.135436 -0.768092 0.625853 0.135436 -0.768092 0.625853 0.135436 -0.675449 0.625853 0.38997 -0.675449 0.625853 0.38997 -0.675449 0.625853 0.38997 -0.675449 0.625853 0.38997 -0.675449 0.625853 0.38997 -0.675449 0.625853 0.38997 -0.501338 0.625852 0.59747 -0.501338 0.625852 0.59747 -0.501338 0.625852 0.59747 -0.501336 0.625853 0.59747 -0.501336 0.625853 0.59747 -0.501336 0.625853 0.59747 -0.266754 0.625853 0.732905 -0.266754 0.625853 0.732905 -0.266754 0.625853 0.732905 -0.266756 0.625852 0.732906 -0.266756 0.625852 0.732906 -0.266756 0.625852 0.732906 0 0.625853 0.779941 0 0.625853 0.779941 0 0.625853 0.779941 0 0.625853 0.779941 0 0.625853 0.779941 0 0.625853 0.779941 0.266756 0.625854 0.732904 0.266756 0.625854 0.732904 0.266756 0.625854 0.732904 0.266756 0.625853 0.732905 0.266756 0.625853 0.732905 0.266756 0.625853 0.732905 0.501337 0.625852 0.597471 0.501337 0.625852 0.597471 0.501337 0.625852 0.597471 0.501337 0.625853 0.597469 0.501337 0.625853 0.597469 0.501337 0.625853 0.597469 0.67545 0.625851 0.389972 0.67545 0.625851 0.389972 0.67545 0.625851 0.389972 0.675449 0.625852 0.389971 0.675449 0.625852 0.389971 0.675449 0.625852 0.389971 0.768092 0.625853 0.135435 0.768092 0.625853 0.135435 0.768092 0.625853 0.135435 0.768093 0.625851 0.135437 0.768093 0.625851 0.135437 0.768093 0.625851 0.135437 0.791816 0.594587 -0.13962 0.791816 0.594587 -0.13962 0.791816 0.594587 -0.13962 0.791817 0.594586 -0.139618 0.791817 0.594586 -0.139618 0.791817 0.594586 -0.139618 0.696312 0.594587 -0.402015 0.696312 0.594587 -0.402015 0.696312 0.594587 -0.402015 0.696312 0.594587 -0.402015 0.696312 0.594587 -0.402015 0.696312 0.594587 -0.402015 0.516821 0.594587 -0.615924 0.516821 0.594587 -0.615924 0.516821 0.594587 -0.615924 0.516821 0.594587 -0.615924 0.516821 0.594587 -0.615924 0.516821 0.594587 -0.615924 0.274994 0.594588 -0.755542 0.274994 0.594588 -0.755542 0.274994 0.594588 -0.755542 0.274995 0.594587 -0.755542 0.274995 0.594587 -0.755542 0.274995 0.594587 -0.755542 0 0.594587 -0.804031 0 0.594587 -0.804031 0 0.594588 -0.804031 0 0.594588 -0.804031 0 0.594587 -0.804031 0 0.594588 -0.804031 -0.274995 0.594587 -0.755542 -0.274995 0.594587 -0.755542 -0.274995 0.594587 -0.755542 -0.274996 0.594587 -0.755542 -0.274996 0.594587 -0.755542 -0.274996 0.594587 -0.755542 -0.516821 0.594587 -0.615924 -0.516821 0.594587 -0.615924 -0.516821 0.594587 -0.615924 -0.516821 0.594587 -0.615924 -0.516821 0.594587 -0.615924 -0.516821 0.594587 -0.615924 -0.696312 0.594587 -0.402015 -0.696312 0.594587 -0.402015 -0.696312 0.594587 -0.402015 -0.696312 0.594587 -0.402016 -0.696312 0.594587 -0.402016 -0.696312 0.594587 -0.402016 -0.791816 0.594586 -0.139619 -0.791816 0.594587 -0.139619 -0.791816 0.594586 -0.139619 -0.791816 0.594587 -0.139618 -0.791816 0.594587 -0.139618 -0.791816 0.594587 -0.139618 -0.791816 0.594587 0.139619 -0.791816 0.594587 0.139619 -0.791816 0.594587 0.139619 -0.791817 0.594587 0.139618 -0.791817 0.594587 0.139618 -0.791817 0.594587 0.139618 -0.696312 0.594587 0.402015 -0.696312 0.594587 0.402015 -0.696312 0.594587 0.402015 -0.696311 0.594587 0.402016 -0.696311 0.594587 0.402016 -0.696311 0.594587 0.402016 -0.516821 0.594587 0.615924 -0.516821 0.594587 0.615924 -0.516821 0.594587 0.615924 -0.516821 0.594587 0.615924 -0.516821 0.594587 0.615924 -0.516821 0.594587 0.615924 -0.274994 0.594588 0.755542 -0.274994 0.594588 0.755542 -0.274994 0.594588 0.755542 -0.274995 0.594587 0.755542 -0.274995 0.594587 0.755542 -0.274995 0.594587 0.755542 0 0.594587 0.804031 0 0.594587 0.804031 0 0.594587 0.804031 0.000000 0.594587 0.804031 0.000000 0.594587 0.804031 0.000000 0.594587 0.804031 0.274995 0.594587 0.755542 0.274995 0.594587 0.755542 0.274995 0.594587 0.755542 0.274995 0.594587 0.755542 0.274995 0.594587 0.755542 0.274995 0.594587 0.755542 0.516822 0.594587 0.615923 0.516822 0.594587 0.615923 0.516822 0.594587 0.615923 0.516822 0.594587 0.615923 0.516822 0.594587 0.615923 0.516822 0.594587 0.615923 0.696311 0.594587 0.402015 0.696311 0.594587 0.402015 0.696311 0.594587 0.402015 0.696311 0.594587 0.402016 0.696311 0.594587 0.402016 0.696311 0.594587 0.402016 0.791816 0.594586 0.13962 0.791817 0.594586 0.13962 0.791817 0.594586 0.13962 0.791816 0.594587 0.139618 0.791816 0.594587 0.139618 0.791816 0.594587 0.139618 0.739567 0.66033 -0.130405 0.739567 0.66033 -0.130405 0.739567 0.66033 -0.130405 0.739564 0.660333 -0.130406 0.739564 0.660333 -0.130406 0.739564 0.660333 -0.130406 0.650364 0.66033 -0.375487 0.650364 0.66033 -0.375487 0.650364 0.66033 -0.375487 0.650364 0.66033 -0.375487 0.650364 0.66033 -0.375487 0.650364 0.66033 -0.375487 0.482717 0.660331 -0.57528 0.482717 0.660331 -0.57528 0.482717 0.660331 -0.57528 0.482718 0.660329 -0.575281 0.482718 0.660329 -0.575281 0.482718 0.660329 -0.575281 0.256849 0.66033 -0.705686 0.256849 0.66033 -0.705686 0.256849 0.66033 -0.705686 0.256849 0.66033 -0.705686 0.256849 0.66033 -0.705686 0.256849 0.66033 -0.705686 0 0.66033 -0.750976 0 0.66033 -0.750976 0 0.66033 -0.750976 0 0.66033 -0.750976 0 0.66033 -0.750976 0 0.66033 -0.750976 -0.256849 0.660331 -0.705685 -0.256849 0.660331 -0.705685 -0.256849 0.660331 -0.705685 -0.256849 0.66033 -0.705686 -0.256849 0.66033 -0.705686 -0.256849 0.66033 -0.705686 -0.482717 0.660332 -0.575279 -0.482717 0.660332 -0.575279 -0.482717 0.660332 -0.575279 -0.482717 0.660331 -0.57528 -0.482717 0.660331 -0.57528 -0.482717 0.660331 -0.57528 -0.650362 0.660333 -0.375487 -0.650362 0.660333 -0.375487 -0.650362 0.660333 -0.375487 -0.650363 0.660331 -0.375488 -0.650363 0.660331 -0.375488 -0.650363 0.660331 -0.375488 -0.739564 0.660333 -0.130405 -0.739564 0.660333 -0.130405 -0.739564 0.660333 -0.130405 -0.739564 0.660333 -0.130405 -0.739564 0.660333 -0.130405 -0.739564 0.660333 -0.130405 -0.739567 0.660329 0.130405 -0.739567 0.660329 0.130405 -0.739567 0.660329 0.130405 -0.739564 0.660333 0.130406 -0.739564 0.660333 0.130406 -0.739564 0.660333 0.130406 -0.650364 0.66033 0.375488 -0.650364 0.66033 0.375488 -0.650364 0.66033 0.375488 -0.650365 0.660329 0.375488 -0.650365 0.660329 0.375488 -0.650365 0.660329 0.375488 -0.482717 0.660331 0.57528 -0.482717 0.660331 0.57528 -0.482717 0.660331 0.57528 -0.482718 0.660329 0.575281 -0.482718 0.660329 0.575281 -0.482718 0.660329 0.575281 -0.256849 0.66033 0.705686 -0.256849 0.66033 0.705686 -0.256849 0.66033 0.705686 -0.256849 0.66033 0.705686 -0.256849 0.66033 0.705686 -0.256849 0.66033 0.705686 0.000000 0.660333 0.750973 0.000000 0.660333 0.750973 0.000000 0.660333 0.750973 0 0.66033 0.750976 0 0.66033 0.750976 0 0.66033 0.750976 0.256848 0.66033 0.705686 0.256848 0.66033 0.705686 0.256848 0.66033 0.705686 0.256848 0.660333 0.705683 0.256848 0.660333 0.705683 0.256848 0.660333 0.705683 0.482719 0.660329 0.575281 0.482719 0.660329 0.575281 0.482719 0.660329 0.575281 0.482718 0.660331 0.575279 0.482718 0.660331 0.575279 0.482718 0.660331 0.575279 0.650363 0.660331 0.375487 0.650363 0.660331 0.375487 0.650363 0.660331 0.375487 0.650364 0.66033 0.375488 0.650364 0.66033 0.375488 0.650364 0.66033 0.375488 0.739564 0.660333 0.130405 0.739564 0.660333 0.130405 0.739564 0.660333 0.130405 0.739565 0.660332 0.130405 0.739565 0.660332 0.130405 0.739565 0.660332 0.130405 -0.014282 -0.999895 0.002518 -0.014282 -0.999895 0.002518 -0.014282 -0.999895 0.002518 -0.014282 -0.999895 0.002518 -0.014282 -0.999895 0.002518 -0.014282 -0.999895 0.002518 -0.012559 -0.999895 0.007251 -0.012559 -0.999895 0.007251 -0.012559 -0.999895 0.007251 -0.012559 -0.999895 0.007251 -0.012559 -0.999895 0.007251 -0.012559 -0.999895 0.007251 -0.009322 -0.999895 0.011109 -0.009322 -0.999895 0.011109 -0.009322 -0.999895 0.011109 -0.009322 -0.999895 0.011109 -0.009322 -0.999895 0.011109 -0.009322 -0.999895 0.011109 -0.00496 -0.999895 0.013628 -0.00496 -0.999895 0.013628 -0.00496 -0.999895 0.013628 -0.00496 -0.999895 0.013627 -0.00496 -0.999895 0.013627 -0.00496 -0.999895 0.013627 0 -0.999895 0.014502 0 -0.999895 0.014502 0 -0.999895 0.014502 0 -0.999895 0.014502 0 -0.999895 0.014502 0 -0.999895 0.014502 0.00496 -0.999895 0.013627 0.00496 -0.999895 0.013627 0.00496 -0.999895 0.013627 0.00496 -0.999895 0.013628 0.00496 -0.999895 0.013628 0.00496 -0.999895 0.013628 0.009322 -0.999895 0.011109 0.009322 -0.999895 0.011109 0.009322 -0.999895 0.011109 0.009322 -0.999895 0.011109 0.009322 -0.999895 0.011109 0.009322 -0.999895 0.011109 0.012559 -0.999895 0.007251 0.012559 -0.999895 0.007251 0.012559 -0.999895 0.007251 0.012559 -0.999895 0.007251 0.012559 -0.999895 0.007251 0.012559 -0.999895 0.007251 0.014282 -0.999895 0.002518 0.014282 -0.999895 0.002518 0.014282 -0.999895 0.002518 0.014282 -0.999895 0.002518 0.014282 -0.999895 0.002518 0.014282 -0.999895 0.002518 0.014282 -0.999895 -0.002518 0.014282 -0.999895 -0.002518 0.014282 -0.999895 -0.002518 0.014282 -0.999895 -0.002518 0.014282 -0.999895 -0.002518 0.014282 -0.999895 -0.002518 0.012559 -0.999895 -0.007251 0.012559 -0.999895 -0.007251 0.012559 -0.999895 -0.007251 0.012559 -0.999895 -0.007251 0.012559 -0.999895 -0.007251 0.012559 -0.999895 -0.007251 0.009322 -0.999895 -0.011109 0.009322 -0.999895 -0.011109 0.009322 -0.999895 -0.011109 0.009322 -0.999895 -0.011109 0.009322 -0.999895 -0.011109 0.009322 -0.999895 -0.011109 0.00496 -0.999895 -0.013628 0.00496 -0.999895 -0.013628 0.00496 -0.999895 -0.013628 0.00496 -0.999895 -0.013627 0.00496 -0.999895 -0.013627 0.00496 -0.999895 -0.013627 0 -0.999895 -0.014502 0 -0.999895 -0.014502 0 -0.999895 -0.014502 0 -0.999895 -0.014502 0 -0.999895 -0.014502 0 -0.999895 -0.014502 -0.00496 -0.999895 -0.013628 -0.00496 -0.999895 -0.013628 -0.00496 -0.999895 -0.013628 -0.00496 -0.999895 -0.013628 -0.00496 -0.999895 -0.013628 -0.00496 -0.999895 -0.013628 -0.009322 -0.999895 -0.011109 -0.009322 -0.999895 -0.011109 -0.009322 -0.999895 -0.011109 -0.009322 -0.999895 -0.011109 -0.009322 -0.999895 -0.011109 -0.009322 -0.999895 -0.011109 -0.012559 -0.999895 -0.007251 -0.012559 -0.999895 -0.007251 -0.012559 -0.999895 -0.007251 -0.012559 -0.999895 -0.007251 -0.012559 -0.999895 -0.007251 -0.012559 -0.999895 -0.007251 -0.014282 -0.999895 -0.002518 -0.014282 -0.999895 -0.002518 -0.014282 -0.999895 -0.002518 -0.014282 -0.999895 -0.002518 -0.014282 -0.999895 -0.002518 -0.014282 -0.999895 -0.002518 -0.983522 0.051091 0.17342 -0.983522 0.051091 0.17342 -0.983522 0.051091 0.17342 -0.983521 0.051095 0.173423 -0.983521 0.051095 0.173423 -0.983521 0.051095 0.173423 -0.864895 0.05109 0.499347 -0.864895 0.05109 0.499347 -0.864895 0.05109 0.499347 -0.864893 0.051092 0.499349 -0.864893 0.051092 0.499349 -0.864893 0.051092 0.499349 -0.641947 0.051092 0.765045 -0.641947 0.051092 0.765045 -0.641947 0.051092 0.765045 -0.641948 0.05109 0.765044 -0.641948 0.05109 0.765044 -0.641948 0.05109 0.765044 -0.341574 0.051094 0.938465 -0.341574 0.051094 0.938465 -0.341574 0.051094 0.938465 -0.341576 0.051092 0.938464 -0.341576 0.051092 0.938464 -0.341576 0.051092 0.938464 0 0.051094 0.998694 0 0.051094 0.998694 0 0.051094 0.998694 0 0.051094 0.998694 0 0.051094 0.998694 0 0.051094 0.998694 0.341574 0.051092 0.938465 0.341574 0.051092 0.938465 0.341574 0.051092 0.938465 0.341576 0.051094 0.938464 0.341576 0.051094 0.938464 0.341576 0.051094 0.938464 0.641947 0.051092 0.765045 0.641947 0.051092 0.765045 0.641947 0.051092 0.765045 0.641947 0.051092 0.765045 0.641947 0.051092 0.765045 0.641947 0.051092 0.765045 0.864895 0.051091 0.499347 0.864894 0.051091 0.499347 0.864895 0.051091 0.499347 0.864895 0.051092 0.499345 0.864895 0.051092 0.499345 0.864895 0.051092 0.499345 0.983522 0.051095 0.17342 0.983522 0.051095 0.17342 0.983522 0.051095 0.17342 0.983521 0.051091 0.173423 0.983521 0.051091 0.173423 0.983521 0.051091 0.173423 0.983522 0.051091 -0.17342 0.983522 0.051091 -0.17342 0.983522 0.051091 -0.17342 0.983521 0.051095 -0.173423 0.983521 0.051095 -0.173423 0.983521 0.051095 -0.173423 0.864893 0.051092 -0.499349 0.864893 0.051092 -0.499349 0.864893 0.051092 -0.499349 0.864893 0.051092 -0.499349 0.864893 0.051092 -0.499349 0.864893 0.051092 -0.499349 0.641948 0.051092 -0.765044 0.641948 0.051092 -0.765044 0.641948 0.051092 -0.765044 0.641948 0.051092 -0.765044 0.641948 0.051092 -0.765044 0.641948 0.051092 -0.765044 0.341574 0.051094 -0.938465 0.341574 0.051094 -0.938465 0.341574 0.051094 -0.938465 0.341576 0.051092 -0.938464 0.341576 0.051092 -0.938464 0.341576 0.051092 -0.938464 0 0.051094 -0.998694 0 0.051094 -0.998694 0 0.051094 -0.998694 0 0.051094 -0.998694 0 0.051094 -0.998694 0 0.051094 -0.998694 -0.341574 0.051092 -0.938465 -0.341574 0.051092 -0.938465 -0.341574 0.051092 -0.938465 -0.341575 0.051093 -0.938465 -0.341575 0.051093 -0.938465 -0.341575 0.051093 -0.938465 -0.641948 0.051092 -0.765044 -0.641948 0.051092 -0.765044 -0.641948 0.051092 -0.765044 -0.641948 0.051092 -0.765044 -0.641948 0.051092 -0.765044 -0.641948 0.051092 -0.765044 -0.864895 0.051091 -0.499347 -0.864894 0.051091 -0.499347 -0.864895 0.051091 -0.499347 -0.864895 0.051092 -0.499345 -0.864895 0.051092 -0.499345 -0.864895 0.051092 -0.499345 -0.983522 0.051095 -0.17342 -0.983522 0.051095 -0.17342 -0.983522 0.051095 -0.17342 -0.983521 0.051091 -0.173423 -0.983521 0.051091 -0.173423 -0.983521 0.051091 -0.173423 -0.737642 -0.662545 0.130067 -0.737642 -0.662545 0.130067 -0.737642 -0.662545 0.130067 -0.737644 -0.662543 0.130068 -0.737644 -0.662543 0.130068 -0.737644 -0.662543 0.130068 -0.648676 -0.662539 0.374515 -0.648676 -0.662539 0.374515 -0.648676 -0.662539 0.374515 -0.648672 -0.662545 0.374511 -0.648672 -0.662545 0.374511 -0.648672 -0.662545 0.374511 -0.481465 -0.66254 0.573788 -0.481465 -0.66254 0.573788 -0.481465 -0.66254 0.573788 -0.481466 -0.662538 0.57379 -0.481466 -0.662538 0.57379 -0.481466 -0.662538 0.57379 -0.256181 -0.662551 0.703845 -0.256181 -0.662551 0.703845 -0.256181 -0.662551 0.703845 -0.256182 -0.662539 0.703855 -0.256182 -0.662539 0.703855 -0.256182 -0.662539 0.703855 0 -0.662551 0.749017 0 -0.662551 0.749017 0 -0.662551 0.749017 0 -0.662551 0.749017 0 -0.662551 0.749017 0 -0.662551 0.749017 0.256184 -0.662539 0.703855 0.256184 -0.662539 0.703855 0.256184 -0.662539 0.703855 0.256179 -0.662551 0.703846 0.256179 -0.662551 0.703845 0.256179 -0.662551 0.703845 0.48146 -0.662546 0.573784 0.48146 -0.662546 0.573784 0.48146 -0.662546 0.573784 0.481465 -0.66254 0.573788 0.481465 -0.66254 0.573788 0.481465 -0.66254 0.573788 0.648673 -0.662545 0.37451 0.648673 -0.662545 0.37451 0.648673 -0.662545 0.37451 0.648668 -0.662551 0.374508 0.648668 -0.66255 0.374508 0.648668 -0.66255 0.374508 0.737644 -0.662543 0.130068 0.737644 -0.662543 0.130068 0.737644 -0.662543 0.130068 0.737642 -0.662545 0.130068 0.737642 -0.662545 0.130068 0.737642 -0.662545 0.130068 0.737642 -0.662545 -0.130067 0.737642 -0.662545 -0.130067 0.737642 -0.662545 -0.130067 0.737644 -0.662543 -0.130068 0.737644 -0.662543 -0.130068 0.737644 -0.662543 -0.130068 0.648675 -0.66254 -0.374515 0.648675 -0.66254 -0.374515 0.648675 -0.66254 -0.374515 0.648672 -0.662545 -0.374512 0.648672 -0.662545 -0.374512 0.648672 -0.662545 -0.374512 0.481465 -0.66254 -0.573788 0.481465 -0.66254 -0.573788 0.481465 -0.66254 -0.573788 0.481466 -0.662538 -0.573789 0.481466 -0.662538 -0.573789 0.481466 -0.662538 -0.573789 0.256181 -0.662551 -0.703845 0.256181 -0.662551 -0.703845 0.256181 -0.662551 -0.703845 0.256182 -0.662539 -0.703855 0.256182 -0.662539 -0.703855 0.256182 -0.662539 -0.703855 0 -0.662551 -0.749017 0 -0.662551 -0.749017 0 -0.662551 -0.749017 0 -0.662551 -0.749017 0 -0.662551 -0.749017 0 -0.662551 -0.749017 -0.256183 -0.662539 -0.703855 -0.256183 -0.662539 -0.703855 -0.256183 -0.662539 -0.703855 -0.256178 -0.662551 -0.703846 -0.256178 -0.662551 -0.703846 -0.256178 -0.662551 -0.703846 -0.481462 -0.662546 -0.573784 -0.481462 -0.662546 -0.573784 -0.481462 -0.662546 -0.573784 -0.481466 -0.66254 -0.573787 -0.481466 -0.66254 -0.573787 -0.481466 -0.66254 -0.573787 -0.648673 -0.662545 -0.37451 -0.648673 -0.662545 -0.37451 -0.648673 -0.662545 -0.37451 -0.648669 -0.66255 -0.374508 -0.648669 -0.66255 -0.374508 -0.648669 -0.66255 -0.374508 -0.737644 -0.662543 -0.130068 -0.737644 -0.662543 -0.130068 -0.737644 -0.662543 -0.130068 -0.737642 -0.662545 -0.130068 -0.737642 -0.662545 -0.130068 -0.737642 -0.662545 -0.130068 0.196019 -0.979991 -0.034563 0.196019 -0.979991 -0.034563 0.196019 -0.979991 -0.034563 0.196016 -0.979991 -0.034563 0.196016 -0.979991 -0.034562 0.196016 -0.979991 -0.034563 0.172377 -0.979991 -0.099521 0.172377 -0.979991 -0.099522 0.172377 -0.979991 -0.099521 0.172376 -0.979991 -0.099521 0.172376 -0.979991 -0.099521 0.172376 -0.979991 -0.099521 0.127941 -0.979991 -0.152475 0.127941 -0.979991 -0.152475 0.127941 -0.979991 -0.152475 0.127942 -0.979991 -0.152475 0.127942 -0.979991 -0.152475 0.127942 -0.979991 -0.152475 0.068076 -0.979991 -0.18704 0.068076 -0.979991 -0.18704 0.068076 -0.979991 -0.18704 0.068076 -0.979991 -0.187037 0.068076 -0.979991 -0.187037 0.068076 -0.979991 -0.187037 0 -0.97999 -0.199045 0 -0.97999 -0.199045 0 -0.97999 -0.199045 0 -0.97999 -0.199045 0 -0.97999 -0.199045 0 -0.97999 -0.199045 -0.068075 -0.979991 -0.187037 -0.068075 -0.979991 -0.187037 -0.068075 -0.979991 -0.187037 -0.068077 -0.979991 -0.18704 -0.068077 -0.979991 -0.18704 -0.068077 -0.979991 -0.18704 -0.127942 -0.979991 -0.152475 -0.127942 -0.979991 -0.152475 -0.127942 -0.979991 -0.152475 -0.127941 -0.979991 -0.152475 -0.127941 -0.979991 -0.152475 -0.127941 -0.979991 -0.152475 -0.172376 -0.979991 -0.099521 -0.172376 -0.979991 -0.099521 -0.172376 -0.979991 -0.099521 -0.172377 -0.979991 -0.099521 -0.172377 -0.979991 -0.099521 -0.172377 -0.97999 -0.099521 -0.196016 -0.979991 -0.034563 -0.196016 -0.979991 -0.034563 -0.196016 -0.979991 -0.034563 -0.196019 -0.979991 -0.034563 -0.196019 -0.979991 -0.034563 -0.196019 -0.979991 -0.034563 -0.196019 -0.979991 0.034563 -0.196019 -0.979991 0.034563 -0.196019 -0.979991 0.034563 -0.196016 -0.979991 0.034562 -0.196016 -0.979991 0.034562 -0.196016 -0.979991 0.034562 -0.172373 -0.979992 0.099519 -0.172373 -0.979992 0.099519 -0.172373 -0.979991 0.099519 -0.172376 -0.979991 0.099521 -0.172376 -0.979991 0.099521 -0.172376 -0.979991 0.099521 -0.127941 -0.979991 0.152475 -0.127941 -0.979991 0.152475 -0.127941 -0.979991 0.152475 -0.12794 -0.979992 0.152472 -0.12794 -0.979992 0.152472 -0.12794 -0.979992 0.152472 -0.068076 -0.979991 0.18704 -0.068076 -0.979991 0.18704 -0.068076 -0.979991 0.18704 -0.068076 -0.979991 0.187037 -0.068076 -0.979991 0.187037 -0.068076 -0.979991 0.187037 0 -0.97999 0.199045 0 -0.97999 0.199045 0 -0.97999 0.199045 0 -0.97999 0.199045 0 -0.97999 0.199045 0 -0.97999 0.199045 0.068075 -0.979992 0.187035 0.068075 -0.979992 0.187035 0.068075 -0.979992 0.187035 0.068078 -0.97999 0.187042 0.068078 -0.97999 0.187042 0.068078 -0.97999 0.187042 0.127942 -0.979991 0.152475 0.127942 -0.979991 0.152475 0.127942 -0.979991 0.152475 0.127939 -0.979992 0.152472 0.127939 -0.979992 0.152472 0.127939 -0.979992 0.152472 0.172376 -0.979991 0.099521 0.172376 -0.979991 0.099521 0.172376 -0.979991 0.099521 0.172377 -0.979991 0.099521 0.172377 -0.979991 0.099521 0.172377 -0.979991 0.099521 0.196016 -0.979991 0.034563 0.196016 -0.979991 0.034563 0.196016 -0.979991 0.034563 0.196019 -0.979991 0.034563 0.196019 -0.979991 0.034563 0.196019 -0.979991 0.034563 0.720071 -0.682185 -0.126968 0.720071 -0.682185 -0.126968 0.720071 -0.682185 -0.126968 0.720075 -0.682181 -0.126969 0.720075 -0.682181 -0.126969 0.720075 -0.682181 -0.126969 0.633217 -0.682188 -0.365588 0.633217 -0.682188 -0.365588 0.633217 -0.682188 -0.365588 0.633217 -0.682189 -0.365588 0.633217 -0.682189 -0.365588 0.633217 -0.682189 -0.365588 0.469997 -0.682178 -0.560121 0.469997 -0.682178 -0.560121 0.469997 -0.682178 -0.560121 0.469994 -0.682184 -0.560116 0.469994 -0.682184 -0.560116 0.469994 -0.682184 -0.560116 0.250078 -0.682188 -0.687081 0.250078 -0.682188 -0.687081 0.250078 -0.682188 -0.687081 0.25008 -0.682177 -0.687091 0.25008 -0.682177 -0.687091 0.25008 -0.682177 -0.687091 0 -0.682187 -0.731177 0 -0.682187 -0.731177 0 -0.682187 -0.731177 0 -0.682187 -0.731177 0 -0.682187 -0.731177 0 -0.682187 -0.731177 -0.250082 -0.682177 -0.687091 -0.250082 -0.682177 -0.687091 -0.250082 -0.682177 -0.687091 -0.250078 -0.682184 -0.687085 -0.250078 -0.682184 -0.687085 -0.250078 -0.682184 -0.687085 -0.469992 -0.682186 -0.560116 -0.469992 -0.682186 -0.560116 -0.469992 -0.682186 -0.560116 -0.469998 -0.682178 -0.560121 -0.469998 -0.682178 -0.560121 -0.469998 -0.682178 -0.560121 -0.633222 -0.682183 -0.36559 -0.633222 -0.682183 -0.36559 -0.633222 -0.682183 -0.36559 -0.633222 -0.682184 -0.36559 -0.633222 -0.682184 -0.36559 -0.633222 -0.682184 -0.36559 -0.720075 -0.682181 -0.126969 -0.720075 -0.682181 -0.126969 -0.720075 -0.682181 -0.126969 -0.720073 -0.682183 -0.126969 -0.720073 -0.682183 -0.126969 -0.720073 -0.682183 -0.126969 -0.720073 -0.682183 0.126968 -0.720073 -0.682183 0.126968 -0.720073 -0.682183 0.126968 -0.720075 -0.682181 0.126969 -0.720075 -0.682181 0.126969 -0.720075 -0.682181 0.126969 -0.633225 -0.682178 0.365595 -0.633225 -0.682178 0.365595 -0.633225 -0.682178 0.365595 -0.633222 -0.682183 0.365592 -0.633221 -0.682183 0.365592 -0.633221 -0.682183 0.365592 -0.469998 -0.682178 0.560121 -0.469998 -0.682178 0.560121 -0.469998 -0.682178 0.560121 -0.469999 -0.682176 0.560122 -0.469999 -0.682176 0.560122 -0.469999 -0.682177 0.560122 -0.250078 -0.682188 0.687081 -0.250078 -0.682188 0.687081 -0.250078 -0.682188 0.687081 -0.25008 -0.682177 0.687091 -0.25008 -0.682177 0.687091 -0.25008 -0.682177 0.687091 0 -0.682187 0.731177 0 -0.682187 0.731177 0 -0.682187 0.731177 0 -0.682187 0.731177 0 -0.682187 0.731177 0 -0.682187 0.731177 0.250082 -0.682177 0.68709 0.250082 -0.682177 0.68709 0.250082 -0.682177 0.68709 0.250077 -0.682188 0.687082 0.250077 -0.682188 0.687082 0.250077 -0.682188 0.687082 0.469992 -0.682186 0.560116 0.469992 -0.682186 0.560116 0.469992 -0.682186 0.560116 0.469998 -0.682178 0.560121 0.469998 -0.682178 0.560121 0.469998 -0.682178 0.560121 0.633222 -0.682183 0.36559 0.633222 -0.682183 0.36559 0.633222 -0.682183 0.36559 0.633222 -0.682184 0.36559 0.633222 -0.682184 0.36559 0.633222 -0.682184 0.36559 0.720075 -0.682181 0.126969 0.720075 -0.682181 0.126969 0.720075 -0.682181 0.126969 0.720073 -0.682183 0.126969 0.720073 -0.682183 0.126969 0.720073 -0.682183 0.126969 0.933903 -0.317344 -0.164673 0.933903 -0.317344 -0.164673 0.933903 -0.317344 -0.164673 0.933903 -0.317346 -0.164672 0.933903 -0.317346 -0.164672 0.933903 -0.317346 -0.164672 0.821261 -0.317343 -0.474155 0.821261 -0.317343 -0.474155 0.821261 -0.317343 -0.474155 0.821261 -0.317344 -0.474154 0.821261 -0.317344 -0.474154 0.821261 -0.317344 -0.474155 0.609562 -0.317347 -0.726447 0.609562 -0.317347 -0.726447 0.609562 -0.317347 -0.726447 0.609561 -0.317343 -0.726449 0.609561 -0.317343 -0.726449 0.609561 -0.317343 -0.726449 0.32434 -0.317344 -0.891121 0.32434 -0.317344 -0.891121 0.32434 -0.317344 -0.891121 0.324341 -0.317346 -0.89112 0.324341 -0.317346 -0.89112 0.324341 -0.317346 -0.89112 0 -0.317345 -0.94831 0 -0.317345 -0.94831 0 -0.317345 -0.94831 0 -0.317345 -0.94831 0 -0.317345 -0.94831 0 -0.317345 -0.94831 -0.324341 -0.317346 -0.89112 -0.324341 -0.317346 -0.89112 -0.324341 -0.317346 -0.89112 -0.324341 -0.317345 -0.89112 -0.324341 -0.317345 -0.89112 -0.324341 -0.317345 -0.89112 -0.609562 -0.317347 -0.726447 -0.609562 -0.317347 -0.726447 -0.609562 -0.317347 -0.726447 -0.609562 -0.317347 -0.726447 -0.609562 -0.317347 -0.726447 -0.609562 -0.317347 -0.726447 -0.821262 -0.317344 -0.474154 -0.821262 -0.317344 -0.474154 -0.821262 -0.317344 -0.474154 -0.82126 -0.317347 -0.474155 -0.82126 -0.317347 -0.474155 -0.82126 -0.317347 -0.474155 -0.933903 -0.317346 -0.164673 -0.933903 -0.317346 -0.164673 -0.933903 -0.317346 -0.164673 -0.933904 -0.317344 -0.164672 -0.933904 -0.317344 -0.164672 -0.933904 -0.317344 -0.164672 -0.933903 -0.317344 0.164673 -0.933903 -0.317344 0.164673 -0.933903 -0.317344 0.164673 -0.933903 -0.317346 0.164671 -0.933903 -0.317346 0.164671 -0.933903 -0.317346 0.164671 -0.821261 -0.317343 0.474157 -0.821261 -0.317343 0.474157 -0.82126 -0.317343 0.474157 -0.821261 -0.317344 0.474156 -0.821261 -0.317344 0.474156 -0.821261 -0.317344 0.474156 -0.609562 -0.317347 0.726447 -0.609562 -0.317347 0.726447 -0.609562 -0.317347 0.726447 -0.609561 -0.317343 0.726449 -0.609561 -0.317343 0.726449 -0.609561 -0.317343 0.726449 -0.32434 -0.317344 0.891121 -0.32434 -0.317344 0.891121 -0.32434 -0.317344 0.891121 -0.324341 -0.317346 0.89112 -0.324341 -0.317346 0.89112 -0.324341 -0.317346 0.89112 0 -0.317345 0.94831 0 -0.317345 0.94831 0 -0.317345 0.94831 0 -0.317345 0.94831 0 -0.317345 0.94831 0 -0.317345 0.94831 0.324341 -0.317344 0.89112 0.324341 -0.317344 0.89112 0.324341 -0.317344 0.89112 0.32434 -0.317345 0.89112 0.32434 -0.317345 0.89112 0.32434 -0.317345 0.89112 0.609563 -0.317347 0.726447 0.609563 -0.317347 0.726447 0.609563 -0.317347 0.726447 0.609565 -0.317344 0.726446 0.609565 -0.317344 0.726446 0.609565 -0.317344 0.726446 0.821262 -0.317344 0.474154 0.821262 -0.317344 0.474154 0.821262 -0.317344 0.474154 0.82126 -0.317347 0.474155 0.82126 -0.317347 0.474155 0.82126 -0.317347 0.474155 0.933903 -0.317346 0.164673 0.933903 -0.317346 0.164673 0.933903 -0.317346 0.164673 0.933904 -0.317344 0.164672 0.933904 -0.317344 0.164672 0.933904 -0.317344 0.164672 0.968281 -0.182433 -0.170734 0.968281 -0.182433 -0.170734 0.968281 -0.182433 -0.170734 0.968282 -0.182427 -0.170736 0.968282 -0.182427 -0.170736 0.968282 -0.182427 -0.170736 0.851493 -0.182431 -0.491609 0.851493 -0.182431 -0.491609 0.851493 -0.182431 -0.491608 0.851493 -0.182432 -0.491608 0.851493 -0.182432 -0.491608 0.851493 -0.182432 -0.491608 0.632 -0.182427 -0.753191 0.632 -0.182427 -0.753191 0.632 -0.182427 -0.753191 0.632001 -0.182433 -0.753188 0.632001 -0.182433 -0.753188 0.632001 -0.182433 -0.753188 0.336281 -0.182434 -0.923923 0.336281 -0.182434 -0.923923 0.336281 -0.182434 -0.923923 0.336278 -0.182428 -0.923925 0.336278 -0.182428 -0.923925 0.336278 -0.182428 -0.923925 0 -0.182433 -0.983218 0 -0.182433 -0.983218 0 -0.182433 -0.983218 0 -0.182433 -0.983218 0 -0.182433 -0.983218 0 -0.182433 -0.983218 -0.336281 -0.182428 -0.923924 -0.336281 -0.182428 -0.923924 -0.336281 -0.182428 -0.923924 -0.336279 -0.182431 -0.923924 -0.336279 -0.182431 -0.923924 -0.336279 -0.182431 -0.923924 -0.632002 -0.182427 -0.753189 -0.632002 -0.182427 -0.753189 -0.632002 -0.182427 -0.753189 -0.632002 -0.182427 -0.753189 -0.632002 -0.182427 -0.753189 -0.632002 -0.182427 -0.753189 -0.851492 -0.182432 -0.49161 -0.851492 -0.182432 -0.49161 -0.851492 -0.182432 -0.49161 -0.851493 -0.182427 -0.491609 -0.851493 -0.182427 -0.491609 -0.851493 -0.182427 -0.491609 -0.968282 -0.182427 -0.170734 -0.968282 -0.182427 -0.170734 -0.968282 -0.182427 -0.170734 -0.968281 -0.182433 -0.170736 -0.968281 -0.182433 -0.170736 -0.968281 -0.182433 -0.170736 -0.968281 -0.182434 0.170733 -0.968281 -0.182434 0.170733 -0.968281 -0.182434 0.170733 -0.968282 -0.182427 0.170736 -0.968282 -0.182427 0.170736 -0.968282 -0.182427 0.170736 -0.851492 -0.182431 0.49161 -0.851492 -0.182431 0.49161 -0.851492 -0.182431 0.49161 -0.851492 -0.182436 0.491608 -0.851492 -0.182436 0.491608 -0.851492 -0.182436 0.491608 -0.632 -0.182427 0.753191 -0.632 -0.182427 0.753191 -0.632 -0.182427 0.753191 -0.632001 -0.182433 0.753188 -0.632001 -0.182433 0.753188 -0.632001 -0.182433 0.753188 -0.336281 -0.182434 0.923923 -0.336281 -0.182434 0.923923 -0.336281 -0.182434 0.923923 -0.336279 -0.182428 0.923925 -0.336278 -0.182428 0.923925 -0.336278 -0.182428 0.923925 0 -0.182433 0.983218 0 -0.182433 0.983218 0 -0.182433 0.983218 0 -0.182433 0.983218 0 -0.182433 0.983218 0 -0.182433 0.983218 0.33628 -0.182431 0.923924 0.33628 -0.182431 0.923924 0.33628 -0.182431 0.923924 0.336279 -0.182431 0.923924 0.336279 -0.182431 0.923924 0.336279 -0.182431 0.923924 0.632004 -0.182427 0.753188 0.632004 -0.182427 0.753188 0.632004 -0.182427 0.753188 0.632001 -0.182432 0.753188 0.632001 -0.182432 0.753188 0.632001 -0.182432 0.753188 0.851492 -0.182432 0.49161 0.851492 -0.182432 0.49161 0.851492 -0.182432 0.49161 0.851494 -0.182427 0.491609 0.851493 -0.182427 0.491609 0.851494 -0.182427 0.491609 0.968282 -0.182427 0.170734 0.968282 -0.182427 0.170734 0.968282 -0.182427 0.170734 0.968281 -0.182433 0.170736 0.968281 -0.182433 0.170736 0.968281 -0.182433 0.170736 -0.097731 -0.995064 0.017232 -0.097731 -0.995064 0.017232 -0.097731 -0.995064 0.017232 -0.097731 -0.995064 0.017232 -0.097731 -0.995064 0.017232 -0.097731 -0.995064 0.017232 -0.085943 -0.995064 0.049619 -0.085943 -0.995064 0.049619 -0.085943 -0.995064 0.049619 -0.085943 -0.995064 0.049619 -0.085943 -0.995064 0.049619 -0.085943 -0.995064 0.049619 -0.063789 -0.995064 0.076021 -0.063789 -0.995064 0.076021 -0.063789 -0.995064 0.076021 -0.063789 -0.995064 0.076021 -0.063789 -0.995064 0.076021 -0.063789 -0.995064 0.076021 -0.033941 -0.995064 0.093254 -0.033941 -0.995064 0.093254 -0.033941 -0.995064 0.093254 -0.033941 -0.995064 0.093254 -0.033941 -0.995064 0.093254 -0.033941 -0.995064 0.093254 0 -0.995064 0.099239 0 -0.995064 0.099239 0 -0.995064 0.099239 0 -0.995064 0.099239 0 -0.995064 0.099239 0 -0.995064 0.099239 0.033941 -0.995064 0.093254 0.033941 -0.995064 0.093254 0.033941 -0.995064 0.093254 0.033941 -0.995064 0.093254 0.033941 -0.995064 0.093254 0.033941 -0.995064 0.093254 0.063789 -0.995064 0.076021 0.063789 -0.995064 0.076021 0.063789 -0.995064 0.076021 0.063789 -0.995064 0.076021 0.063789 -0.995064 0.076021 0.063789 -0.995064 0.076021 0.085943 -0.995064 0.049619 0.085943 -0.995064 0.049619 0.085943 -0.995064 0.049619 0.085943 -0.995064 0.049619 0.085943 -0.995064 0.049619 0.085943 -0.995064 0.049619 0.097731 -0.995064 0.017232 0.097731 -0.995064 0.017232 0.097731 -0.995064 0.017232 0.097731 -0.995064 0.017232 0.097731 -0.995064 0.017232 0.097731 -0.995064 0.017232 0.097731 -0.995064 -0.017232 0.097731 -0.995064 -0.017232 0.097731 -0.995064 -0.017232 0.097731 -0.995064 -0.017232 0.097731 -0.995064 -0.017232 0.097731 -0.995064 -0.017232 0.085943 -0.995064 -0.049619 0.085943 -0.995064 -0.049619 0.085943 -0.995064 -0.049619 0.085943 -0.995064 -0.049619 0.085943 -0.995064 -0.049619 0.085943 -0.995064 -0.049619 0.063789 -0.995064 -0.076021 0.063789 -0.995064 -0.076021 0.063789 -0.995064 -0.076021 0.063789 -0.995064 -0.076021 0.063789 -0.995064 -0.076021 0.063789 -0.995064 -0.076021 0.033941 -0.995064 -0.093254 0.033941 -0.995064 -0.093254 0.033941 -0.995064 -0.093254 0.033941 -0.995064 -0.093254 0.033941 -0.995064 -0.093254 0.033941 -0.995064 -0.093254 0 -0.995064 -0.099239 0 -0.995064 -0.099239 0 -0.995064 -0.099239 0 -0.995064 -0.099239 0 -0.995064 -0.099239 0 -0.995064 -0.099239 -0.033941 -0.995064 -0.093254 -0.033941 -0.995064 -0.093254 -0.033941 -0.995064 -0.093254 -0.033941 -0.995064 -0.093254 -0.033941 -0.995064 -0.093254 -0.033941 -0.995064 -0.093254 -0.063789 -0.995064 -0.076021 -0.063789 -0.995064 -0.076021 -0.063789 -0.995064 -0.076021 -0.063789 -0.995064 -0.076021 -0.063789 -0.995064 -0.076021 -0.063789 -0.995064 -0.076021 -0.085943 -0.995064 -0.049619 -0.085943 -0.995064 -0.049619 -0.085943 -0.995064 -0.049619 -0.085943 -0.995064 -0.049619 -0.085943 -0.995064 -0.049619 -0.085943 -0.995064 -0.049619 -0.097731 -0.995064 -0.017232 -0.097731 -0.995064 -0.017232 -0.097731 -0.995064 -0.017232 -0.097731 -0.995064 -0.017232 -0.097731 -0.995064 -0.017232 -0.097731 -0.995064 -0.017232 -0.042511 -0.999068 0.007495 -0.042511 -0.999068 0.007495 -0.042511 -0.999068 0.007495 -0.042511 -0.999068 0.007495 -0.042511 -0.999068 0.007495 -0.042511 -0.999068 0.007495 -0.037383 -0.999068 0.021583 -0.037383 -0.999068 0.021583 -0.037383 -0.999068 0.021583 -0.037383 -0.999068 0.021583 -0.037383 -0.999068 0.021583 -0.037383 -0.999068 0.021583 -0.027747 -0.999068 0.033067 -0.027747 -0.999068 0.033067 -0.027747 -0.999068 0.033067 -0.027747 -0.999068 0.033068 -0.027747 -0.999068 0.033068 -0.027747 -0.999068 0.033068 -0.014764 -0.999068 0.040563 -0.014764 -0.999068 0.040563 -0.014764 -0.999068 0.040563 -0.014764 -0.999068 0.040563 -0.014764 -0.999068 0.040563 -0.014764 -0.999068 0.040563 0 -0.999068 0.043167 0 -0.999068 0.043167 0 -0.999068 0.043167 0 -0.999068 0.043167 0 -0.999068 0.043167 0 -0.999068 0.043167 0.014764 -0.999068 0.040563 0.014764 -0.999068 0.040563 0.014764 -0.999068 0.040563 0.014764 -0.999068 0.040563 0.014764 -0.999068 0.040563 0.014764 -0.999068 0.040563 0.027747 -0.999068 0.033068 0.027747 -0.999068 0.033068 0.027747 -0.999068 0.033068 0.027747 -0.999068 0.033068 0.027747 -0.999068 0.033068 0.027747 -0.999068 0.033068 0.037383 -0.999068 0.021583 0.037383 -0.999068 0.021583 0.037383 -0.999068 0.021583 0.037383 -0.999068 0.021583 0.037383 -0.999068 0.021583 0.037383 -0.999068 0.021583 0.042511 -0.999068 0.007495 0.042511 -0.999068 0.007495 0.042511 -0.999068 0.007495 0.042511 -0.999068 0.007495 0.042511 -0.999068 0.007495 0.042511 -0.999068 0.007495 0.042511 -0.999068 -0.007495 0.042511 -0.999068 -0.007495 0.042511 -0.999068 -0.007495 0.042511 -0.999068 -0.007495 0.042511 -0.999068 -0.007495 0.042511 -0.999068 -0.007495 0.037383 -0.999068 -0.021583 0.037383 -0.999068 -0.021583 0.037383 -0.999068 -0.021583 0.037383 -0.999068 -0.021583 0.037383 -0.999068 -0.021583 0.037383 -0.999068 -0.021583 0.027747 -0.999068 -0.033067 0.027747 -0.999068 -0.033067 0.027747 -0.999068 -0.033067 0.027747 -0.999068 -0.033068 0.027747 -0.999068 -0.033068 0.027747 -0.999068 -0.033068 0.014764 -0.999068 -0.040563 0.014764 -0.999068 -0.040563 0.014764 -0.999068 -0.040563 0.014764 -0.999068 -0.040563 0.014764 -0.999068 -0.040563 0.014764 -0.999068 -0.040563 0 -0.999068 -0.043167 0 -0.999068 -0.043167 0 -0.999068 -0.043167 0 -0.999068 -0.043167 0 -0.999068 -0.043167 0 -0.999068 -0.043167 -0.014764 -0.999068 -0.040563 -0.014764 -0.999068 -0.040563 -0.014764 -0.999068 -0.040563 -0.014764 -0.999068 -0.040563 -0.014764 -0.999068 -0.040563 -0.014764 -0.999068 -0.040563 -0.027747 -0.999068 -0.033068 -0.027747 -0.999068 -0.033068 -0.027747 -0.999068 -0.033068 -0.027747 -0.999068 -0.033068 -0.027747 -0.999068 -0.033068 -0.027747 -0.999068 -0.033068 -0.037383 -0.999068 -0.021583 -0.037383 -0.999068 -0.021583 -0.037383 -0.999068 -0.021583 -0.037383 -0.999068 -0.021583 -0.037383 -0.999068 -0.021583 -0.037383 -0.999068 -0.021583 -0.042511 -0.999068 -0.007495 -0.042511 -0.999068 -0.007495 -0.042511 -0.999068 -0.007495 -0.042511 -0.999068 -0.007495 -0.042511 -0.999068 -0.007495 -0.042511 -0.999068 -0.007495 0.052686 0.998568 -0.009289 0.052686 0.998568 -0.009289 0.052686 0.998568 -0.009289 0.046332 0.998568 -0.026749 0.046332 0.998568 -0.026749 0.046332 0.998568 -0.026749 0.034388 0.998568 -0.040982 0.034388 0.998568 -0.040982 0.034388 0.998568 -0.040982 0.018297 0.998568 -0.050273 0.018297 0.998568 -0.050273 0.018297 0.998568 -0.050273 0 0.998568 -0.053499 0 0.998568 -0.053499 0 0.998568 -0.053499 -0.018297 0.998568 -0.050273 -0.018297 0.998568 -0.050273 -0.018297 0.998568 -0.050273 -0.034388 0.998568 -0.040982 -0.034388 0.998568 -0.040982 -0.034388 0.998568 -0.040982 -0.046332 0.998568 -0.026749 -0.046332 0.998568 -0.026749 -0.046332 0.998568 -0.026749 -0.052686 0.998568 -0.009289 -0.052686 0.998568 -0.009289 -0.052686 0.998568 -0.009289 -0.052686 0.998568 0.009289 -0.052686 0.998568 0.009289 -0.052686 0.998568 0.009289 -0.046331 0.998568 0.026749 -0.046331 0.998568 0.026749 -0.046331 0.998568 0.026749 -0.034388 0.998568 0.040982 -0.034388 0.998568 0.040982 -0.034388 0.998568 0.040982 -0.018297 0.998568 0.050273 -0.018297 0.998568 0.050273 -0.018297 0.998568 0.050273 0 0.998568 0.053499 0 0.998568 0.053499 0 0.998568 0.053499 0.018297 0.998568 0.050273 0.018297 0.998568 0.050273 0.018297 0.998568 0.050273 0.034388 0.998568 0.040982 0.034388 0.998568 0.040982 0.034388 0.998568 0.040982 0.046332 0.998568 0.026749 0.046332 0.998568 0.026749 0.046332 0.998568 0.026749 0.052686 0.998568 0.009289 0.052686 0.998568 0.009289 0.052686 0.998568 0.009289 0.017211 -0.999847 -0.003034 0.017211 -0.999847 -0.003034 0.017211 -0.999847 -0.003034 0.015135 -0.999847 -0.008738 0.015135 -0.999847 -0.008738 0.015135 -0.999847 -0.008738 0.011234 -0.999847 -0.013388 0.011234 -0.999847 -0.013388 0.011234 -0.999847 -0.013388 0.005977 -0.999847 -0.016423 0.005977 -0.999847 -0.016423 0.005977 -0.999847 -0.016423 0 -0.999847 -0.017477 0 -0.999847 -0.017477 0 -0.999847 -0.017477 -0.005977 -0.999847 -0.016423 -0.005977 -0.999847 -0.016423 -0.005977 -0.999847 -0.016423 -0.011234 -0.999847 -0.013388 -0.011234 -0.999847 -0.013388 -0.011234 -0.999847 -0.013388 -0.015135 -0.999847 -0.008738 -0.015135 -0.999847 -0.008738 -0.015135 -0.999847 -0.008738 -0.017211 -0.999847 -0.003034 -0.017211 -0.999847 -0.003034 -0.017211 -0.999847 -0.003034 -0.017211 -0.999847 0.003034 -0.017211 -0.999847 0.003034 -0.017211 -0.999847 0.003034 -0.015135 -0.999847 0.008738 -0.015135 -0.999847 0.008738 -0.015135 -0.999847 0.008738 -0.011234 -0.999847 0.013388 -0.011234 -0.999847 0.013388 -0.011234 -0.999847 0.013388 -0.005977 -0.999847 0.016423 -0.005977 -0.999847 0.016423 -0.005977 -0.999847 0.016423 0 -0.999847 0.017477 0 -0.999847 0.017477 0 -0.999847 0.017477 0.005977 -0.999847 0.016423 0.005977 -0.999847 0.016423 0.005977 -0.999847 0.016423 0.011234 -0.999847 0.013388 0.011234 -0.999847 0.013388 0.011234 -0.999847 0.013388 0.015135 -0.999847 0.008738 0.015135 -0.999847 0.008738 0.015135 -0.999847 0.008738 0.017211 -0.999847 0.003034 0.017211 -0.999847 0.003034 0.017211 -0.999847 0.003034</float_array>
          <technique_common>
            <accessor source="#___C_____layer1-mesh-normals-array" count="2268" stride="3">
              <param name="X" type="float"/>
              <param name="Y" type="float"/>
              <param name="Z" type="float"/>
            </accessor>
          </technique_common>
        </source>
        <source id="___C_____layer1-mesh-map-channel1">
          <float_array id="___C_____layer1-mesh-map-channel1-array" count="1248">0.414298 0.409032 0.462291 0.57463 0.349775 -0.497838 0.596789 0.388748 -0.497838 0.466085 0.500113 0.462291 0.642756 0.603688 0.462292 0.672384 0.433066 -0.497838 0.716702 0.433066 -0.497838 0.843658 0.567717 0.462292 0.923 0.500113 0.462292 0.822151 0.305457 -0.497838 0.992773 0.305457 0.462292 0.814455 0.26114 -0.497838 0.974787 0.201883 0.462292 0.923 0.110801 0.462292 0.843658 0.043198 0.462292 0.758347 0.193241 -0.497838 0.642755 0.007226 0.462291 0.545427 0.043198 0.462291 0.466085 0.110801 0.462291 0.414298 0.201883 0.462291 0.397664 0.305457 0.499999 0.546103 0.566528 0.5 0.64299 0.602336 0.5 0.921965 0.499231 0.5 0.973518 0.408562 0.5 0.973518 0.202352 0.5 0.842982 0.044386 0.5 0.746095 0.008578 0.5 0.64299 0.008578 0.499999 0.546103 0.044386 0.499999 0.415568 0.202352 0.499999 0.396312 0.305457 0.462291 0.415568 0.408562 0.499999 0.46712 0.499231 0.5 0.545427 0.567717 0.462292 0.746095 0.602336 0.5 0.74633 0.603688 0.462292 0.842982 0.566528 0.5 0.974787 0.409032 0.462292 0.991422 0.305457 0.5 0.921965 0.111683 0.5 0.74633 0.007226 0.462291 0.46712 0.111684 0.499999 0.597568 0.305457 -0.5 0.620255 0.368753 -0.5 0.630739 0.417674 -0.497838 0.646055 0.390736 -0.5 0.74303 0.390736 -0.5 0.758347 0.417674 -0.497838 0.78567 0.339137 -0.5 0.792296 0.388748 -0.497838 0.814455 0.349775 -0.497838 0.791518 0.305457 -0.5 0.792296 0.222167 -0.497838 0.74303 0.220179 -0.5 0.711382 0.208482 -0.5 0.677703 0.208482 -0.5 0.716702 0.177849 -0.497838 0.646055 0.220179 -0.5 0.672384 0.177849 -0.497838 0.620255 0.242161 -0.5 0.630739 0.193241 -0.497838 0.174029 0.255156 -0.717882 0.596789 0.222167 -0.497838 0.194554 0.262742 -0.717882 0.57463 0.26114 -0.497838 0.253655 0.240899 -0.717882 0.268369 0.199848 -0.717882 0.603416 0.271778 -0.5 0.264576 0.178005 -0.717882 0.566935 0.305457 -0.497838 0.603416 0.339137 -0.5 0.677703 0.402433 -0.5 0.711382 0.402433 -0.5 0.76883 0.368753 -0.5 0.78567 0.271778 -0.5 0.76883 0.242161 -0.5 0.542045 0.715603 0.498401 0.538194 0.715603 0.5 0.522533 0.805794 0.5 0.410273 0.94736 0.498401 0.408348 0.943974 0.5 0.323596 0.975297 0.5 0.324265 0.979147 0.498401 0.233406 0.975297 0.5 0.148654 0.943974 0.5 0.076614 0.887619 0.498401 0.079564 0.885106 0.5 0.034469 0.805794 0.5 0.03085 0.807131 0.498401 0.03085 0.624075 0.498401 0.079564 0.5461 0.5 0.146729 0.483846 0.498401 0.148654 0.487233 0.5 0.232737 0.452059 0.498401 0.323597 0.45591 0.5 0.324265 0.452059 0.498401 0.410273 0.483846 0.498401 0.408348 0.487233 0.5 0.526152 0.624075 0.498401 0.522533 0.625413 0.5 0.526151 0.807131 0.498401 0.480388 0.887619 0.498401 0.232737 0.979147 0.498401 0.146729 0.94736 0.498401 0.014957 0.715603 0.498401 0.076614 0.543587 0.498401 0.480388 0.543587 0.498401 0.340916 0.715603 -0.470627 0.326314 0.756342 -0.470627 0.289339 0.778018 -0.470627 0.272292 0.751359 -0.489816 0.247294 0.77049 -0.470627 0.25111 0.738941 -0.489816 0.230688 0.756342 -0.470627 0.216086 0.715603 -0.470627 0.242745 0.715603 -0.489816 0.230688 0.674865 -0.470627 0.267663 0.653188 -0.470627 0.260623 0.68416 -0.489816 0.289339 0.653188 -0.470627 0.296379 0.68416 -0.489816 0.337152 0.693927 -0.470627 0.305892 0.692265 -0.489816 0.35322 0.743218 -0.441844 0.337152 0.73728 -0.470627 0.339413 0.767503 -0.441844 0.309709 0.77049 -0.470627 0.267663 0.778018 -0.470627 0.203782 0.743218 -0.441844 0.21985 0.73728 -0.470627 0.203782 0.687988 -0.441844 0.21985 0.693927 -0.470627 0.247294 0.660716 -0.470627 0.264694 0.636088 -0.441844 0.318258 0.645679 -0.441844 0.309709 0.660716 -0.470627 0.339413 0.663704 -0.441844 0.326314 0.674865 -0.470627 0.385032 0.715603 -0.353896 0.378607 0.752601 -0.353896 0.331767 0.809285 -0.353896 0.318258 0.785527 -0.441844 0.297 0.822134 -0.353896 0.292309 0.795118 -0.441844 0.260002 0.822134 -0.353896 0.264693 0.795118 -0.441844 0.238744 0.785527 -0.441844 0.217589 0.767503 -0.441844 0.178395 0.752601 -0.353896 0.17197 0.715603 -0.353896 0.198986 0.715603 -0.441844 0.196894 0.64607 -0.353896 0.217589 0.663704 -0.441844 0.238744 0.645679 -0.441844 0.260002 0.609072 -0.353896 0.297 0.609072 -0.353896 0.292309 0.636089 -0.441844 0.331767 0.621922 -0.353896 0.360108 0.64607 -0.353896 0.35322 0.687988 -0.441844 0.378607 0.678605 -0.353896 0.358016 0.715603 -0.441844 0.407838 0.715603 -0.267547 0.377579 0.800022 -0.267547 0.360108 0.785136 -0.353896 0.213833 0.82934 -0.267547 0.225236 0.809285 -0.353896 0.196894 0.785136 -0.353896 0.178395 0.678605 -0.353896 0.179424 0.631185 -0.267547 0.225236 0.621921 -0.353896 0.377579 0.631185 -0.267547 0.400038 0.670685 -0.267547 0.400038 0.760521 -0.267547 0.396349 0.816015 -0.155613 0.355421 0.850888 -0.155613 0.305215 0.869443 -0.155613 0.343169 0.82934 -0.267547 0.251787 0.869443 -0.155613 0.30096 0.84494 -0.267547 0.201581 0.850888 -0.155613 0.256042 0.84494 -0.267547 0.179424 0.800021 -0.267547 0.156965 0.760521 -0.267547 0.124661 0.715603 -0.155613 0.133939 0.662175 -0.155613 0.149165 0.715603 -0.267547 0.156965 0.670685 -0.267547 0.160653 0.615191 -0.155613 0.201581 0.580319 -0.155613 0.213833 0.601867 -0.267547 0.256042 0.586267 -0.267547 0.30096 0.586267 -0.267547 0.305215 0.561763 -0.155613 0.343169 0.601867 -0.267547 0.355421 0.580319 -0.155613 0.396349 0.615191 -0.155613 0.432341 0.715603 -0.155613 0.423063 0.769031 -0.155613 0.366262 0.869955 -0.026089 0.30898 0.891126 -0.026089 0.248022 0.891126 -0.026089 0.160653 0.816015 -0.155613 0.113564 0.776562 -0.026089 0.133939 0.769031 -0.155613 0.102979 0.715603 -0.026089 0.113564 0.654645 -0.026089 0.144043 0.601039 -0.026089 0.19074 0.561251 -0.026089 0.251787 0.561763 -0.155613 0.30898 0.540081 -0.026089 0.366262 0.561251 -0.026089 0.412959 0.601039 -0.026089 0.423063 0.662175 -0.155613 0.454024 0.715603 -0.026089 0.443438 0.776562 -0.026089 0.412959 0.830167 -0.026089 0.400942 0.930949 0.410454 0.15606 0.930949 0.410453 0.19074 0.869955 -0.026089 0.048386 0.80065 0.410453 0.144043 0.830167 -0.026089 0.248022 0.540081 -0.026089 0.400943 0.500257 0.410453 0.466092 0.555767 0.410453 0.523384 0.715603 0.410453 0.443438 0.654645 -0.026089 0.477438 0.885106 0.5 0.508616 0.80065 0.410453 0.466092 0.875439 0.410453 0.321025 0.960486 0.410453 0.235978 0.960486 0.410453 0.09091 0.875439 0.410453 0.018807 0.715603 0.5 0.034469 0.625413 0.5 0.033618 0.715603 0.410453 0.048386 0.630556 0.410453 0.09091 0.555767 0.410453 0.15606 0.500257 0.410453 0.233406 0.45591 0.5 0.235978 0.47072 0.410453 0.321025 0.47072 0.410453 0.477438 0.5461 0.5 0.508616 0.630556 0.410453 0.314257 0.715603 -0.489816 0.312101 0.728021 -0.489816 0.305892 0.738941 -0.489816 0.296379 0.747046 -0.489816 0.28471 0.751359 -0.489816 0.260623 0.747046 -0.489816 0.244901 0.728021 -0.489816 0.278501 0.715603 -0.5 0.244901 0.703185 -0.489816 0.25111 0.692265 -0.489816 0.272292 0.679847 -0.489816 0.28471 0.679847 -0.489816 0.312101 0.703185 -0.489816 0.253655 0.158797 -0.717882 0.236922 0.144541 -0.717882 0.142582 0.199848 -0.717882 0.177108 0.210333 -0.725877 0.146375 0.221691 -0.717882 0.157296 0.240899 -0.717882 0.18235 0.219552 -0.725877 0.190381 0.226396 -0.725877 0.200234 0.230037 -0.725877 0.22057 0.226396 -0.725877 0.216397 0.262742 -0.717882 0.236922 0.255156 -0.717882 0.235664 0.199848 -0.725877 0.264576 0.221691 -0.717882 0.22057 0.173301 -0.725877 0.210718 0.16966 -0.725877 0.216397 0.136955 -0.717882 0.194554 0.136955 -0.717882 0.174029 0.144541 -0.717882 0.190381 0.173301 -0.725877 0.177108 0.189364 -0.725877 0.157296 0.158797 -0.717882 0.146375 0.178005 -0.717882 0.175287 0.199848 -0.725877 0.205476 0.199848 -0.722891 0.210718 0.230037 -0.725877 0.228602 0.219552 -0.725877 0.233844 0.210333 -0.725877 0.233844 0.189364 -0.725877 0.228602 0.180144 -0.725877 0.200234 0.16966 -0.725877 0.18235 0.180144 -0.725877 0.046438 0.199807 0.5 0.083656 0.303641 0.5 0.12598 0.339703 0.5 0.285064 0.339703 0.5 0.355012 0.255056 0.5 0.364605 0.199807 0.5 0.285064 0.059911 0.5 0.233146 0.040723 0.5 0.177897 0.040723 0.5 0.12598 0.059911 0.5 0.083656 0.095972 0.5 0.056032 0.144558 0.5 0.090036 0.242489 -0.407717 0.056032 0.255056 0.5 0.144073 0.307881 -0.407717 0.177897 0.358891 0.5 0.226863 0.322704 -0.407716 0.26697 0.307881 -0.407716 0.233146 0.358891 0.5 0.327387 0.303641 0.5 0.321008 0.157125 -0.407717 0.355012 0.144558 0.5 0.299667 0.119591 -0.407717 0.327387 0.095972 0.5 0.184181 0.076909 -0.407717 0.090036 0.157125 -0.407717 0.082624 0.199807 -0.407717 0.093635 0.241159 -0.5 0.111377 0.280022 -0.407717 0.114311 0.277522 -0.5 0.184181 0.322704 -0.407716 0.184846 0.318874 -0.5 0.265055 0.304513 -0.5 0.299667 0.280022 -0.407716 0.296732 0.277522 -0.5 0.321008 0.242489 -0.407716 0.328419 0.199807 -0.407717 0.324589 0.199807 -0.5 0.26697 0.091732 -0.407717 0.226863 0.076909 -0.407717 0.184846 0.080739 -0.5 0.144073 0.091732 -0.407717 0.111377 0.119591 -0.407717 0.093635 0.158456 -0.5 0.086454 0.199807 -0.5 0.09071 0.199807 -0.481579 0.117571 0.274745 -0.481579 0.145988 0.304513 -0.5 0.148116 0.30077 -0.481578 0.225459 0.314618 -0.481578 0.226198 0.318874 -0.5 0.262927 0.30077 -0.481578 0.293472 0.274745 -0.481578 0.313409 0.23968 -0.481578 0.320333 0.199807 -0.481578 0.317408 0.241158 -0.5 0.317408 0.158455 -0.5 0.313409 0.159933 -0.481579 0.296732 0.122091 -0.5 0.293472 0.124869 -0.481579 0.265055 0.095101 -0.5 0.226198 0.080739 -0.5 0.145988 0.095101 -0.500001 0.117571 0.124869 -0.481579 0.114311 0.122091 -0.5 0.095588 0.199807 -0.394087 0.102218 0.237987 -0.394087 0.121308 0.271561 -0.394087 0.097634 0.23968 -0.481579 0.150555 0.296481 -0.394086 0.186432 0.309741 -0.394086 0.185585 0.314618 -0.481578 0.260489 0.296481 -0.394086 0.289736 0.271561 -0.394086 0.315456 0.199807 -0.394086 0.260489 0.103133 -0.394087 0.262927 0.098843 -0.481579 0.224612 0.089873 -0.394087 0.186432 0.089873 -0.394087 0.225459 0.084995 -0.481579 0.185585 0.084995 -0.481579 0.148116 0.098843 -0.481579 0.102218 0.161627 -0.394087 0.097634 0.159934 -0.481579 0.132167 0.262308 0.080217 0.157643 0.284015 0.080217 0.188894 0.295564 0.080218 0.224612 0.309741 -0.394086 0.253401 0.284015 0.080218 0.295504 0.233063 0.080218 0.308826 0.237987 -0.394086 0.301279 0.199807 0.080217 0.295504 0.166551 0.080217 0.308826 0.161627 -0.394087 0.253401 0.115599 0.080217 0.289736 0.128053 -0.394087 0.188894 0.104049 0.080217 0.150555 0.103133 -0.394087 0.157643 0.115599 0.080217 0.115539 0.166551 0.080217 0.121308 0.128053 -0.394087 0.109764 0.199807 0.080217 0.127276 0.228726 0.397954 0.115539 0.233063 0.080217 0.219981 0.283075 0.397955 0.22215 0.295564 0.080218 0.269309 0.254156 0.397955 0.278876 0.262308 0.080218 0.28879 0.199807 0.397955 0.278876 0.137306 0.080217 0.22215 0.104049 0.080217 0.132167 0.137306 0.080217 0.127276 0.170888 0.397954 0.122254 0.199807 0.397954 0.141735 0.254156 0.397955 0.163888 0.273031 0.397955 0.191063 0.283075 0.397955 0.247156 0.273031 0.397955 0.283768 0.228726 0.397955 0.283768 0.170888 0.397954 0.269309 0.145458 0.397954 0.247156 0.126582 0.397954 0.219981 0.116539 0.397954 0.191063 0.116539 0.397954 0.163888 0.126582 0.397954 0.141735 0.145458 0.397954</float_array>
          <technique_common>
            <accessor source="#___C_____layer1-mesh-map-channel1-array" count="416" stride="3">
              <param name="S" type="float"/>
              <param name="T" type="float"/>
              <param name="P" type="float"/>
            </accessor>
          </technique_common>
        </source>
        <vertices id="___C_____layer1-mesh-vertices">
          <input semantic="POSITION" source="#___C_____layer1-mesh-positions"/>
        </vertices>
        <triangles material="mat1" count="756">
          <input semantic="VERTEX" source="#___C_____layer1-mesh-vertices" offset="0"/>
          <input semantic="NORMAL" source="#___C_____layer1-mesh-normals" offset="1"/>
          <input semantic="TEXCOORD" source="#___C_____layer1-mesh-map-channel1" offset="2" set="1"/>
          <p>1 0 1 0 1 0 44 2 31 44 3 31 215 4 70 1 5 1 2 6 2 3 7 3 0 8 0 0 9 0 1 10 1 2 11 2 195 12 45 47 13 34 3 14 3 3 15 3 2 16 2 195 17 45 5 18 5 4 19 4 47 20 34 47 21 34 195 22 45 5 23 5 6 24 6 49 25 36 4 26 4 4 27 4 5 28 5 6 29 6 198 30 48 7 31 7 49 32 36 49 33 36 6 34 6 198 35 48 200 36 50 8 37 8 7 38 7 7 39 7 198 40 48 200 41 50 201 42 51 51 43 38 8 44 8 8 45 8 200 46 50 201 47 51 9 48 9 10 49 10 51 50 38 51 51 38 201 52 51 9 53 9 11 54 11 12 55 12 10 56 10 10 57 10 9 58 9 11 59 11 203 60 53 13 61 13 12 62 12 12 63 12 11 64 11 203 65 53 15 66 15 14 67 14 13 68 13 13 69 13 203 70 53 15 71 15 207 72 57 54 73 41 14 74 14 14 75 14 15 76 15 207 77 57 209 78 59 16 79 16 54 80 41 54 81 41 207 82 57 209 83 59 211 84 61 17 85 17 16 86 16 16 87 16 209 88 59 211 89 61 212 90 63 18 91 18 17 92 17 17 93 17 211 94 61 212 95 63 213 96 65 19 97 19 18 98 18 18 99 18 212 100 63 213 101 65 215 102 70 44 103 31 19 104 19 19 105 19 213 106 65 215 107 70 45 108 101 22 109 79 21 110 78 21 111 78 20 112 77 45 113 101 46 114 102 176 115 228 22 116 79 22 117 79 45 118 101 46 119 102 23 120 80 24 121 81 176 122 228 176 123 228 46 124 102 23 125 80 26 126 83 25 127 82 24 128 81 24 129 81 23 130 80 26 131 83 48 132 103 27 133 84 25 134 82 25 135 82 26 136 83 48 137 103 50 138 104 28 139 85 27 140 84 27 141 84 48 142 103 50 143 104 29 144 86 30 145 87 28 146 85 28 147 85 50 148 104 29 149 86 32 150 89 31 151 88 30 152 87 30 153 87 29 154 86 32 155 89 52 156 105 182 157 234 31 158 88 31 159 88 32 160 89 52 161 105 33 162 90 183 163 235 182 164 234 182 165 234 52 166 105 33 167 90 53 168 106 34 169 91 183 170 235 183 171 235 33 172 90 53 173 106 35 174 92 36 175 93 34 176 91 34 177 91 53 178 106 35 179 92 37 180 94 188 181 240 36 182 93 36 183 93 35 184 92 37 185 94 39 186 96 38 187 95 188 188 240 188 189 240 37 190 94 39 191 96 40 192 97 41 193 98 38 194 95 38 195 95 39 196 96 40 197 97 55 198 107 191 199 243 41 200 98 41 201 98 40 202 97 55 203 107 42 204 99 43 205 100 191 206 243 191 207 243 55 208 107 42 209 99 20 210 77 21 211 78 43 212 100 43 213 100 42 214 99 20 215 77 0 216 0 45 217 32 20 218 20 20 219 20 44 220 31 0 221 0 3 222 3 46 223 33 45 224 32 45 225 32 0 226 0 3 227 3 47 228 34 23 229 21 46 230 33 46 231 33 3 232 3 47 233 34 4 234 4 26 235 22 23 236 21 23 237 21 47 238 34 4 239 4 49 240 36 48 241 35 26 242 22 26 243 22 4 244 4 49 245 36 7 246 7 50 247 37 48 248 35 48 249 35 49 250 36 7 251 7 8 252 8 29 253 23 50 254 37 50 255 37 7 256 7 8 257 8 51 258 38 32 259 24 29 260 23 29 261 23 8 262 8 51 263 38 10 264 10 52 265 39 32 266 24 32 267 24 51 268 38 10 269 10 12 270 12 33 271 25 52 272 39 52 273 39 10 274 10 12 275 12 13 276 13 53 277 40 33 278 25 33 279 25 12 280 12 13 281 13 14 282 14 35 283 26 53 284 40 53 285 40 13 286 13 14 287 14 54 288 41 37 289 27 35 290 26 35 291 26 14 292 14 54 293 41 16 294 16 39 295 28 37 296 27 37 297 27 54 298 41 16 299 16 17 300 17 40 301 29 39 302 28 39 303 28 16 304 16 17 305 17 18 306 18 55 307 42 40 308 29 40 309 29 17 310 17 18 311 18 19 312 19 42 313 30 55 314 42 55 315 42 18 316 18 19 317 19 44 318 31 20 319 20 42 320 30 42 321 30 19 322 19 44 323 31 73 324 125 359 325 246 358 326 245 358 327 245 56 328 108 73 329 125 57 330 109 360 331 247 359 332 246 359 333 246 73 334 125 57 335 109 75 336 127 361 337 248 360 338 247 360 339 247 57 340 109 75 341 127 58 342 110 362 343 249 361 344 248 361 345 248 75 346 127 58 347 110 76 348 128 59 349 111 362 350 249 362 351 249 58 352 110 76 353 128 60 354 112 363 355 250 59 356 111 59 357 111 76 358 128 60 359 112 62 360 114 61 361 113 363 362 250 363 363 250 60 364 112 62 365 114 78 366 130 364 367 251 61 368 113 61 369 113 62 370 114 78 371 130 63 372 115 64 373 116 364 374 251 364 375 251 78 376 130 63 377 115 80 378 132 366 379 253 64 380 116 64 381 116 63 382 115 80 383 132 65 384 117 367 385 254 366 386 253 366 387 253 80 388 132 65 389 117 81 390 133 67 391 119 367 392 254 367 393 254 65 394 117 81 395 133 66 396 118 368 397 255 67 398 119 67 399 119 81 400 133 66 401 118 68 402 120 369 403 256 368 404 255 368 405 255 66 406 118 68 407 120 84 408 136 69 409 121 369 410 256 369 411 256 68 412 120 84 413 136 86 414 138 71 415 123 69 416 121 69 417 121 84 418 136 86 419 138 70 420 122 370 421 257 71 422 123 71 423 123 86 424 138 70 425 122 56 426 108 358 427 245 370 428 257 370 429 257 70 430 122 56 431 108 72 432 124 73 433 125 56 434 108 56 435 108 110 436 162 72 437 124 74 438 126 57 439 109 73 440 125 73 441 125 72 442 124 74 443 126 90 444 142 75 445 127 57 446 109 57 447 109 74 448 126 90 449 142 92 450 144 58 451 110 75 452 127 75 453 127 90 454 142 92 455 144 94 456 146 76 457 128 58 458 110 58 459 110 92 460 144 94 461 146 95 462 147 60 463 112 76 464 128 76 465 128 94 466 146 95 467 147 96 468 148 62 469 114 60 470 112 60 471 112 95 472 147 96 473 148 77 474 129 78 475 130 62 476 114 62 477 114 96 478 148 77 479 129 99 480 151 63 481 115 78 482 130 78 483 130 77 484 129 99 485 151 79 486 131 80 487 132 63 488 115 63 489 115 99 490 151 79 491 131 101 492 153 65 493 117 80 494 132 80 495 132 79 496 131 101 497 153 102 498 154 81 499 133 65 500 117 65 501 117 101 502 153 102 503 154 82 504 134 66 505 118 81 506 133 81 507 133 102 508 154 82 509 134 105 510 157 68 511 120 66 512 118 66 513 118 82 514 134 105 515 157 83 516 135 84 517 136 68 518 120 68 519 120 105 520 157 83 521 135 85 522 137 86 523 138 84 524 136 84 525 136 83 526 135 85 527 137 108 528 160 70 529 122 86 530 138 86 531 138 85 532 137 108 533 160 110 534 162 56 535 108 70 536 122 70 537 122 108 538 160 110 539 162 88 540 140 72 541 124 110 542 162 110 543 162 87 544 139 88 545 140 113 546 165 74 547 126 72 548 124 72 549 124 88 550 140 113 551 165 89 552 141 90 553 142 74 554 126 74 555 126 113 556 165 89 557 141 91 558 143 92 559 144 90 560 142 90 561 142 89 562 141 91 563 143 93 564 145 94 565 146 92 566 144 92 567 144 91 568 143 93 569 145 115 570 167 95 571 147 94 572 146 94 573 146 93 574 145 115 575 167 116 576 168 96 577 148 95 578 147 95 579 147 115 580 167 116 581 168 97 582 149 77 583 129 96 584 148 96 585 148 116 586 168 97 587 149 98 588 150 99 589 151 77 590 129 77 591 129 97 592 149 98 593 150 117 594 169 79 595 131 99 596 151 99 597 151 98 598 150 117 599 169 100 600 152 101 601 153 79 602 131 79 603 131 117 604 169 100 605 152 119 606 171 102 607 154 101 608 153 101 609 153 100 610 152 119 611 171 103 612 155 82 613 134 102 614 154 102 615 154 119 616 171 103 617 155 104 618 156 105 619 157 82 620 134 82 621 134 103 622 155 104 623 156 106 624 158 83 625 135 105 626 157 105 627 157 104 628 156 106 629 158 107 630 159 85 631 137 83 632 135 83 633 135 106 634 158 107 635 159 109 636 161 108 637 160 85 638 137 85 639 137 107 640 159 109 641 161 87 642 139 110 643 162 108 644 160 108 645 160 109 646 161 87 647 139 122 648 174 88 649 140 87 650 139 87 651 139 111 652 163 122 653 174 112 654 164 113 655 165 88 656 140 88 657 140 122 658 174 112 659 164 126 660 178 89 661 141 113 662 165 113 663 165 112 664 164 126 665 178 128 666 180 91 667 143 89 668 141 89 669 141 126 670 178 128 671 180 130 672 182 93 673 145 91 674 143 91 675 143 128 676 180 130 677 182 114 678 166 115 679 167 93 680 145 93 681 145 130 682 182 114 683 166 131 684 183 116 685 168 115 686 167 115 687 167 114 688 166 131 689 183 132 690 184 97 691 149 116 692 168 116 693 168 131 694 183 132 695 184 135 696 187 98 697 150 97 698 149 97 699 149 132 700 184 135 701 187 136 702 188 117 703 169 98 704 150 98 705 150 135 706 187 136 707 188 118 708 170 100 709 152 117 710 169 117 711 169 136 712 188 118 713 170 139 714 191 119 715 171 100 716 152 100 717 152 118 718 170 139 719 191 140 720 192 103 721 155 119 722 171 119 723 171 139 724 191 140 725 192 141 726 193 104 727 156 103 728 155 103 729 155 140 730 192 141 731 193 143 732 195 106 733 158 104 734 156 104 735 156 141 736 193 143 737 195 120 738 172 107 739 159 106 740 158 106 741 158 143 742 195 120 743 172 121 744 173 109 745 161 107 746 159 107 747 159 120 748 172 121 749 173 111 750 163 87 751 139 109 752 161 109 753 161 121 754 173 111 755 163 147 756 199 122 757 174 111 758 163 111 759 163 146 760 198 147 761 199 123 762 175 112 763 164 122 764 174 122 765 174 147 766 199 123 767 175 124 768 176 126 769 178 112 770 164 112 771 164 123 772 175 124 773 176 125 774 177 128 775 180 126 776 178 126 777 178 124 778 176 125 779 177 127 780 179 130 781 182 128 782 180 128 783 180 125 784 177 127 785 179 129 786 181 114 787 166 130 788 182 130 789 182 127 790 179 129 791 181 151 792 203 131 793 183 114 794 166 114 795 166 129 796 181 151 797 203 153 798 205 132 799 184 131 800 183 131 801 183 151 802 203 153 803 205 133 804 185 135 805 187 132 806 184 132 807 184 153 808 205 133 809 185 134 810 186 136 811 188 135 812 187 135 813 187 133 814 185 134 815 186 137 816 189 118 817 170 136 818 188 136 819 188 134 820 186 137 821 189 138 822 190 139 823 191 118 824 170 118 825 170 137 826 189 138 827 190 158 828 210 140 829 192 139 830 191 139 831 191 138 832 190 158 833 210 142 834 194 141 835 193 140 836 192 140 837 192 158 838 210 142 839 194 144 840 196 143 841 195 141 842 193 141 843 193 142 844 194 144 845 196 145 846 197 120 847 172 143 848 195 143 849 195 144 850 196 145 851 197 162 852 214 121 853 173 120 854 172 120 855 172 145 856 197 162 857 214 146 858 198 111 859 163 121 860 173 121 861 173 162 862 214 146 863 198 164 864 216 147 865 199 146 866 198 146 867 198 163 868 215 164 869 216 165 870 217 123 871 175 147 872 199 147 873 199 164 874 216 165 875 217 148 876 200 124 877 176 123 878 175 123 879 175 165 880 217 148 881 200 149 882 201 125 883 177 124 884 176 124 885 176 148 886 200 149 887 201 150 888 202 127 889 179 125 890 177 125 891 177 149 892 201 150 893 202 168 894 220 129 895 181 127 896 179 127 897 179 150 898 202 168 899 220 170 900 222 151 901 203 129 902 181 129 903 181 168 904 220 170 905 222 152 906 204 153 907 205 151 908 203 151 909 203 170 910 222 152 911 204 154 912 206 133 913 185 153 914 205 153 915 205 152 916 204 154 917 206 155 918 207 134 919 186 133 920 185 133 921 185 154 922 206 155 923 207 156 924 208 137 925 189 134 926 186 134 927 186 155 928 207 156 929 208 157 930 209 138 931 190 137 932 189 137 933 189 156 934 208 157 935 209 171 936 223 158 937 210 138 938 190 138 939 190 157 940 209 171 941 223 159 942 211 142 943 194 158 944 210 158 945 210 171 946 223 159 947 211 160 948 212 144 949 196 142 950 194 142 951 194 159 952 211 160 953 212 161 954 213 145 955 197 144 956 196 144 957 196 160 958 212 161 959 213 175 960 227 162 961 214 145 962 197 145 963 197 161 964 213 175 965 227 163 966 215 146 967 198 162 968 214 162 969 214 175 970 227 163 971 215 177 972 229 164 973 216 163 974 215 163 975 215 174 976 226 177 977 229 178 978 230 165 979 217 164 980 216 164 981 216 177 982 229 178 983 230 166 984 218 148 985 200 165 986 217 165 987 217 178 988 230 166 989 218 179 990 231 149 991 201 148 992 200 148 993 200 166 994 218 179 995 231 180 996 232 150 997 202 149 998 201 149 999 201 179 1000 231 180 1001 232 167 1002 219 168 1003 220 150 1004 202 150 1005 202 180 1006 232 167 1007 219 181 1008 233 170 1009 222 168 1010 220 168 1011 220 167 1012 219 181 1013 233 169 1014 221 152 1015 204 170 1016 222 170 1017 222 181 1018 233 169 1019 221 184 1020 236 154 1021 206 152 1022 204 152 1023 204 169 1024 221 184 1025 236 185 1026 237 155 1027 207 154 1028 206 154 1029 206 184 1030 236 185 1031 237 186 1032 238 156 1033 208 155 1034 207 155 1035 207 185 1036 237 186 1037 238 187 1038 239 157 1039 209 156 1040 208 156 1041 208 186 1042 238 187 1043 239 189 1044 241 171 1045 223 157 1046 209 157 1047 209 187 1048 239 189 1049 241 190 1050 242 159 1051 211 171 1052 223 171 1053 223 189 1054 241 190 1055 242 172 1056 224 160 1057 212 159 1058 211 159 1059 211 190 1060 242 172 1061 224 173 1062 225 161 1063 213 160 1064 212 160 1065 212 172 1066 224 173 1067 225 192 1068 244 175 1069 227 161 1070 213 161 1071 213 173 1072 225 192 1073 244 174 1074 226 163 1075 215 175 1076 227 175 1077 227 192 1078 244 174 1079 226 22 1080 79 177 1081 229 174 1082 226 174 1083 226 21 1084 78 22 1085 79 176 1086 228 178 1087 230 177 1088 229 177 1089 229 22 1090 79 176 1091 228 24 1092 81 166 1093 218 178 1094 230 178 1095 230 176 1096 228 24 1097 81 25 1098 82 179 1099 231 166 1100 218 166 1101 218 24 1102 81 25 1103 82 27 1104 84 180 1105 232 179 1106 231 179 1107 231 25 1108 82 27 1109 84 28 1110 85 167 1111 219 180 1112 232 180 1113 232 27 1114 84 28 1115 85 30 1116 87 181 1117 233 167 1118 219 167 1119 219 28 1120 85 30 1121 87 31 1122 88 169 1123 221 181 1124 233 181 1125 233 30 1126 87 31 1127 88 182 1128 234 184 1129 236 169 1130 221 169 1131 221 31 1132 88 182 1133 234 183 1134 235 185 1135 237 184 1136 236 184 1137 236 182 1138 234 183 1139 235 34 1140 91 186 1141 238 185 1142 237 185 1143 237 183 1144 235 34 1145 91 36 1146 93 187 1147 239 186 1148 238 186 1149 238 34 1150 91 36 1151 93 188 1152 240 189 1153 241 187 1154 239 187 1155 239 36 1156 93 188 1157 240 38 1158 95 190 1159 242 189 1160 241 189 1161 241 188 1162 240 38 1163 95 41 1164 98 172 1165 224 190 1166 242 190 1167 242 38 1168 95 41 1169 98 191 1170 243 173 1171 225 172 1172 224 172 1173 224 41 1174 98 191 1175 243 43 1176 100 192 1177 244 173 1178 225 173 1179 225 191 1180 243 43 1181 100 21 1182 78 174 1183 226 192 1184 244 192 1185 244 43 1186 100 21 1187 78 217 1188 71 1 1189 1 215 1190 70 215 1191 70 193 1192 43 217 1193 71 194 1194 44 2 1195 2 1 1196 1 1 1197 1 217 1198 71 194 1199 44 196 1200 46 195 1201 45 2 1202 2 2 1203 2 194 1204 44 196 1205 46 219 1206 72 5 1207 5 195 1208 45 195 1209 45 196 1210 46 219 1211 72 222 1212 73 6 1213 6 5 1214 5 5 1215 5 219 1216 72 222 1217 73 197 1218 47 198 1219 48 6 1220 6 6 1221 6 222 1222 73 197 1223 47 223 1224 74 200 1225 50 198 1226 48 198 1227 48 197 1228 47 223 1229 74 199 1230 49 201 1231 51 200 1232 50 200 1233 50 223 1234 74 199 1235 49 202 1236 52 9 1237 9 201 1238 51 201 1239 51 199 1240 49 202 1241 52 225 1242 75 11 1243 11 9 1244 9 9 1245 9 202 1246 52 225 1247 75 227 1248 76 203 1249 53 11 1250 11 11 1251 11 225 1252 75 227 1253 76 204 1254 54 15 1255 15 203 1256 53 203 1257 53 227 1258 76 204 1259 54 205 1260 55 207 1261 57 15 1262 15 15 1263 15 204 1264 54 205 1265 55 206 1266 56 209 1267 59 207 1268 57 207 1269 57 205 1270 55 206 1271 56 208 1272 58 211 1273 61 209 1274 59 209 1275 59 206 1276 56 208 1277 58 210 1278 60 212 1279 63 211 1280 61 211 1281 61 208 1282 58 210 1283 60 214 1284 68 213 1285 65 212 1286 63 212 1287 63 210 1288 60 214 1289 68 193 1290 43 215 1291 70 213 1292 65 213 1293 65 214 1294 68 193 1295 43 216 1296 302 217 1297 303 193 1298 290 193 1299 290 230 1300 316 216 1301 302 232 1302 318 194 1303 291 217 1304 303 217 1305 303 216 1306 302 232 1307 318 218 1308 304 196 1309 292 194 1310 291 194 1311 291 232 1312 318 218 1313 304 234 1314 320 219 1315 305 196 1316 292 196 1317 292 218 1318 304 234 1319 320 220 1320 306 222 1321 308 219 1322 305 219 1323 305 234 1324 320 220 1325 306 221 1326 307 197 1327 293 222 1328 308 222 1329 308 220 1330 306 221 1331 307 237 1332 323 223 1333 309 197 1334 293 197 1335 293 221 1336 307 237 1337 323 239 1338 325 199 1339 294 223 1340 309 223 1341 309 237 1342 323 239 1343 325 240 1344 326 202 1345 295 199 1346 294 199 1347 294 239 1348 325 240 1349 326 224 1350 310 225 1351 311 202 1352 295 202 1353 295 240 1354 326 224 1355 310 226 1356 312 227 1357 313 225 1358 311 225 1359 311 224 1360 310 226 1361 312 242 1362 328 204 1363 296 227 1364 313 227 1365 313 226 1366 312 242 1367 328 243 1368 329 205 1369 297 204 1370 296 204 1371 296 242 1372 328 243 1373 329 228 1374 314 206 1375 298 205 1376 297 205 1377 297 243 1378 329 228 1379 314 245 1380 331 208 1381 299 206 1382 298 206 1383 298 228 1384 314 245 1385 331 246 1386 332 210 1387 300 208 1388 299 208 1389 299 245 1390 331 246 1391 332 229 1392 315 214 1393 301 210 1394 300 210 1395 300 246 1396 332 229 1397 315 230 1398 316 193 1399 290 214 1400 301 214 1401 301 229 1402 315 230 1403 316 231 1404 317 216 1405 302 230 1406 316 230 1407 316 248 1408 334 231 1409 317 233 1410 319 232 1411 318 216 1412 302 216 1413 302 231 1414 317 233 1415 319 251 1416 337 218 1417 304 232 1418 318 232 1419 318 233 1420 319 251 1421 337 235 1422 321 234 1423 320 218 1424 304 218 1425 304 251 1426 337 235 1427 321 254 1428 340 220 1429 306 234 1430 320 234 1431 320 235 1432 321 254 1433 340 236 1434 322 221 1435 307 220 1436 306 220 1437 306 254 1438 340 236 1439 322 238 1440 324 237 1441 323 221 1442 307 221 1443 307 236 1444 322 238 1445 324 259 1446 345 239 1447 325 237 1448 323 237 1449 323 238 1450 324 259 1451 345 241 1452 327 240 1453 326 239 1454 325 239 1455 325 259 1456 345 241 1457 327 260 1458 346 224 1459 310 240 1460 326 240 1461 326 241 1462 327 260 1463 346 262 1464 348 226 1465 312 224 1466 310 224 1467 310 260 1468 346 262 1469 348 264 1470 350 242 1471 328 226 1472 312 226 1473 312 262 1474 348 264 1475 350 265 1476 351 243 1477 329 242 1478 328 242 1479 328 264 1480 350 265 1481 351 244 1482 330 228 1483 314 243 1484 329 243 1485 329 265 1486 351 244 1487 330 266 1488 352 245 1489 331 228 1490 314 228 1491 314 244 1492 330 266 1493 352 268 1494 354 246 1495 332 245 1496 331 245 1497 331 266 1498 352 268 1499 354 247 1500 333 229 1501 315 246 1502 332 246 1503 332 268 1504 354 247 1505 333 248 1506 334 230 1507 316 229 1508 315 229 1509 315 247 1510 333 248 1511 334 272 1512 358 231 1513 317 248 1514 334 248 1515 334 249 1516 335 272 1517 358 250 1518 336 233 1519 319 231 1520 317 231 1521 317 272 1522 358 250 1523 336 252 1524 338 251 1525 337 233 1526 319 233 1527 319 250 1528 336 252 1529 338 275 1530 361 235 1531 321 251 1532 337 251 1533 337 252 1534 338 275 1535 361 253 1536 339 254 1537 340 235 1538 321 235 1539 321 275 1540 361 253 1541 339 255 1542 341 236 1543 322 254 1544 340 254 1545 340 253 1546 339 255 1547 341 256 1548 342 238 1549 324 236 1550 322 236 1551 322 255 1552 341 256 1553 342 257 1554 343 259 1555 345 238 1556 324 238 1557 324 256 1558 342 257 1559 343 258 1560 344 241 1561 327 259 1562 345 259 1563 345 257 1564 343 258 1565 344 261 1566 347 260 1567 346 241 1568 327 241 1569 327 258 1570 344 261 1571 347 263 1572 349 262 1573 348 260 1574 346 260 1575 346 261 1576 347 263 1577 349 280 1578 366 264 1579 350 262 1580 348 262 1581 348 263 1582 349 280 1583 366 283 1584 369 265 1585 351 264 1586 350 264 1587 350 280 1588 366 283 1589 369 284 1590 370 244 1591 330 265 1592 351 265 1593 351 283 1594 369 284 1595 370 285 1596 371 266 1597 352 244 1598 330 244 1599 330 284 1600 370 285 1601 371 267 1602 353 268 1603 354 266 1604 352 266 1605 352 285 1606 371 267 1607 353 287 1608 373 247 1609 333 268 1610 354 268 1611 354 267 1612 353 287 1613 373 249 1614 335 248 1615 334 247 1616 333 247 1617 333 287 1618 373 249 1619 335 270 1620 356 272 1621 358 249 1622 335 249 1623 335 269 1624 355 270 1625 356 271 1626 357 250 1627 336 272 1628 358 272 1629 358 270 1630 356 271 1631 357 273 1632 359 252 1633 338 250 1634 336 250 1635 336 271 1636 357 273 1637 359 274 1638 360 275 1639 361 252 1640 338 252 1641 338 273 1642 359 274 1643 360 291 1644 377 253 1645 339 275 1646 361 275 1647 361 274 1648 360 291 1649 377 276 1650 362 255 1651 341 253 1652 339 253 1653 339 291 1654 377 276 1655 362 277 1656 363 256 1657 342 255 1658 341 255 1659 341 276 1660 362 277 1661 363 294 1662 380 257 1663 343 256 1664 342 256 1665 342 277 1666 363 294 1667 380 278 1668 364 258 1669 344 257 1670 343 257 1671 343 294 1672 380 278 1673 364 297 1674 383 261 1675 347 258 1676 344 258 1677 344 278 1678 364 297 1679 383 299 1680 385 263 1681 349 261 1682 347 261 1683 347 297 1684 383 299 1685 385 279 1686 365 280 1687 366 263 1688 349 263 1689 349 299 1690 385 279 1691 365 281 1692 367 283 1693 369 280 1694 366 280 1695 366 279 1696 365 281 1697 367 282 1698 368 284 1699 370 283 1700 369 283 1701 369 281 1702 367 282 1703 368 301 1704 387 285 1705 371 284 1706 370 284 1707 370 282 1708 368 301 1709 387 304 1710 390 267 1711 353 285 1712 371 285 1713 371 301 1714 387 304 1715 390 286 1716 372 287 1717 373 267 1718 353 267 1719 353 304 1720 390 286 1721 372 269 1722 355 249 1723 335 287 1724 373 287 1725 373 286 1726 372 269 1727 355 307 1728 393 270 1729 356 269 1730 355 269 1731 355 305 1732 391 307 1733 393 288 1734 374 271 1735 357 270 1736 356 270 1737 356 307 1738 393 288 1739 374 289 1740 375 273 1741 359 271 1742 357 271 1743 357 288 1744 374 289 1745 375 290 1746 376 274 1747 360 273 1748 359 273 1749 359 289 1750 375 290 1751 376 309 1752 395 291 1753 377 274 1754 360 274 1755 360 290 1756 376 309 1757 395 292 1758 378 276 1759 362 291 1760 377 291 1761 377 309 1762 395 292 1763 378 311 1764 397 277 1765 363 276 1766 362 276 1767 362 292 1768 378 311 1769 397 293 1770 379 294 1771 380 277 1772 363 277 1773 363 311 1774 397 293 1775 379 295 1776 381 278 1777 364 294 1778 380 294 1779 380 293 1780 379 295 1781 381 296 1782 382 297 1783 383 278 1784 364 278 1785 364 295 1786 381 296 1787 382 313 1788 399 299 1789 385 297 1790 383 297 1791 383 296 1792 382 313 1793 399 298 1794 384 279 1795 365 299 1796 385 299 1797 385 313 1798 399 298 1799 384 314 1800 400 281 1801 367 279 1802 365 279 1803 365 298 1804 384 314 1805 400 300 1806 386 282 1807 368 281 1808 367 281 1809 367 314 1810 400 300 1811 386 302 1812 388 301 1813 387 282 1814 368 282 1815 368 300 1816 386 302 1817 388 315 1818 401 304 1819 390 301 1820 387 301 1821 387 302 1822 388 315 1823 401 303 1824 389 286 1825 372 304 1826 390 304 1827 390 315 1828 401 303 1829 389 305 1830 391 269 1831 355 286 1832 372 286 1833 372 303 1834 389 305 1835 391 306 1836 392 307 1837 393 305 1838 391 305 1839 391 317 1840 403 306 1841 392 318 1842 404 288 1843 374 307 1844 393 307 1845 393 306 1846 392 318 1847 404 319 1848 405 289 1849 375 288 1850 374 288 1851 374 318 1852 404 319 1853 405 321 1854 406 290 1855 376 289 1856 375 289 1857 375 319 1858 405 321 1859 406 308 1860 394 309 1861 395 290 1862 376 290 1863 376 321 1864 406 308 1865 394 323 1866 407 292 1867 378 309 1868 395 309 1869 395 308 1870 394 323 1871 407 310 1872 396 311 1873 397 292 1874 378 292 1875 378 323 1876 407 310 1877 396 326 1878 408 293 1879 379 311 1880 397 311 1881 397 310 1882 396 326 1883 408 312 1884 398 295 1885 381 293 1886 379 293 1887 379 326 1888 408 312 1889 398 328 1890 409 296 1891 382 295 1892 381 295 1893 381 312 1894 398 328 1895 409 329 1896 410 313 1897 399 296 1898 382 296 1899 382 328 1900 409 329 1901 410 332 1902 411 298 1903 384 313 1904 399 313 1905 399 329 1906 410 332 1907 411 333 1908 412 314 1909 400 298 1910 384 298 1911 384 332 1912 411 333 1913 412 334 1914 413 300 1915 386 314 1916 400 314 1917 400 333 1918 412 334 1919 413 335 1920 414 302 1921 388 300 1922 386 300 1923 386 334 1924 413 335 1925 414 336 1926 415 315 1927 401 302 1928 388 302 1929 388 335 1930 414 336 1931 415 316 1932 402 303 1933 389 315 1934 401 315 1935 401 336 1936 415 316 1937 402 317 1938 403 305 1939 391 303 1940 389 303 1941 389 316 1942 402 317 1943 403 339 1944 262 306 1945 392 317 1946 403 317 1947 403 337 1948 260 339 1949 262 340 1950 263 318 1951 404 306 1952 392 306 1953 392 339 1954 262 340 1955 263 320 1956 62 319 1957 405 318 1958 404 318 1959 404 340 1960 263 320 1961 62 322 1962 64 321 1963 406 319 1964 405 319 1965 405 320 1966 62 322 1967 64 345 1968 268 308 1969 394 321 1970 406 321 1971 406 322 1972 64 345 1973 268 346 1974 269 323 1975 407 308 1976 394 308 1977 394 345 1978 268 346 1979 269 324 1980 66 310 1981 396 323 1982 407 323 1983 407 346 1984 269 324 1985 66 348 1986 271 326 1987 408 310 1988 396 310 1989 396 324 1990 66 348 1991 271 325 1992 67 312 1993 398 326 1994 408 326 1995 408 348 1996 271 325 1997 67 327 1998 69 328 1999 409 312 2000 398 312 2001 398 325 2002 67 327 2003 69 330 2004 258 329 2005 410 328 2006 409 328 2007 409 327 2008 69 330 2009 258 331 2010 259 332 2011 411 329 2012 410 329 2013 410 330 2014 258 331 2015 259 351 2016 274 333 2017 412 332 2018 411 332 2019 411 331 2020 259 351 2021 274 352 2022 275 334 2023 413 333 2024 412 333 2025 412 351 2026 274 352 2027 275 353 2028 276 335 2029 414 334 2030 413 334 2031 413 352 2032 275 353 2033 276 356 2034 279 336 2035 415 335 2036 414 335 2037 414 353 2038 276 356 2039 279 357 2040 280 316 2041 402 336 2042 415 336 2043 415 356 2044 279 357 2045 280 337 2046 260 317 2047 403 316 2048 402 316 2049 402 357 2050 280 337 2051 260 338 2052 261 339 2053 262 337 2054 260 337 2055 260 371 2056 281 338 2057 261 341 2058 264 340 2059 263 339 2060 262 339 2061 262 338 2062 261 341 2063 264 342 2064 265 320 2065 62 340 2066 263 340 2067 263 341 2068 264 342 2069 265 343 2070 266 322 2071 64 320 2072 62 320 2073 62 342 2074 265 343 2075 266 373 2076 283 345 2077 268 322 2078 64 322 2079 64 343 2080 266 373 2081 283 344 2082 267 346 2083 269 345 2084 268 345 2085 268 373 2086 283 344 2087 267 374 2088 284 324 2089 66 346 2090 269 346 2091 269 344 2092 267 374 2093 284 375 2094 285 348 2095 271 324 2096 66 324 2097 66 374 2098 284 375 2099 285 347 2100 270 325 2101 67 348 2102 271 348 2103 271 375 2104 285 347 2105 270 376 2106 286 327 2107 69 325 2108 67 325 2109 67 347 2110 270 376 2111 286 377 2112 287 330 2113 258 327 2114 69 327 2115 69 376 2116 286 377 2117 287 349 2118 272 331 2119 259 330 2120 258 330 2121 258 377 2122 287 349 2123 272 350 2124 273 351 2125 274 331 2126 259 331 2127 259 349 2128 272 350 2129 273 378 2130 288 352 2131 275 351 2132 274 351 2133 274 350 2134 273 378 2135 288 354 2136 277 353 2137 276 352 2138 275 352 2139 275 378 2140 288 354 2141 277 379 2142 289 356 2143 279 353 2144 276 353 2145 276 354 2146 277 379 2147 289 355 2148 278 357 2149 280 356 2150 279 356 2151 279 379 2152 289 355 2153 278 371 2154 281 337 2155 260 357 2156 280 357 2157 280 355 2158 278 371 2159 281 358 2160 245 359 2161 246 365 2162 252 359 2163 246 360 2164 247 365 2165 252 360 2166 247 361 2167 248 365 2168 252 361 2169 248 362 2170 249 365 2171 252 362 2172 249 59 2173 111 365 2174 252 59 2175 111 363 2176 250 365 2177 252 363 2178 250 61 2179 113 365 2180 252 61 2181 113 364 2182 251 365 2183 252 364 2184 251 64 2185 116 365 2186 252 64 2187 116 366 2188 253 365 2189 252 366 2190 253 367 2191 254 365 2192 252 367 2193 254 67 2194 119 365 2195 252 67 2196 119 368 2197 255 365 2198 252 368 2199 255 369 2200 256 365 2201 252 369 2202 256 69 2203 121 365 2204 252 69 2205 121 71 2206 123 365 2207 252 71 2208 123 370 2209 257 365 2210 252 370 2211 257 358 2212 245 365 2213 252 372 2214 282 338 2215 261 371 2216 281 372 2217 282 341 2218 264 338 2219 261 372 2220 282 342 2221 265 341 2222 264 372 2223 282 343 2224 266 342 2225 265 372 2226 282 373 2227 283 343 2228 266 372 2229 282 344 2230 267 373 2231 283 372 2232 282 374 2233 284 344 2234 267 372 2235 282 375 2236 285 374 2237 284 372 2238 282 347 2239 270 375 2240 285 372 2241 282 376 2242 286 347 2243 270 372 2244 282 377 2245 287 376 2246 286 372 2247 282 349 2248 272 377 2249 287 372 2250 282 350 2251 273 349 2252 272 372 2253 282 378 2254 288 350 2255 273 372 2256 282 354 2257 277 378 2258 288 372 2259 282 379 2260 289 354 2261 277 372 2262 282 355 2263 278 379 2264 289 372 2265 282 371 2266 281 355 2267 278</p>
        </triangles>
      </mesh>
    </geometry>
  </library_geometries>
  <library_visual_scenes>
    <visual_scene id="otake.max" name="otake_max">
      <node id="___C_____layer1-node" name="___C_____layer1" type="NODE">
        <translate>0 0 0</translate>
        <rotate>-1 0 0 -90</rotate>
        <instance_geometry url="#___C_____layer1-mesh">
          <bind_material>
            <technique_common>
              <instance_material symbol="mat1" target="#mat1">
                <bind_vertex_input semantic="CHANNEL1" input_semantic="TEXCOORD" input_set="1"/>
              </instance_material>
            </technique_common>
          </bind_material>
        </instance_geometry>
      </node>
      <extra>
        <technique profile="FCOLLADA">
          <start_time>0</start_time>
          <end_time>3.33333</end_time>
        </technique>
      </extra>
      <extra>
        <technique profile="MAX3D">
          <frame_rate>30</frame_rate>
        </technique>
      </extra>
    </visual_scene>
  </library_visual_scenes>
  <scene>
    <instance_visual_scene url="#otake.max"/>
  </scene>
</COLLADA>;
            mc = new MovieClip();
            mc.base = mc.addChild(new Bitmap(new BitmapData(1000, 1000, true, 0xFF000000)));
            mc.surface = mc.addChild(new Sprite());
            var material:PhongMovieMaterial = new PhongMovieMaterial(mc);
            model = Collada.parse(collada);
            model.materialLibrary.getMaterial("mat1").material = material;
            model.addOnMouseDown(onModelMouseDown);
            scene.addChild(model);
        }
        
        private function onModelMouseDown(e:MouseEvent3D):void {
            mc.surface.graphics.beginFill(0xFFFFFF);
            mc.surface.graphics.drawCircle(e.uv.u * 1000, (1 - e.uv.v) * 1000, 50);
            mc.surface.graphics.endFill();
        }
        
        /**
         * Initialise the lights
         */
        private function initLights():void {
            light = new DirectionalLight3D();
            light.color = 0xFFFFFF;
            light.ambient = 0.25;
            light.diffuse = 0.75;
            light.specular = 0.9;
            light.direction = new Vector3D(-1, -1, -1);
            scene.addLight(light);
        }
        
        private function onEnterFrame(e:Event):void {
            //update the camera position
            if(isMouseDown) {
                camera.panAngle = 0.35 * (stage.mouseX - lastMouseX) + lastPanAngle;
                camera.tiltAngle = 0.35 * (stage.mouseY - lastMouseY) + lastTiltAngle;
            }
            camera.hover();
            view.render();
        }
        
        /**
         * stage listener for resize events
         */
        private function onResize(event:Event = null):void {
            view.x = stage.stageWidth / 2;
            view.y = stage.stageHeight / 2;
        }
        
        /**
         * カメラ移動用のマウスダウンイベント
         * @param e
         */
        public function onMouseDown(e:MouseEvent):void {
            lastPanAngle = camera.panAngle;
            lastTiltAngle = camera.tiltAngle;
            lastMouseX = stage.mouseX;
            lastMouseY = stage.mouseY;
            isMouseDown = true;
        }
        
        /**
         * カメラ移動用のマウスアップイベント
         * @param e
         */
        public function onMouseUp(e:MouseEvent):void {
            isMouseDown = false;
        }
    }
}