/**
 * Copyright oreore ( http://wonderfl.net/user/oreore )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oe2X
 */

package 
{
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	/**
	 * ...
	 * @author oreore
	 */
	public class Main extends Sprite 
	{
		private var a:Array;
		private var ballArray:Array;
		private var ballArray2:Array;
		private var s:Shape;
		private const BALL_NUM:int = 41;
		private const BALL_NUM2:int = 39;
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			var stageH:Number = stage.stageHeight;
			var stageW:Number = stage.stageWidth;
			var stageH2:Number = stage.stageHeight *.5;
			var stageW2:Number = stage.stageWidth *.5;
			
			
			s = new Shape();
			addChild(s);
			a = [];
			ballArray = [];
			ballArray2 = [];
			for (var i:int = 0; i < BALL_NUM; i++) 
			{
				a[i] = new Ball(3, 0xff0000);;
				a[i].x = Math.random() * stageW;
				a[i].y = Math.random() * stageH;
				var ball:Ball = new Ball(2, 0xff0000);
				var ball2:Ball = new Ball(2, 0x000000);
				
				addChild(a[i]);
				addChild(ball2);
				ballArray[i] = ball;
				ballArray2[i] = ball2;
			}
			
			
			lineDraw();
			
			
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
			addEventListener(Event.ENTER_FRAME, onLoop);
			
		}
		
		private function onMouseUp(e:Event):void 
		{
			
			if (e.target is Ball) {
				e.target.stopDrag();
			}
		}
		
		private function onMouseDown(e:MouseEvent):void 
		{
			trace(e.target is Ball);
			if (e.target is Ball) {
				
				trace(e.target);
				e.target.startDrag();
				e.target.x = mouseX;
				e.target.y = mouseY;
			}
			
		}
		private var vx:Number = 0;
		private var vy:Number = 0;
		private var spring:Number = 0.03;
		private var furiction:Number = 0.83;
		
		private function onLoop(e:Event):void 
		{
			var vet:Number = 0;
			vx = mouseX;
			vy = mouseY;
			
			vet = Math.sqrt(vx*vx+vy*vy);
			
			a[0].x = vx;
			a[0].y = vy;
			for (var i:int = 1; i < BALL_NUM; i++) 
			{
				var dx:Number = a[i - 1].x - a[i].x;
				var dy:Number = a[i - 1].y - a[i].y;
				var ax:Number = dx * spring;
				var ay:Number = dy * spring;
				a[i].vx += ax;
				a[i].vy += ay;
				a[i].vx *= furiction;
				a[i].vy *= furiction;
				a[i].x += a[i].vx;
				a[i].y += a[i].vy;
			}
			
			lineDraw();
			
			if (Math.abs(ax) < 0.001) {
				for (i = 1; i <BALL_NUM ; i++) 
				{
					a[i].x = Math.random()*stage.stageWidth;
					a[i].y = Math.random()*stage.stageHeight;
				}
			}
		}
		
		
		private function lineDraw():void
		{
			graphics.clear();
			s.graphics.clear();
			
			graphics.lineStyle(0, 0x000000);
			graphics.moveTo(a[0].x, a[0].y);
			ballArray[0].x = a[0].x;
			ballArray[0].y = a[0].y;
			s.graphics.lineStyle(0, 0xff0000,.3);
			s.graphics.moveTo(a[0].x, a[0].y);
			
			
			for (var i:int = 1; i < BALL_NUM2; i++) 
			{
				var xc:Number = (a[i].x +a[i + 1].x) * .5;
				var yc:Number = (a[i].y +a[i + 1].y) * .5;
				graphics.curveTo(a[i].x, a[i].y, xc, yc);
				ballArray[i].x = a[i].x;
				ballArray[i].y = a[i].y;
				ballArray2[i].x = xc;
				ballArray2[i].y = yc;
				s.graphics.lineTo(a[i].x, a[i].y);
				
			}
			s.graphics.lineTo(a[i].x, a[i].y);
			s.graphics.lineTo(a[i+1].x, a[i+1].y);
			graphics.curveTo(a[i].x, a[i].y, a[i + 1].x, a[i + 1].y);
			ballArray[i].x = a[i].x;
			ballArray[i].y = a[i].y;
		}
		
	}
	
}
	import flash.display.Sprite;
	
	class Ball extends Sprite{
		public var radius:Number;
		public var color:uint;
		public var vx:Number = 0;
		public var vy:Number = 0;
		public var oldX:Number = 0;
		public var oldY:Number = 0;
		public var ax:Number = 0;
		public var ay:Number = 0;
		public var mass:Number = 0;
		private var _alpha:Number = 1;
		
		public function Ball(radius:Number = 40, color:uint = 0xff6633,alphaNumber:Number= 1){
			this.radius = radius;
			this.color = color;
			this._alpha= alphaNumber
			init();
		}
		
		private function init():void{
			graphics.beginFill(color,_alpha);
			graphics.drawCircle(0,0,radius);
			graphics.endFill();
		}
		
		public function fillColor(value:uint):void
		{
			graphics.beginFill(value);
			graphics.drawCircle(0,0,radius);
			graphics.endFill();
		}
	}

