/**
 * Copyright wh0 ( http://wonderfl.net/user/wh0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ocqA
 */

/*
multipart project 2
part 2 of, I don't know, like 5

Background:
A gradient map filter would index an arbitrary palette
based on the value of some component of the input.

Task:
- write a shader to implement a gradient map filter
- benchmark the performance
*/

package {
    import net.hires.debug.Stats;
    import flash.display.Sprite;
    import flash.display.Shader;
    import flash.filters.ShaderFilter;
    import flash.display.BitmapData;
    import flash.utils.ByteArray;
    import flash.utils.getTimer;
    import flash.display.BitmapDataChannel;
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.events.MouseEvent;
    [SWF(frameRate=15)]
    public class GradMap extends Sprite {
        
        private var sf:ShaderFilter;
        private var src:BitmapData;
        private var srcb:Bitmap;
        private var seed:int;
        private var offsets:Array;
        
        public function GradMap() {
            sf = new ShaderFilter(new Shader(ba(80, [-1593769472,810831,1970553711,1869767680,-1560279949,1919090851,17067361,1879089410,67174415,1685287936,805372145,4096,838926400,1132462080,50397312,16793600,838926400,0,805372145,16781313])));
            sf.shader.data.map.input = prepareMap();
            src = new BitmapData(stage.stageWidth, stage.stageHeight, false);
            srcb = new Bitmap(src);
            srcb.filters = [sf];
            addChild(srcb);
            seed = getTimer();
            offsets = [new Point(), new Point(), new Point()];
            addEventListener(Event.ENTER_FRAME, scroll);
            stage.addEventListener(MouseEvent.CLICK, toggle);
            addChild(new Stats());
        }
        
        private function scroll(e:Event):void {
            offsets[0].x += 3;
            offsets[1].x += 5;
            offsets[2].x += 7;
            src.perlinNoise(200, 200, 3, seed, false, false, BitmapDataChannel.RED, false, offsets);
        }
        
        private function toggle(e:MouseEvent):void {
            if (srcb.filters.length)
                srcb.filters = [];
            else
                srcb.filters = [sf];
        }
        
        private function ba(l:int, d:Array):ByteArray {
            var r:ByteArray = new ByteArray();
            for each (var w:int in d)
                r.writeInt(w);
            r.length = l;
            return r;
        }
        
        private function prepareMap():BitmapData {
            var d:BitmapData = new BitmapData(256, 1, false);
            for (var x:int = 0; x < 256; x++) {
                var red:uint = x;
                var green:uint = Math.min(0xff, x * 2);
                var blue:uint = Math.min(0xff, x * 3);
                d.setPixel(x, y, red << 16 | green << 8 | blue);
            }
            return d;
        }
        
    }
}

/*
parameter "_OutCoord", float2, f0.rg, in
texture  "src", t0
texture  "map", t1
parameter "dst", float4, f1, out

texn f1, f0.rg, t0
set f1.g, 256
mul f1.r, f1.g
set f1.g, 0
texn f1, f1.rg, t1
*/