/**
 * Copyright _ueueueueue ( http://wonderfl.net/user/_ueueueueue )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oc6Q
 */

package 
{
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import flash.text.*;
	import flash.ui.*;
	
	[SWF(width=465,height=465,backgroundColor=0x0)]
	
	/**
	 * ...
	 * [KEY↑]　粗く
	 * [KEY↓]　細かく
 	 * @author ue
	 */
	
	public class Main extends Sprite 
	{
		private const WIDTH:int = 465;
		private const HEIGHT:int = 465;
		
		private var canvas:BitmapData;
		private var sourceBitmap:Bitmap;
		private var colors:Vector.<Array>;
		private var pixelStep:int = 3;
		private var tf:TextField;
		private var loader:Loader;
		
		public function Main():void 
		{
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			Wonderfl.capture_delay( 10 );
			
			var url:String = "http://assets.wonderfl.net/images/related_images/5/52/522c/522cb5ead3433525bbe72f0a3e16c3217e7c0d5a";
            	var urlReq:URLRequest = new URLRequest(url);
			loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComp);
            	loader.load(urlReq,new LoaderContext(true));
		}
		
		private function onComp(e:Event):void 
		{	
			sourceBitmap = loader.content as Bitmap;
			
			canvas = new BitmapData(WIDTH, HEIGHT, false, 0x000000);
			var bmp:Bitmap = addChild(new Bitmap(canvas)) as Bitmap;
			
			tf = new TextField();
			tf.background = true;
			tf.autoSize = TextFieldAutoSize.LEFT;
			tf.x = 10;
			tf.y = 10;
			var format:TextFormat = new TextFormat("Arial");
			tf.defaultTextFormat = format;
			tf.text = pixelStep.toString();
			addChild(tf);
			
			draw();
			
			stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
		}
		
		private function onKeyUp(e:KeyboardEvent):void 
		{
			if (e.keyCode == Keyboard.UP)
			{
				if (pixelStep <= 6)
				{
					pixelStep++;
					tf.text = pixelStep.toString();
					draw();
				}
			}
			else if (e.keyCode == Keyboard.DOWN)
			{
				if (pixelStep > 1)
				{
					pixelStep--;
					tf.text = pixelStep.toString();
					draw();
				}
			}
		}
		
		private function draw():void
		{
			canvas.fillRect(canvas.rect, 0x0);
			colors = new Vector.<Array>(WIDTH,true);
			for (var i:int = 0; i < WIDTH ; i+=pixelStep) 
			{
				colors[i] = new Array();
				for (var j:int = 0; j < HEIGHT; j+=pixelStep) 
				{
					var color:uint = sourceBitmap.bitmapData.getPixel(i, j);
					var brightness:Number = ((color >> 16 & 0xff) + (color >> 80 & 0xff) + (color & 0xff)) / 3;
					canvas.setPixel(i, j, brightness << 16 | brightness << 8 | brightness);
				}
			}
		}
	}
}