/**
 * Copyright moriyak ( http://wonderfl.net/user/moriyak )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/obEl
 */

package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.DropShadowFilter;
	import flash.text.TextField;
	
	/**
	 * ...
	 * @author moriyak
	 */
	public class Main extends Sprite 
	{
		protected var _mother:Sprite;
		protected var _plane:Sprite;
		protected var _taggedPlane:Sprite;
		protected var _tag:Sprite;
		
		protected var _holdOffset:int;
		protected var _isTicked:Boolean;
		protected var _pressedPosition:int;
		protected var _destination:int;
		
		protected static const DRAG_DISTANCE:int = 100;
		protected static const LOOSENESS:int = 10;
		protected static const OPEN_X:int = 180;
		protected static const CLOSED_X:int = 90;
		protected static const TICK_INTERVAL:int = 10;
		protected static const BACK_SPEED:int = 25;
		
		protected static const BLACK:uint = 0x0;
		protected static const GRAY:uint = 0xBBBBBB;
		protected static const WHITE:uint = 0xFFFFFF;
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			_createMaterials();
			this.activate();
		}
		
		public function activate():void
		{
			_tag.buttonMode = true;
			_tag.addEventListener(MouseEvent.MOUSE_DOWN, _onTagPressed);
		}
		
		protected function _onTagPressed(e:MouseEvent):void
		{
			this.addEventListener(Event.ENTER_FRAME, _whileTagHold);
			_holdOffset = _taggedPlane.x - this.stage.mouseX;
			_pressedPosition = _taggedPlane.x;
			_isTicked = false;
		}
		
		protected function _whileTagHold(e:Event):void
		{
			this.stage.addEventListener(MouseEvent.MOUSE_UP, _onTagReleased);
                        this.stage.addEventListener(Event.MOUSE_LEAVE, _onTagReleased);
			_taggedPlane.x = this.stage.mouseX + _holdOffset;
			if (_taggedPlane.x > OPEN_X + LOOSENESS) {
				_taggedPlane.x = OPEN_X + LOOSENESS;
			}
			
			if ( (!_isTicked) &&
					(_taggedPlane.x > _pressedPosition + TICK_INTERVAL) &&
					(_taggedPlane.x < OPEN_X)) {
				_isTicked = true;
			}
		}
		
		protected function _onTagReleased(e:Event):void
		{
			this.removeEventListener(Event.ENTER_FRAME, _whileTagHold);
			_destination = _getDistination();
			this.addEventListener(Event.ENTER_FRAME, _springBack);
		}
		
		protected function _getDistination():int
		{
			var result:int;
			if(_isTicked) {
				result = (_taggedPlane.x < 0) ?
					int((_taggedPlane.x + 100) / TICK_INTERVAL) * TICK_INTERVAL - 100 :
					int(_taggedPlane.x / TICK_INTERVAL) * TICK_INTERVAL;
				if (result > OPEN_X) result = OPEN_X;
			} else /*not ticked*/ {
				result = CLOSED_X;
			}
			
			return result;
		}
		protected function _springBack(e:Event/*Enter Frame*/):void
		{
			_taggedPlane.x -= BACK_SPEED;
			if (_taggedPlane.x > _destination) return;
			
			_taggedPlane.x = _destination;
			this.removeEventListener(Event.ENTER_FRAME, _springBack);
		}
		
		protected function _createMaterials():void
		{
			_mother = new Sprite();
			var g:Graphics = _mother.graphics;
			g.lineStyle(2);
			g.beginFill(GRAY);
			g.drawRoundRect(0, 0, 200, 300, 10, 10);
			g.endFill();
			
			_plane = new Sprite();
			g = _plane.graphics;
			g.lineStyle(2);
			g.beginFill(WHITE);
			g.drawRoundRect(0, 0, 150, 255, 10, 10);
			g.endFill();
			
			_tag = new Sprite();
			g = _tag.graphics;
			g.beginFill(BLACK);
			g.drawRect(0, 0, 80, 20);
			g.endFill();
			
			var labelTF:TextField = new TextField();
			labelTF.background = true;
			labelTF.backgroundColor = BLACK;
			labelTF.textColor = WHITE;
			labelTF.text = "ひっぱって";
			labelTF.height = labelTF.textHeight + 5;
			labelTF.width = labelTF.textWidth + 10;
			var labelBMD:BitmapData = new BitmapData(labelTF.width, labelTF.height);
			labelBMD.draw(labelTF);
			var labelBMP:Bitmap = new Bitmap(labelBMD);
			labelBMP.x = _tag.width - labelBMD.width;
			_tag.addChild(labelBMP);
			
			_taggedPlane = new Sprite();
			_tag.x = _plane.width - 10;
			_tag.y = 10;
			_taggedPlane.addChild(_tag);
			_taggedPlane.addChild(_plane);
			
			_taggedPlane.x = CLOSED_X
			_taggedPlane.y = 60;
			this.addChild(_taggedPlane);
			_mother.x = 50;
			_mother.y = 40;
			_mother.filters = [new DropShadowFilter(17, 90, 0, 1, 28, 20, .3)]
			this.addChild(_mother);
		}
	}
}
