/**
 * Copyright aduka ( http://wonderfl.net/user/aduka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oa8E
 */

package {
    import flash.geom.ColorTransform;
    import flash.display.Shape;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    [SWF(width=465, height = 465, backgroundColor=0xffffff)]
    public class FlashTest extends Sprite {
        public var w:int;
        public var h:int;
        public var bmd:BitmapData;
        private var ps:Array;
        private var pen:Shape = new Shape;
        private var ct:ColorTransform = new ColorTransform( 0.999, 0.95, 0.99 );
        private var vr:Number = 0.0001;
        private var vg:Number = vr;
        private var vb:Number = vr;
        private var min:Number = ct.blueMultiplier;
        private var max:Number = ct.redMultiplier;
        
        public function FlashTest() {
            // write as3 code here..
            w = stage.stageWidth;
            h = stage.stageHeight;
            
            bmd = new BitmapData( w, h, false, 0 );
            addChild( new Bitmap(bmd) );
            
            ps = new Array();
            var c:uint = 10;
            while( c-- > 0 ){
                ps.push(new Particle( w* Math.random(), h*Math.random(),
                (Math.random()-0.5)*2, (Math.random()-0.5)*2));
            }

            addEventListener( Event.ENTER_FRAME, init );
        }
        
        private function init( e:Event = null):void{
            for each( var p:Particle in ps ){
                p.x += p.vx;
                p.y += p.vy;
                if( p.x < 0 ){
                    p.x = 0; p.vx = -p.vx;
                }else if( p.x > w ){
                    p.x = w; p.vx = -p.vx;
                }
                
                if( p.y < 0 ){
                    p.y = 0; p.vy = -p.vy;
                }else if( p.y > h ){
                    p.y = h; p.vy = -p.vy;
                }
            }
            
            pen.graphics.clear();
            pen.graphics.lineStyle( 3, 0xffffff );
            pen.graphics.moveTo( ps[0].x/2 + ps[1].x/2, ps[0].y/2 + ps[1].y/2 );
            for( var i:uint = 1; i < ps.length; i++ ){
                p = ps[i+1];
                if( p == null ) p = ps[0];
                pen.graphics.curveTo( ps[i].x, ps[i].y, ps[i].x/2+p.x/2, ps[i].y/2+p.y/2 ); 
            }
            pen.graphics.curveTo( ps[0].x, ps[0].y, ps[0].x/2+ps[1].x/2, ps[0].y/2+ps[1].y/2 );
            
            ct.redMultiplier += vr;
            ct.greenMultiplier += vg;
            ct.blueMultiplier += vb;
            if( ct.redMultiplier > max ){
                ct.redMultiplier = max; vr = -vr;
            }else if( ct.redMultiplier < min ){
                ct.redMultiplier = min; vr = -vr;
            }

            if( ct.greenMultiplier > max ){
                ct.greenMultiplier = max; vg = -vg;
            }else if( ct.greenMultiplier < min ){
                ct.greenMultiplier = min; vg = -vg;
            }

            if( ct.blueMultiplier > max ){
                ct.blueMultiplier = max; vb = -vb;
            }else if( ct.blueMultiplier < min ){
                ct.greenMultiplier = min; vb = -vb;
            }
            
            bmd.colorTransform( bmd.rect, ct );
            bmd.draw( pen );
        }


        
    }
}
import flash.geom.Point;

class Particle extends Point
{
    public var vx:Number;
    public var vy:Number;
    public function Particle( x:Number, y:Number, vx:Number, vy:Number ){
        super( x, y );
        this.vx = vx;
        this.vy = vy;
    }

}
