/**
 * Copyright klh ( http://wonderfl.net/user/klh )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oa3i
 */

package {
    import flash.display.Sprite;
    
    [SWF(backgroundColor="#FFCC00", frameRate=60)]
    public class FlashTest extends Sprite {
        private var _array:VisualizedArray;
        private var _start:int;
        private var _end:int;
        private var _index:int;
        
        public function FlashTest() {
            // write as3 code here..
            _array = new VisualizedArray();
            addChild(_array);
            
            for (var i:int = 0; i < 20; i++) {
                var u:VisualizedUnit = new VisualizedUnit(Math.floor(Math.random() * 128));
                _array.addChild(u);
            }
            
            _array.x = (stage.stageWidth - _array.width) / 2;
            _array.y = (stage.stageHeight - _array.height) / 2;
            
            _end = _array.length;            
            outterLoop();
        }
        
        private function innerLoop():void {
            if (_index > _end) {
                outterLoop();
                return;
            }
            var current:int = _array.getValueByIndex(_index - 1);
            var next:int = _array.getValueByIndex(_index);
            if (current < next) {
                _array.swap(_index - 1, _index, increaseIndex);
            } else {
                increaseIndex();
            }
        }
        
        private function outterLoop():void {
            _end -= 1;
            if (_end == 0) return;
            _index = 1;
            innerLoop();
        }

        
        private function increaseIndex():void {
            _index += 1;
            innerLoop();
        }
    }
}

import flash.text.TextField;
import flash .display.DisplayObject;
import flash.display.Sprite;
import flash.display.Shape;
import flash.events.Event;

import caurina.transitions.Tweener;

internal class VisualizedUnit extends Shape {
    public static var RADIUS:int = 10;
    private var _value:int;
    
    public function VisualizedUnit(v:int) {
        if (v >= 128) v = 127;
        if (v < 0) v = 0;
        _value = v;
        
        draw();
    }

    public function draw():void {
        graphics.beginFill(0x020202 * _value);
        graphics.drawCircle(VisualizedUnit.RADIUS, VisualizedUnit.RADIUS, VisualizedUnit.RADIUS);
        graphics.endFill();
    }

    public function destory():void {
        graphics.clear();
    }
    
    public function set value(v:int):void {
        _value = v;
        draw();
    }

    public function get value():int {
        return _value;
    }

}

    
internal class VisualizedArray extends Sprite {
    private static var SWAP_TIME:Number = 0.2;
    private var _array:Array;

    public function VisualizedArray() {
        _array = [];
    }

    public function destory():void {
        for(var i:int = 0; i < _array.length; i++) {
            VisualizedUnit(_array[i]).destory();
        }
        _array = null;
    }
    
    public override function addChild(o:DisplayObject):DisplayObject {
        var ret:DisplayObject = super.addChild(o);
        if (o is VisualizedUnit) {
            o.x = _array.length * VisualizedUnit.RADIUS * 2;
            _array.push(o);
        }
        return ret;
    }
    
    public function get length():int {
        return _array.length;
    }
    
    public function getValueByIndex(index:int):int {
        return (_array[index] as VisualizedUnit).value;
    }
    
    public function swap(from:int, to:int, f:Function = null):void {
        if (from >= _array.length) from = _array.length - 1;
        if (from < 0) from = 0;
        if (to >= _array.length) to = _array.length - 1;
        if (to < 0) to = 0;
        
        var tmp:Object = _array[from];
        _array[from] = _array[to];
        _array[to] = tmp;
        
        Tweener.addTween(_array[to], {x: to * VisualizedUnit.RADIUS * 2, time: SWAP_TIME, transition: "easeInOutSine"});
        Tweener.addTween(_array[to], {y: -1 * VisualizedUnit.RADIUS, time: SWAP_TIME / 2, transition: "easeOutSine", onComplete:function():void {
            Tweener.addTween(_array[to], {y: 0, time: 0.5, transition: "easeInSine"});
        }});
        Tweener.addTween(_array[from], {x: from * VisualizedUnit.RADIUS * 2, time: SWAP_TIME, transition: "easeInOutSine", onComplete:f});
        Tweener.addTween(_array[from], {y: VisualizedUnit.RADIUS, time: SWAP_TIME / 2, transition: "easeOutSine", onComplete:function():void {
            Tweener.addTween(_array[from], {y: 0, time: SWAP_TIME / 2, transition: "easeInSine"});
        }});
    }
}