/**
 * Copyright h_sakurai ( http://wonderfl.net/user/h_sakurai )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oZnk
 */

// forked from nengafl's nengafl
package {
	import flash.events.MouseEvent;
    import flash.utils.getTimer;
	import flash.text.TextFormat;
	import flash.text.TextField;
    import flash.display.Sprite;
    import flash.events.Event;
    public class Nengafl extends Sprite {
    		    	
        public function Nengafl() {
            var nengaText:String = "リズム練習ツール<br/>"+
              "マウスをリズムに合わせて、クリックしてください。<br/>"+
              "そのリズムが表示されます。<br/>"+
              "bpmは Beats Per Minute. 音楽で演奏のテンポを示す単位<br/>"+
              "msは1/1000秒です。"; 

			var format:TextFormat = new TextFormat();
			format.size = 32;
			format.color = 0x000000;
			
			var nengaTextBox:TextField = new TextField();
			nengaTextBox.width = 465; 
   	        nengaTextBox.height = 465; 
   	        nengaTextBox.y = 0;
   	        
            nengaTextBox.multiline = true; 
            nengaTextBox.wordWrap = true; 
            nengaTextBox.border   = false;
            nengaTextBox.defaultTextFormat = format;
            nengaTextBox.htmlText = nengaText;
            
  		   this.addChild(nengaTextBox);
  		   addEventListener("enterFrame", function(event:Event):void {
  		   });
  		   var prevTime:uint =  0;
  		   var pos:int = 0;
  		   var timeArray:Array = [];
  		   
  		   addEventListener( MouseEvent.MOUSE_DOWN, function(event:MouseEvent):void {
  		   		var now:uint = getTimer();
  		   		var time:uint = now-prevTime;
	  		   	timeArray[pos] = time;
	  		   	pos = (pos + 1) % 10;
  		   		if (prevTime != 0) {
  		   			var total:int = 0;
  		   			for each(var i:uint in timeArray) {
  		   				total += i;
  		   			}
  		   			var avg:int = total / timeArray.length;
	  		   		var bpm:int = 60*1000/avg;
	  		   		var nbpm:int = 60*1000/time;
	  		   		nengaTextBox.text =  "avg bpm="+bpm+" "+avg+"ms\nnow bpm="+nbpm+" "+time+ "ms";
  		   		}
  		   		prevTime = now;
  		   });
        }
        
    }
}