/**
 * Copyright jamasian ( http://wonderfl.net/user/jamasian )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oZKY
 */

/*
      _                           _             
     | |                         (_)            
     | | __ _ _ __ ___   __ _ ___ _  __ _ _ __  
 _   | |/ _` | '_ ` _ \ / _` / __| |/ _` | '_ \ 
| |__| | (_| | | | | | | (_| \__ \ | (_| | | | |
 \____/ \__,_|_| |_| |_|\__,_|___/_|\__,_|_| |_|

Copyright 2010, Kaiyi Chan
*/

package
{
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.display.Sprite;

    import flash.geom.Point;
    import flash.geom.Rectangle;
    
    
    
[SWF(frameRate=60)]

public class pixel extends Sprite
{
    public var bmd:BitmapData;
    public var bm:Bitmap;
    public var debug:TextField;
    
    public var clusters:Array=new Array();
    public var COLOR:uint    =    0x551A8B;
    
    private const R:int    =    4;
    private const N:int    =    300;
    
    public function pixel()
    {
        //create Bitmap
        bmd    =    new BitmapData(464, 464, false, 0);
        bm     =    new Bitmap(bmd);
        
        addChild(bm);
        
        //create debug text
        debug              =    new TextField();
        debug.textColor    =    0xFFFFFF;
        debug.selectable   =    false;
        addChild(debug);
        
        constructUniverse();
        stage.addEventListener(Event.ENTER_FRAME, update);
    }
    
    private function constructUniverse():void
    {
        for (var i:int=0; i< N; i++)
        {
            clusters.push( new Cluster() );
        }
    }
    
    private function update(e:Event):void
    {
        bmd.fillRect(bmd.rect, 0);
       
        for (var i:int = 0; i < N; i++)
        {
            var RR:int    =    R + clusters[i].GRAVITY;
            
            for (var j:int = 0; j < N; j++)
            {
                if (i==j)    continue;
                
                if (Math.random()>.5)    continue;
                
                if (variance(clusters[i].X, clusters[j].X) < RR)
                {
                    if (variance(clusters[i].Y, clusters[j].Y) < RR)
                    {
                        var dir:int            =    (Math.atan2(clusters[j].Y-clusters[i].Y, clusters[j].X-clusters[i].X));
                        
                        if (dir < 1 || dir < -1)
                        {
                            clusters[i].X+=    ( (Math.random()>.52)? Math.random()*-2 : Math.random()*2 );
                            clusters[i].Y+=    ( (Math.random()>.65)? Math.random()*-2 : Math.random()*2 );
                        }
                        
                        var newx:int           =    Math.cos(dir)*RR;
                        var newy:int           =    Math.sin(dir)*RR;
                        
                        if (newx < 0) clusters[i].X-=1;
                        if (newx > 0) clusters[i].X+=1;
                        
                        if (newy < 0) clusters[i].Y-=1;
                        if (newy > 0) clusters[i].Y+=1;
                        
                        
                        if (clusters[i].X < 0 || clusters[i].X > 464) { clusters.slice(i, 1); break; }
                        if (clusters[i].Y < 0 || clusters[i].Y > 464) { clusters.slice(i, 1); break; }
                    }
                }
            }
        }
        
        this.bmd.fillRect(new Rectangle(0, 0, this.bmd.width, this.bmd.height), 0);
        
        //draw
        for (var o:int = 0; o < N; o++)
        {
            this.bmd.setPixel(clusters[o].X, clusters[o].Y, COLOR);
        }

        
        Debug('N:' + clusters.length);
    }
    
    public function variance(a:int, b:int):int
    {
        return ( ((a-b)<0)? ((a-b)*-1) : (a-b) );
    }
    
    private function Debug(text:String):void
    {
        this.debug.text    =    text;
    }
    
    private function _Random(_int:int=1):int
    {
        return Math.random()*_int - Math.random()*_int;
    }
}
}

dynamic class Cluster
{
    public var X:int         =    200 + Math.random()*60;
    public var Y:int         =    200 + Math.random()*60;
    public var GRAVITY:int   =    1;
}
