/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oYfj
 */


// bradsedito 2011
// inspired by mousepancyo's Bitmap Font Generator


package  {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.TextFieldType;
    import flash.events.Event;
    
    [SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="30")]
    
    public class Main extends Sprite{
        private var _bmd:BitmapData
        private var _bm:Bitmap
        private var _input:TextField 
        private var _tx:TextField
        private var _fmt:TextFormat
        private var _countX:uint
        private var _countY:uint
        private var _pixList:Vector.<uint>
        private var _rectList:Vector.<Rect> = new Vector.<Rect>
        private var _addRectList:Vector.<Rect> = new Vector.<Rect>
        private static const xLength:uint = 200
        private static const yLength:uint = 200
        private static const gridSize:int = 4
        
        public function Main() {
            init()
            _input.addEventListener(Event.CHANGE, textUpdate)
        }
        
        private function init():void{
            _bmd = new BitmapData(xLength, yLength, false, 0xFFFFFF)
            //
            _fmt = new TextFormat()
            _fmt.font = "_sans"
            _fmt.color = 0x000000
            _fmt.size = 24
            _fmt.leading = -3
            _fmt.kerning = -3
            //
            _input = new TextField()
            _input.defaultTextFormat = _fmt
            _input.multiline = false
            _input.border = true
            _input.type = TextFieldType.INPUT;
            _input.width = 455
            _input.height = 25
            _input.x = 5
            _input.y = 437
            addChild(_input)
            _input.text = "BRAD!"
            //
            _tx = new TextField()
            _tx.wordWrap = true
            _tx.defaultTextFormat = _fmt
            addChild(_tx)
            //
            for(var i:int=0;i<xLength*(yLength-1);i++){
                if(_countX<xLength-1){
                    var grid:Rect = new Rect(gridSize,0xFFFFFF,true)
                    grid.x = _countX * gridSize
                    grid.y = _countY * gridSize
                    addChild(grid)
                    var rect:Rect = new Rect(gridSize)
                    rect.x = _countX * gridSize
                    rect.y = _countY * gridSize
                    addChild(rect)
                    
                    _rectList.push(rect)
                    _countX++
                }else{
                    _countY++
                    _countX=0
                }
            }
            trace(_rectList.length)
            _countX = 0
            _countY = 0
        }
        
        private function textUpdate(e:Event):void{
            _tx.text = _input.text
            _bmd.fillRect(_bmd.rect, 0xFFFFFF)
            _bmd.draw(_tx)
            _pixList = new Vector.<uint>() 
            _pixList = getPix()
            update()
        }
        
        private function update():void{
            try{
                for(var i:int=0;i<_rectList.length;i++){
                    _rectList[i].visible = true
                    if(_pixList[i] == 1){
                        _rectList[i].visible = false
                    }
                }
            }catch(e:Error){
                //
            }
        }
        
        private function getPix():Vector.<uint>{
            var str:String = ""
            for(var i:int=0;i<xLength*(yLength-1);i++){
                if(_countX<xLength-1){
                    if(_bmd.getPixel(_countX+1,_countY+1) != 0xFFFFFF){
                        _pixList.push(1)
                    }else{
                        _pixList.push(0)
                    }
                    _countX++
                }else{
                    _countY++
                    _countX=0
                }
            }
            _countX = 0
            _countY = 0
            return _pixList;
        }
    }
}

//
import flash.display.Sprite;
class Rect extends Sprite{
    public function Rect(size:uint, color:int = 0, lineFlg:Boolean = false){
        if(lineFlg) graphics.lineStyle(1,0xFFFFFF)
        graphics.beginFill(color,1)
        graphics.drawRect(0, 0, size, size)
    }
}