/**
 * Copyright GARENA123 ( http://wonderfl.net/user/GARENA123 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oYFG
 */

//Alternativa3D 7:公式ページのチュートリアル3です。
//http://www.youtube.com/watch?v=T12S3UC34kE
//
//緑色のボックスをクリック後、オレンジのフィールドをクリックすることで、ボックスを移動できます。
//また、マウスドラッグとカーソルキーでカメラの操作もできます。 
package {
	import alternativ7.engine3d.containers.ConflictContainer;
	import alternativ7.engine3d.controllers.SimpleObjectController;
	import alternativ7.engine3d.core.Camera3D;
	import alternativ7.engine3d.core.MouseEvent3D;
	import alternativ7.engine3d.core.View;
	import alternativ7.engine3d.materials.FillMaterial;
	import alternativ7.engine3d.primitives.Box;
	import alternativ7.engine3d.primitives.Plane;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.GlowFilter;
	
	[SWF(width = 465, height = 465, frameRate = 60 ,backgroundColor="#404060")]
	public class Main extends Sprite {
		private var container:ConflictContainer
		private var camera:Camera3D
		private var controller:SimpleObjectController
		private var box:Box;
		private var boxIsReady:Boolean;
		
		public function Main():void {
			container = new ConflictContainer();
			camera = new Camera3D();
			camera.z = 500;
			container.addChild(camera);
			
			//SimpleObjectControllerを使って、ターゲットにしたオブジェクトの座標をカーソルキーとマウスで操作でるようにする
			controller = new SimpleObjectController(stage, camera, 200);
			controller.lookAtXYZ(200, 0, 0);
			camera.view = new View(465, 465, true);
			addChild(camera.view);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			makeFields();
			makeBox();
		}
		//ボックスを作成
		private function makeBox():void {
			var material:FillMaterial = new FillMaterial(0x609030);
			box = new Box(80, 80, 80);
			box.setMaterialToAllFaces(material);
			box.z = 50;
			container.addChild(box);
			box.addEventListener(MouseEvent3D.CLICK, boxClickHandler);
			
		}
		//ボックスをクリック
		private function boxClickHandler(e:MouseEvent3D):void {
			box.z = 100;
			boxIsReady = true;
		}
		//5ｘ5のフィールドをPlaneで作成
		private function makeFields():void {
			var material:FillMaterial = new FillMaterial(0x906030);
			var plane:Plane
			for (var i:int = 0; i < 5; i++) {
				for (var j:int = -2; j < 3; j++){
					plane = new Plane(100, 100);
					plane.setMaterialToAllFaces(material);
					plane.x = i * 110;
					plane.y = j * 110;
					container.addChild(plane);
					plane.addEventListener(MouseEvent3D.MOUSE_OVER, planeOverHandler);
					plane.addEventListener(MouseEvent3D.MOUSE_OUT, planeOutHandler);
					plane.addEventListener(MouseEvent3D.CLICK, planeClickHandler);
				}
			}
		}
		//フィールドのPlaneをクリック
		private function planeClickHandler(e:MouseEvent3D):void {
			if(boxIsReady){
				var plane:Plane = Plane(e.target);
				box.x = plane.x;
				box.y = plane.y;
				box.z = 50;
				boxIsReady = false;
			}
		}
		//フィールドのPlaneをマウスアウト
		private function planeOutHandler(e:MouseEvent3D):void {
			var plane:Plane = Plane(e.target);
			plane.filters = []
			
		}
		//フィールドのPlaneをマウスオーバー
		private function planeOverHandler(e:MouseEvent3D):void {
			var plane:Plane = Plane(e.target);
			
			plane.filters = [new GlowFilter(0xFFFFFF,0.5)]
		}
		//毎フレーム実行
		private function onEnterFrame(e:Event):void {
			controller.update();
			camera.render();
		}

	}
}