/**
 * Copyright yuuganisakase ( http://wonderfl.net/user/yuuganisakase )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oY8z
 */

//
// based on http://www.zenbullets.com
// Ghost Triangle

// fractal!
// the original is so complex that I make it a little simple;;



package
{
	
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
	
	import frocessing.math.PerlinNoise;
	
	[SWF(width=465, height=465, frameRate=12, backgroundColor=0xeeeeee)]
	public class sketch3 extends Sprite
	{
		
		//private var layer:BitmapLayer = new BitmapLayer(Util.WID, Util.HEI);
		private var holder:Sprite = new Sprite();
		private var layer:Bitmap = new Bitmap(new BitmapData(Util.WID, Util.HEI) );
		
		private var mid:Point;
		private var top:Point;
		
		private var noiseOff:Number = 0;
		private var factor:Number = 0;
		private var offset:int = 0;
		
		
		public function sketch3()
		{
			super();
			if(stage != null){
				stage.addEventListener(Event.ENTER_FRAME, onEnter);
			}
			mid = new Point(Util.WID/2, Util.HEI/2);
			top = new Point(mid.x - Util.SqrLen, mid.y - Util.SqrLen);
			
			restart();
			
			//layer.draw(holder);
			
			
			//layer.add(new FilterEffect(new BlurFilter(2,2 , 1)));
			//layer.add(new ColorEffect(new ColorTransform(1,1,1,0.98)));
			addChild(layer);
			
			
		}
		private function restart():void
		{
			noiseOff = Math.random();
			rotateStartPoint();
			createTree();
		}
		
		private function rotateStartPoint():void
		{
			offset += 1;
			if(offset > (360 / Util.NUMside)){ offset = 0; }
			//pArray = new Array();
			var radius:int = 130;
			for(var i:Number = 0; i < 360; i += 360/Util.NUMside)
			{
				var rad:Number =  (i + offset)/180 * Math.PI;
				var xx:Number =  mid.x + (radius * Math.cos(rad) );
				var yy:Number = mid.y + (radius * Math.sin(rad) );
				var sp:Sprite = new Sprite();
				sp.graphics.beginFill(0x000000,0.07);
				sp.graphics.drawCircle(xx,yy,18);
				if(stage){	
				stage.addChild(sp);
				}
				addPoint(xx, yy);
				
			}
			
		}
		
		private function addPoint(xx:Number , yy:Number):void
		{
			var po:Point = new Point(xx, yy);
			//pArray.push(po);
			Util.pArray.push(po);
		}
		private function createTree():void
		{
			noiseOff += 0.02;
			var perlin:PerlinNoise = new PerlinNoise();
			Util.bArray = new Array();
			factor = perlin.noise(noiseOff)*2 - 1;
			//bArray = new Array();
			var root:Branch = new Branch(0,1,Util.pArray,factor,holder);
			
			for(var i:int = 0; i < Util.bArray.length; i++)
			{
				(Util.bArray[i] as Branch).drawMe();
			}
			
		}
		
		private function onEnter(e:Event):void
		{
			rect();
			layer.bitmapData.draw(holder);
			holder.graphics.clear();
			
			createTree();
		}
		 private function rect():void
		         {
			             
			            var bmd:BitmapData = new BitmapData(480,480,false,0xeeeeee);
			             layer.bitmapData.draw(bmd,null,new ColorTransform(1,1,1,0.03));
		         }
	}
}
import flash.display.Sprite;
import flash.geom.Point;

class Util
{
	public static const WID:int = 465;
	public static const HEI:int = 465;
	public static const maxLevel:int = 25;
	//public static const nNum:int = 3;
	public static const NUMside:int = 4;
	public static const SqrLen:int = 50;
	
	public static var pArray:Array = new Array();
	public static var bArray:Array = new Array();
}

class Branch extends Sprite
{
	
	private var level:int;
	private var num:int;
	
	private var hpArray:Array = new Array();
	private var mpArray:Array = new Array();
	private var ppArray:Array = new Array();
	
	
	private var radius:Number;
	private var fac:Number;
	private var target:Sprite;
	
	public function Branch(lv:int, n:int, ar:Array, _fac:Number, tar:Sprite)
	{
		level = lv;
		num = n;
		hpArray = ar;
		
		
		fac = _fac;
		target = tar;
		init();	
	}
	private function init():void
	{
		for(var i:int = 0; i < hpArray.length; i++)
		{
			var next:int = i + 1;
			if(next == hpArray.length){next = 0;}
			mpArray.push( Point.interpolate(hpArray[i], hpArray[next],0.5 ) );
		}
		
		for(var j:int = 0; j < hpArray.length; j++)
		{
			var nextJ:int = j + (int)(hpArray.length /2) +1;
			if(nextJ >= hpArray.length){nextJ -= hpArray.length;}
			ppArray.push( calcProjPoint(mpArray[j], hpArray[nextJ]) );
		}
		//drawPoints(ppArray, 0x00ffff);
		//bArray.push(this);
		Util.bArray.push(this);
		if( (level+1) < Util.maxLevel)
		{
			var newBr:Branch = new Branch(level + 1, 0, ppArray, fac, target);
		}
		
	}
	private function drawPoints(ar:Array, col:uint):void
	{
		for(var i:int = 0; i < ar.length; i++)
		{
			var po:Point = (ar[i] as Point);
			target.graphics.beginFill(col,0.1);
			target.graphics.drawCircle(po.x, po.y, 10);
		}
	}
	private function calcProjPoint(p1:Point, p2:Point):Point
	{
		var xDiff:Number;
		var yDiff:Number;
		
		if(p1.x > p2.x){
			xDiff = p1.x - p2.x; 
		}else{
			xDiff = p2.x - p1.x; 
		}
		
		if(p1.y > p2.y){
			yDiff = p1.y - p2.y;
		}else{
			yDiff = p2.y - p1.y;
		}
		
		var angle:Number = Math.atan(xDiff/yDiff);
		
		var xfactor:Number = Math.sin(angle) * fac;
		var yfactor:Number = Math.cos(angle) * fac;
		//trace("xfac = " + xfactor + "yfac = " + yfactor);
		
		var pxx:Number;
		var pyy:Number;
		if(p2.x > p1.x){pxx = p1.x + (xDiff * xfactor);}
		else{pxx = p1.x - (xDiff * xfactor); }
		
		if(p2.y > p1.y){
			pyy = p1.y + (yDiff * yfactor);
		}
		else{
			pyy = p1.y - (yDiff * yfactor); 
		}
		var po:Point = new Point(pxx, pyy);
		return po;
		
	}
	public function drawMe():void
	{
		//drawPoints(mpArray, 0xff0000);
		
		
			//target.graphics.lineTo(first.x, first.y);
			//target.graphics.drawEllipse(mpArray[i].x, mpArray[i].y,40,10);
			//target.graphics.lineTo(last.x, last.y);
			drawll(ppArray);
			//drawPoints(mpArray, 0x0000ff);
		
	}
	private function drawll(ar:Array):void
	{
		target.graphics.endFill();
		target.graphics.lineStyle(1,0,0.15);
		for(var i:int = 0; i < ar.length; i++)
		{
			var next:int = i + 1;
			if(next == ar.length){	next = 0; }
			var po1:Point = (ar[i] as Point);
			var po2:Point = (ar[next] as Point);
			
			var bug:Number = 10;
			if((po1.x < bug )  && (po1.x > -bug) )
			{
				return;
			}
			
			if((po2.x < bug )  && (po2.x > -bug) )
			{
				return;
			}
				target.graphics.moveTo(po1.x, po1.y);
				target.graphics.lineTo(po2.x, po2.y);
			
			
		}
	}
	
	private function drawCollision(xx:int, yy:int, rad:Number):void
	{
		target.graphics.lineStyle(1,0x222222,0.08);
		target.graphics.beginFill(0x000000,0);
		target.graphics.drawCircle(xx,yy,rad);
	}
	
	
	
}




