/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oY2T
 */

// forked from Dorara's RGBeasing
//RBGeasing
//  画像のRGBをずらして移動させたり、回転させたかった。
//  でもやってみたらなんかイメージと違う。。。。

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;
    import net.wonderfl.utils.SequentialLoader;
    import flash.system.LoaderContext;
    
    [SWF(width="465", height="465",backgroundColor=0x00000000,frameRate=60)]
    public class RGBeffect extends Sprite
    {
        //画像のURL
        private var url:String = "http://assets.wonderfl.net/images/related_images/d/d6/d6ac/d6ac1b471af71d05cd1531d9c4f7f5a7f040afbb";
        //画像rgb用
        private var redData:BitmapData;
        private var greenData:BitmapData;
        private var blueData:BitmapData;
        //画面表示用
        private var planeData:BitmapData;
        private var plane:Bitmap;
        //ろーだー
        private var loader:Loader;
        
        //それぞれの画像の座標
        private var rx:int;
        private var ry:int;
        private var gx:int;
        private var gy:int;
        private var bx:int;
        private var by:int;
        
        //ずらして表示させる
        private var rtime:int = 50;//step
        private var gtime:int = 60;//step
        private var btime:int = 70;//step
        
        //目標地点
        private var dx:int = 200;
        private var dy:int = 200;

        private var imageArray:Array=[];
        
        public function RGBeffect()
        {
            this.stage.scaleMode = StageScaleMode.NO_SCALE;
            this.stage.align = StageAlign.TOP_LEFT;
            
            Load();
        }
        
        public function Load():void{
            //var urlReq:URLRequest = new URLRequest(url);
            //loader = new Loader();
            //loader.contentLoaderInfo.addEventListener(Event.COMPLETE, compHandle);
            //loader.load(urlReq, new LoaderContext(true));
            SequentialLoader.loadImages([url], imageArray, onLoaded);
        }
        
        public function onLoaded():void{
            loader = imageArray.pop();
            var bmp:Bitmap = Bitmap(loader.content);
            
            redData = new BitmapData(bmp.width, bmp.height);
            redData = bmp.bitmapData.clone();
            greenData = new BitmapData(bmp.width, bmp.height);
            greenData = bmp.bitmapData.clone();
            blueData = new BitmapData(bmp.width, bmp.height);
            blueData = bmp.bitmapData.clone();

            //3色に分解
            var b:BitmapData = new BitmapData(bmp.width, bmp.height);
            b.draw(bmp);
            redData.colorTransform(b.rect, new ColorTransform(1,0,0));
            greenData.colorTransform(b.rect, new ColorTransform(0,1,0));
            blueData.colorTransform(b.rect, new ColorTransform(0,0,1));
                
            rx = 0;
            ry = 0;
            gx = 0;
            gy = 0;
            bx = 0;
            by = 0;
            
            //変形、移動用マトリクス
            var rmat:Matrix = new Matrix(1,0,0,1,rx,ry);
            var gmat:Matrix = new Matrix(1,0,0,1,gx,gy);
            var bmat:Matrix = new Matrix(1,0,0,1,bx,by);
            
            //実際に描画
            planeData = new BitmapData(465, 465, true, 0x00ff0000);
            planeData.draw(redData, rmat, null, BlendMode.ADD);
            planeData.draw(greenData, gmat, null, BlendMode.ADD);
            planeData.draw(blueData, bmat, null, BlendMode.ADD);
            plane = new Bitmap(planeData);
            
            addChild(plane);
            addEventListener(Event.ENTER_FRAME, onEnter);
        }
        
        public function onEnter(e:Event):void{
            var rect:Rectangle = new Rectangle(0, 0, 465, 465);
            planeData.fillRect(rect, 0x00000000);
                    
            //時間計算(ずらして動かすため)
            if(rtime>0) rtime--;
            if(gtime>0) gtime--;
            if(btime>0) btime--;
            
            if(rtime<=0){
                var distrx:int = dx - rx;
                var distry:int = dy - ry;
                if(distrx<0) distrx = -distrx;
                if(distry<0) distry = -distry;
                if(distrx > 0 || distry > 0){
                    rx += (dx-rx)/10;
                    ry += (dy-ry)/10;
                }
            }
            if(gtime<=0){
                var distgx:int = dx - gx;
                var distgy:int = dy - gy;
                if(distgx<0) distgx = -distgx;
                if(distgy<0) distgy = -distgy;
                if(distgx > 0 || distgy > 0){
                    gx += (dx-gx)/10;
                    gy += (dy-gy)/10;
                }
            }
            if(btime<=0){
                var distbx:int = dx - bx;
                var distby:int = dy - by;
                if(distbx<0) distbx = -distbx;
                if(distby<0) distby = -distby;
                if(distrx > 0 || distry > 0){
                    bx += (dx-bx)/10;
                    by += (dy-by)/10;
                }
            }
            //全部がゴールについたら終了
            if(rx-dx==0 && ry-dy==0 && gx-dx==0 && gy-dy==0 && bx-dx==0 && by-dy==0) removeEventListener(Event.ENTER_FRAME, onEnter);
            
            //反映
            var rmat:Matrix = new Matrix(1,0,0,1,rx,ry);
            var gmat:Matrix = new Matrix(1,0,0,1,gx,gy);
            var bmat:Matrix = new Matrix(1,0,0,1,bx,by);
            planeData.draw(redData, rmat, null, BlendMode.ADD);
            planeData.draw(greenData, gmat, null, BlendMode.ADD);
            planeData.draw(blueData, bmat, null, BlendMode.ADD);
        }
        
    }
}
