/**
 * Copyright bcosizm ( http://wonderfl.net/user/bcosizm )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oXlm
 */

package {
	//外部からXMLを呼び出す実験
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.system.*;
    import flash.text.*;
    
    public class FlashTest extends Sprite {
    		private var loader:URLLoader;
    		private var textlabel:TextField;
        public function FlashTest() {
            // write as3 code here..
            textlabel = addLabel("XML_test");
            textlabel.mouseWheelEnabled=true;
            textlabel.selectable=true;
            textlabel.useRichTextClipboard=true;
            loader=new URLLoader();
            loader.addEventListener(ProgressEvent.PROGRESS,progressHandler);
            loader.addEventListener(Event.COMPLETE,completeHandler);
            loader.addEventListener(SecurityErrorEvent.SECURITY_ERROR,securityErrorHandler);
            loader.addEventListener(IOErrorEvent.IO_ERROR,ioErrorHandler);
            
            //XML読み込み
            loader.load(new URLRequest("http://gdata.youtube.com/feeds/api/videos?vq=BJJ&start-index=1&max-results=1"));
        }
        
        private function progressHandler(evt:ProgressEvent):void
        {
        		textlabel.text = "読み込み中:"+loader.bytesLoaded+"/"+loader.bytesTotal;
        		
        }
        
        private function completeHandler(evt:Event):void
        {
        		var text:String="";
        		//XMLの生成
        		var data:XML=new XML(loader.data);
        		textlabel.text=data.child(3).children().toXMLString();
        		
        }
        
        private function securityErrorHandler(evt:SecurityErrorEvent):void
        {
        		textlabel.text="セキュリティエラー";
        }
        
        private function ioErrorHandler(evt:IOErrorEvent):void
        {
	        	textlabel.text="IOエラー";		
        }
        private function addLabel(text:String):TextField
        {
        		var label:TextField=new TextField();
        		addChild(label);
        		label.text = text;
        		label.autoSize=TextFieldAutoSize.LEFT;
        		label.selectable=false;
        		return label;
        }
    }
}