/**
 * Copyright Saqoosha ( http://wonderfl.net/user/Saqoosha )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oViU
 */

package {
    import com.bit101.components.HBox;
    import com.bit101.components.Label;
    import com.bit101.components.PushButton;
    import com.bit101.components.VBox;

    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.NetStatusEvent;
    import flash.net.NetConnection;
    import flash.net.NetStream;

    
    public class radiko extends Sprite {


        private static const STATION_CODE_OSAKA:Array = ['FMO', '802', 'CCL', 'OBC', 'MBS', 'ABC'];
        private static const STATION_CODE_TOKYO:Array = ['TBS', 'QRR', 'LFR', 'INT', 'FMT', 'FMJ'];

        
        private var _conn:NetConnection;
        private var _stream:NetStream;

        
        public function radiko() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            var vbox:VBox = new VBox(this, 10, 10);
            var osaka:HBox = new HBox(vbox);
            new Label(osaka, 0, 0, 'OSAKA');
            for each (var name:String in STATION_CODE_OSAKA) {
                new PushButton(osaka, 0, 0, name, _onSelectStation).width = 50;
            }
            var tokyo:HBox = new HBox(vbox);
            new Label(tokyo, 0, 0, 'TOKYO');
            for each (name in STATION_CODE_TOKYO) {
                new PushButton(tokyo, 0, 0, name, _onSelectStation).width = 50;
            }
        }

        
        private function _onSelectStation(event:Event):void {
            if (_stream) _stream.close();
            if (_conn) _conn.close();

            _conn = new NetConnection();
            _conn.client = {onBWDone: trace};
            _conn.addEventListener(NetStatusEvent.NET_STATUS, _onNetStatus);
            _conn.connect('rtmpe://radiko.smartstream.ne.jp:1935/' + event.target.label + '/_defInst_');
        }

        
        private function _onNetStatus(event:NetStatusEvent):void {
            switch (event.info.code) {
                case 'NetConnection.Connect.Success':
                    _stream = new NetStream(_conn);
                    _stream.client = {onMetaData: trace};
                    _stream.bufferTime = 1;
                    _stream.play('simul-stream');
                    break;
            }
        }
    }
}