/**
 * Copyright Saqoosha ( http://wonderfl.net/user/Saqoosha )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oVaC
 */

// from zk_diary 2007-08-20 http://d.hatena.ne.jp/zk3/20070820
package {
	
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.media.Camera;
    import flash.media.Video;

	[SWF(width=465, height=465, frameRate=30)]
    
    public class FlashTest extends Sprite {
    	
    	private static const BUFFER_LEN:int = 16;
    	
    	private var _camera:Camera;
    	private var _video:Video;
    	private var _buffer:Array = [];
    	private var _index:int = 0;
    	
    	private var _current:Bitmap;
    	
        public function FlashTest() {
        	
        	this._camera = Camera.getCamera();
        	if (!this._camera) {
        		return;
        	}
        	this._camera.setMode(320, 240, 30);
        	this._video = new Video(320, 240);
        	this._video.attachCamera(this._camera);
        	
        	for (var i:int = 0; i < BUFFER_LEN; i++) {
        		var bm:BitmapData = new BitmapData(320, 240, false, 0);
        		this._buffer.push(bm);
        		var b:Bitmap = new Bitmap(bm);
        		b.x = (i % 4) * 100;
        		b.y = int(i / 4) * 100;
        		b.width = 100;
        		b.height = 100;
        		this.addChild(b);
        	}
        	
        	
        	this._current = this.addChild(new Bitmap()) as Bitmap;
        	this.addEventListener(Event.ENTER_FRAME, this._update);
        }
        
        private function _update(e:Event):void {
        	BitmapData(this._buffer[this._index]).draw(this._video);
        	if (++this._index == 16) {
        		this._index = 0;
        	}
        	
        	this._current.bitmapData = this._buffer[int(Math.random() * BUFFER_LEN)];
        }
    }
}