/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oUnE
 */

package {
    import flash.ui.*;
    import fl.controls.*;
    import flash.text.*;
    import flash.geom.*;
    import flash.events.*;
    import flash.display.*;
    
    [swf(width=465, height=465, frameRate=60)]
    
    public class FlashTest extends Sprite {
        private const WIDTH:int = 465;
        private const HEIGHT:int = 465;
        private const BACK:int = 0x000000;
        private const WALL:int = 0x333333;
        private const SAND:int = 0xff0000;
        private var draw:int;
        private var prevMouseX:int;
        private var prevMouseY:int;
        private var world:BitmapData;
        private var bitmap:Bitmap;
        private var count:int;
        private var mousePressed:Boolean;
        private var sandBitmap:BitmapData;
        
        public function FlashTest() {
            initialize();            
        }
        private function initialize():void {
            var sand:ContextMenuItem = new ContextMenuItem("Sand");
            sand.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, function():void {
                draw = SAND;
            });
            var wall:ContextMenuItem = new ContextMenuItem("Wall");
            wall.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, function():void {
                draw = WALL;
            });
            var erase:ContextMenuItem = new ContextMenuItem("Erase");
            erase.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, function():void {
                draw = BACK;
            });
            sandBitmap = new BitmapData(2, 2);
            sandBitmap.setPixel(0, 0, 0x00ffff);
            sandBitmap.setPixel(1, 0, 0xffffff);
            sandBitmap.setPixel(0, 1, 0x0088ff);
            sandBitmap.setPixel(1, 1, 0x00ff88);
            contextMenu = new ContextMenu();
            contextMenu.hideBuiltInItems();
            contextMenu.customItems = [sand, wall, erase];
            draw = SAND;
            count = 0;
            world = new BitmapData(WIDTH, HEIGHT, false, 0);
            world.draw(stage);
            bitmap = new Bitmap(world);
            addChild(bitmap);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, function():void {
                mousePressed = true;
            });
            stage.addEventListener(MouseEvent.MOUSE_UP, function():void {
                mousePressed = false;
            });
            addEventListener(Event.ENTER_FRAME, frame);
            stage.quality = StageQuality.LOW;            
        }
        
        private function frame(e:Event):void {
            var s:Sprite = new Sprite();
            world.lock();
            if(mousePressed) {
                if(draw == SAND) {
                    s.graphics.beginBitmapFill(sandBitmap);
                    s.graphics.drawEllipse(mouseX - 3, mouseY - 3, 6, 6);
                    s.graphics.endFill();
                    s.graphics.lineStyle(6);
                    s.graphics.lineBitmapStyle(sandBitmap);
                    s.graphics.moveTo(prevMouseX, prevMouseY);
                    s.graphics.lineTo(mouseX, mouseY);
                    world.draw(s);
                } else {
                    s.graphics.beginFill(draw);
                    s.graphics.drawEllipse(mouseX - 3, mouseY - 3, 6, 6);
                    s.graphics.endFill();
                    s.graphics.lineStyle(6, draw);
                    s.graphics.moveTo(prevMouseX, prevMouseY);
                    s.graphics.lineTo(mouseX, mouseY);
                    world.draw(s);
                }
            }
            
            prevMouseX = mouseX;
            prevMouseY = mouseY;
            var i:int;
            var j:int;
            if(count % 1 == 0)
            for(j = HEIGHT - 1; j >= 0; j--) {
                for(i = 0; i < WIDTH; i++) {
                    doPixel(i, j);
                }
            }
            else
            for(j = HEIGHT - 1; j >= 0; j--) {
                for(i = WIDTH-1; i>=0; i--) {
                    doPixel(i,j);
                }
            }
            count = (count + 1) % 4;
            world.unlock();
        }
        
        private function doPixel(x:int, y:int):void {
            var pixel:int = world.getPixel(x, y);
            switch(pixel) {
                case BACK:
                case WALL:
                break;
                default:
                if(Math.random() > 0.05) {
                    if(world.getPixel(x, y + 1) == BACK) {
                        world.setPixel(x, y + 1, pixel);
                        world.setPixel(x, y, BACK);
                    } else if(world.getPixel(x+1, y+1) == BACK) {
                        world.setPixel(x + 1, y + 1, pixel);
                        world.setPixel(x, y, BACK);
                    } else if(world.getPixel(x + 1, y) == BACK) {
                        world.setPixel(x + 1, y, pixel);
                        world.setPixel(x, y, BACK);
                    } else if(world.getPixel(x - 1, y) == BACK) {
                        world.setPixel(x - 1, y, pixel);
                        world.setPixel(x, y, BACK);
                    }
                }
                break;
            }
        }
    }
}