/**
 * Copyright simon4761 ( http://wonderfl.net/user/simon4761 )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/oUkI
 */


package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.PixelSnapping;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.events.SecurityErrorEvent;
    import flash.media.Camera;
    import flash.media.Video;
    import flash.net.URLLoader;
    import flash.net.URLLoaderDataFormat;
    import flash.net.URLRequest;
    
    import org.libspark.flartoolkit.core.FLARCode;
    import org.libspark.flartoolkit.core.param.FLARParam;
    import org.libspark.flartoolkit.core.raster.rgb.FLARRgbRaster_BitmapData;
    import org.libspark.flartoolkit.core.transmat.FLARTransMatResult;
    import org.libspark.flartoolkit.detector.FLARSingleMarkerDetector;
    import org.libspark.flartoolkit.support.pv3d.FLARBaseNode;
    import org.libspark.flartoolkit.support.pv3d.FLARCamera3D;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.render.LazyRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    
    [SWF(width=640, height=480, backgroundColor=0x808080, frameRate=30)]
    
    public class FLARToolKit_Sample_SimpleCube_PV3D extends Sprite
    {
        private var canvasWidth:int;
        private var canvasHeight:int;
        private var captureWidth:int;
        private var captureHeight:int;
        private var codeWidth:int;
        private var cameraParamFile:String;
        private var markerPatternFile:String;
        private var urlLoader:URLLoader;
        private var cameraParam:FLARParam;
        private var markerPatternCode:FLARCode;
        private var webCamera:Camera;
        private var video:Video;
        private var capture:Bitmap;
        private var raster:FLARRgbRaster_BitmapData;
        private var detector:FLARSingleMarkerDetector;
        private var scene:Scene3D;
        private var viewport:Viewport3D;
        private var camera3D:FLARCamera3D;
        private var markerNode:FLARBaseNode;
        private var renderer:LazyRenderEngine;
        private var container:DisplayObject3D;
        private var plane:Plane;
        
        
        public function FLARToolKit_Sample_SimpleCube_PV3D()
        {
            
            this.init();
        }
        
        protected function init():void
        {
            captureWidth = 320;
            captureHeight = 240;
            canvasWidth = 640
            canvasHeight = 480;
            codeWidth = 80;
            markerPatternFile = 'http://assets.wonderfl.net/static/flar/flarlogo.pat';
        
            this.cameraParam = new FLARParam();
            this.cameraParam.changeScreenSize(captureWidth, captureHeight);
            this.urlLoader = new URLLoader();
            this.urlLoader.dataFormat = URLLoaderDataFormat.TEXT;
            this.urlLoader.addEventListener(Event.COMPLETE, this.onLoadCode);
            this.urlLoader.addEventListener(IOErrorEvent.IO_ERROR, dispatchEvent);
            this.urlLoader.addEventListener(SecurityErrorEvent.SECURITY_ERROR, dispatchEvent);
            this.urlLoader.load(new URLRequest(markerPatternFile));
        }
        
        protected function onLoadCode(e:Event):void
        {
            this.urlLoader.removeEventListener(Event.COMPLETE, this.onLoadCode);
            this.markerPatternCode = new FLARCode(16, 16, 50, 50);
            this.markerPatternCode.loadARPatt(this.urlLoader.data);
            this.urlLoader = null;
            dispatchEvent(new Event(Event.INIT));
            this.onInit();
        }
        protected function onInit():void
        {
            this.webCamera = Camera.getCamera();
            if (!this.webCamera) {
                throw new Error('No webcamera!');
            }
            this.webCamera.setMode(this.captureWidth, this.captureHeight, 30);
            
            this.video = new Video( this.captureWidth, this.captureHeight);
            this.video.attachCamera(this.webCamera);
            this.capture = new Bitmap(new BitmapData(this.captureWidth, this.captureHeight, false, 0),
                                       PixelSnapping.AUTO,
                                       true);
            this.capture.width = this.canvasWidth;
            this.capture.height= this.canvasHeight;
            this.addChild(this.capture);
            
            this.raster = new FLARRgbRaster_BitmapData(this.capture.bitmapData);
            this.detector = new FLARSingleMarkerDetector(this.cameraParam,
                                                          this.markerPatternCode,
                                                          this.codeWidth);
            this.detector.setContinueMode(true);
            
            this.viewport = this.addChild(new Viewport3D(this.captureWidth,
                                                          this.captureHeight)) as Viewport3D;
            this.viewport.scaleX = this.canvasWidth / this.captureWidth;
            this.viewport.scaleY = this.canvasHeight / this.captureHeight;
            this.viewport.x = -4; 
            this.scene = new Scene3D();
            this.markerNode = this.scene.addChild(new FLARBaseNode()) as FLARBaseNode;
            this.camera3D = new FLARCamera3D(this.cameraParam);
            this.renderer = new LazyRenderEngine(this.scene, this.camera3D, this.viewport);
            this.container = new DisplayObject3D();
            this.setModelData();
            this.markerNode.addChild(this.container);
            
            this.start();
        }
        
        protected function setModelData():void
        {
            var wmat:WireframeMaterial = new WireframeMaterial(0x0000ff, 1, 2);
            this.plane = new Plane(wmat, 80, 80);
            this.plane.rotationX = 180;
            this.container.addChild(this.plane);
        }
        public function start():void
        {
            this.addEventListener(MarkerEvent.MARKER_ADDED, this.onMarkerAdded);
            this.addEventListener(MarkerEvent.MARKER_UPDATED, this.onMarkerUpdated);
            this.addEventListener(MarkerEvent.MARKER_REMOVED, this.onMarkerRemoved);
            this.addEventListener(Event.ENTER_FRAME, this.run);
        }
        protected var resultMat:FLARTransMatResult = new FLARTransMatResult();

        public function onMarkerAdded(e:Event=null):void
        {
            this.detector.getTransformMatrix(this.resultMat);
            this.markerNode.setTransformMatrix(this.resultMat);
            this.markerNode.visible = true;
        }
        
        public function onMarkerUpdated(e:Event=null):void
        {
            
        }

        public function onMarkerRemoved(e:Event=null):void
        {
            this.markerNode.visible = false;
        }
        public function run(e:Event):void
        {
            this.capture.bitmapData.draw(this.video);
            
         
            var detected:Boolean = false;
            try {
                detected = this.detector.detectMarkerLite(this.raster, 80) && this.detector.getConfidence() > 0.5;
            } catch (e:Error) {}
            
           
            if (detected) {
                this.dispatchEvent(new MarkerEvent(MarkerEvent.MARKER_ADDED));
            } else {
                this.dispatchEvent(new MarkerEvent(MarkerEvent.MARKER_REMOVED));
            }
            this.renderer.render();
        }
        
    }
}


import flash.events.Event;

class MarkerEvent extends Event
{
    public static const MARKER_ADDED:String = "markerAdded";
    public static const MARKER_UPDATED:String = "markerUpdated";
    public static const MARKER_REMOVED:String = "markerRemoved";
    
    public function MarkerEvent(type:String, bubbles:Boolean=false, cancelable:Boolean=false)
    {
        super(type, bubbles, cancelable);
    }
}
