/**
 * Copyright kuramiya ( http://wonderfl.net/user/kuramiya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oUWa
 */

// forked from hikky's flash on 2012-7-4
package {
    import flash.display.AVM1Movie;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    
    [SWF(width="465", height="465", frameRate="60", backgroundColor="0x0000ff")]
    public class FlashTest extends Sprite {
        
        private var walkers:Array;
        private var field:BitmapData;
        
        public function FlashTest() {
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            
            createField();
            createWalkers();
        }
        
        private function createField():void
        {
            field = new BitmapData(this.stage.stageWidth, this.stage.stageHeight, false, 0x000000);
        }
        
        private function createWalkers():void
        {
            this.walkers = new Array();
            
            for(var i:int = 0; i < 300; ++i)
            {
                this.walkers.push(new Walker(this.stage.stageWidth/2, this.stage.stageHeight/2, WalkerType.RED));
                this.walkers.push(new Walker(this.stage.stageWidth/2, this.stage.stageHeight/2, WalkerType.GREEN));
                this.walkers.push(new Walker(this.stage.stageWidth/2, this.stage.stageHeight/2, WalkerType.BLUE));
            }
            
        }
                
        private var once:Boolean = true;
        private var _x:int = 0;
        private var _y:int = 0;
        private function onEnterFrame(event:Event):void
        {
            this.graphics.clear();
            
            for(var i:int = 0; i < walkers.length; ++i)
            {
                walkers[i].move(this.stage.stageWidth, this.stage.stageHeight);
                walkers[i].footprint(field, 3);
            }
            
            this.graphics.beginBitmapFill(field);
            this.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            this.graphics.endFill();
        }
    }
    

}
import flash.geom.Matrix;
import flash.display.BitmapData;

final class WalkerType
{
    public static const RED:WalkerType = new WalkerType();
    public static const GREEN:WalkerType = new WalkerType();
    public static const BLUE:WalkerType = new WalkerType();
}


class Walker
{
     private var x:int;
     private var y:int;   
     private var type:WalkerType;
    
    public static const RED_MASK_SHIFT:uint = 16;
    public static const GREEN_MASK_SHIFT:uint = 8;
    public static const BLUE_MASK_SHIFT:uint = 0;
    
    public function Walker(x:int, y:int, type:WalkerType)
    {
        this.x = x;
        this.y = y;
        this.type = type;
    }
    
    public function move(maxWidth:int, maxHeight:int):void
    {
        var r:int = Math.floor(Math.random() * 4);
        switch(r)
        {
            case 0:    //    up
                this.y -= 1;
                if(this.y < 0)
                {
                    this.y = 0;
                }
                break;
            case 1:    //    down
                this.y += 1;
                if(this.y > maxHeight)
                {
                    this.y = maxHeight;
                }
                break;
            case 2:    //    left
                this.x -= 1;
                if(this.x < 0)
                {
                    this.x = 0;
                }
                break;
            case 3:    //    right
                this.x += 1;
                if(this.x > maxWidth)
                {
                    this.x = maxWidth;
                }
            default:
                //    do nothing
                break;
        }
    }
    
    public function footprint(bmd:BitmapData, colorStep:uint):void
    {
        var currentColor:uint = bmd.getPixel(this.x, this.y);
        var nextColor:uint = 0;
        
        if(type == WalkerType.RED)
        {
            nextColor = getNextFootprint(currentColor, RED_MASK_SHIFT, colorStep);    
        }
        else if(type == WalkerType.GREEN)
        {
            nextColor = getNextFootprint(currentColor, GREEN_MASK_SHIFT, colorStep);    
        }
        else if(type == WalkerType.BLUE)
        {
            nextColor = getNextFootprint(currentColor, BLUE_MASK_SHIFT, colorStep);    
        }
        else
        {
            //    do nothing
        }
        
        bmd.setPixel(this.x, this.y, nextColor);
    }
    
    private function getNextFootprint(currentColor:uint, maskShift:uint, colorStep:uint):uint
    {
        var nextColor:uint = currentColor & ( ~(0xff << maskShift) & 0xffffff);
        var current:uint = (currentColor >> maskShift) & 0x0000ff;
        var next:uint = current + colorStep;
        
        if(next <= 0xff)
        {
            nextColor = nextColor | (next << maskShift);
        }
        else
        {
            nextColor = currentColor;
        }
        
        return nextColor;
    }

}
