/**
 * Copyright dotemoto106 ( http://wonderfl.net/user/dotemoto106 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oTfl
 */

// forked from dotemoto106's dotemoto4
// forked from dotemoto106's forked from: dotemoto3
// forked from dotemoto106's dotemoto3
// forked from dotemoto106's dotemoto2
// forked from dotemoto106's dotemoto
package {
    
    import frocessing.display.F5MovieClip2DBmp;
    import flash.display.Sprite; 
    import flash.events.TimerEvent; 
    import flash.utils.Timer; 
    /**
     * 螺旋に沿って移動する円
     * @author shmdmoto
     */
    public class DynamicsSample1 extends F5MovieClip2DBmp
    public class ShortTimer extends Sprite
    {
        public var ipt1:Interpolate;
        public var ipt2:Interpolate;
        public var ipt3:Interpolate;
        public var ipt4:Interpolate;
        public var ipt5:Interpolate;
        public var ipt6:Interpolate;
        public var ipt7:Interpolate;
        public function setup() : void
        public function ShortTimer()
        // creates a new five-second Timer 
        var minuteTimer:Timer = new Timer(1000, 5); 
     
        {
            Wonderfl.disable_capture();
            colorMode(RGB,255,255,255,255); 
            ipt1 = new Interpolate( 3, 0, radians(360 * 3));
            ipt2 = new Interpolate( 4, 0, radians(360 * 4));
            ipt3 = new Interpolate( 5, 0, radians(360 * 4));
            ipt4 = new Interpolate( 6, 0, radians(360 * 4));
            ipt5 = new Interpolate( 3, 0, radians(360 * 4));
            ipt6 = new Interpolate( 4, 0, radians(360 * 4));
            ipt7 = new Interpolate( 5, 0, radians(360 * 4));
           
             // designates listeners for the interval and completion events 
            minuteTimer.addEventListener(TimerEvent.TIMER, onTick); 
            minuteTimer.addEventListener(TimerEvent.TIMER_COMPLETE, onTimerComplete); 
             
            // starts the timer ticking 
            minuteTimer.start(); 
           
           
        }
        /*public function draw() : void
        {**/
        
        public function onTick(event:TimerEvent):void  
        { 
            // displays the tick count so far 
            // The target of this event is the Timer instance itself. 

            fill(255,10);           
            rect(0,0,stage.stageWidth, stage.stageHeight); 
         
            noStroke(); 
            fill( 0, 255, 255);
            ellipse(
                stage.stageWidth / 4  + 3*ipt1.val()*cos(ipt1.val()), 
                stage.stageHeight / 4 + 3*ipt1.val()*sin(ipt1.val()),
             2, 2);
           
           noStroke(); 
            fill( 0, 0, 255);
           ellipse(
                stage.stageWidth / 5  + 2.5*ipt2.val()*cos(ipt2.val()), 
                stage.stageHeight*2 / 5 + 2.5*ipt2.val()*sin(ipt2.val()),
             2, 2);
          
          noStroke(); 
            fill( 0, 255, 255);        
          ellipse(
                stage.stageWidth / 3  + 2*ipt3.val()*cos(ipt3.val()), 
                stage.stageHeight / 2 + 2*ipt3.val()*sin(ipt3.val()),
             2, 2);
           
           noStroke(); 
            fill( 0, 0, 255);  
          ellipse(
                stage.stageWidth /5   + 1*ipt4.val()*cos(ipt4.val()), 
                stage.stageHeight*3 /5  + 1*ipt4.val()*sin(ipt4.val()),
             2, 2);  
             
             
         noStroke(); 
            fill( 0, 255, 255);    
         ellipse(
                stage.stageWidth*2 / 3  + 3*ipt5.val()*cos(ipt5.val()), 
                stage.stageHeight*3 / 5 + 3*ipt5.val()*sin(ipt5.val()),
             2, 2);
             
         noStroke(); 
            fill( 0, 0, 255);    
         ellipse(
                stage.stageWidth*3 / 4  + 2*ipt6.val()*cos(ipt6.val()), 
                stage.stageHeight*3 / 4 + 2*ipt6.val()*sin(ipt6.val()),
             2, 2);
             
         noStroke(); 
            fill( 0, 255, 255);    
         ellipse(
                stage.stageWidth*11 / 18  + 1*ipt7.val()*cos(ipt7.val()), 
                stage.stageHeight*6 / 7 + 1*ipt7.val()*sin(ipt7.val()),
             2, 2);    
        }
    }
}




// 以下は，動きを記述するためのクラスですので，編集しないでください．
import flash.utils.getTimer;
import frocessing.math.PerlinNoise;
/**
 * Interpolate:指定した時間で，開始値から終値までの過渡的を
 *             記述するクラス
 */
class Interpolate
{
    private static const NOINIT  :int = 1;
    private static const RUNNING :int = 2;
    private static const WAITING :int = 3;
    private static const STOPPED :int = 3;
    private var duration  :Number;
    private var begin     :Number;
    private var end       :Number;
    private var pow       :Number;
    private var tOffset   :Number;
    private var tElapsed  :Number;
    private var prevVal   :Number;
    private var tRestart  :Number;
    public  var status    :int = NOINIT;
    public function Interpolate( t:Number, s:Number, f:Number,
                                 p:Number = 1) {
        begin = prevVal = s;
        end = f;
        duration = t;
        pow = p;
    }
    public function val() :Number {
        var t :Number;
        if( status == NOINIT){
            tOffset = getTimer()/1000;
            prevVal = begin;
            status = RUNNING;
        } else if( status == RUNNING ) {
            t = getTimer()/1000;
            tElapsed = t -tOffset;
            if( tElapsed < duration ) {
                prevVal = begin + ( end - begin )*Math.pow(tElapsed/duration,pow);
            } else {
                prevVal = end;
                status = STOPPED;
            }
        } else if( status == WAITING){
            t = getTimer()/1000;
            if( t >= tRestart) {
                status = RUNNING;
                tOffset = t - tElapsed;        
            }
        }
        return prevVal;
    }
    public function pause() :void
    {
        status = STOPPED;        
    }
    public function cont() :void
    {
        status = RUNNING;
        tOffset = getTimer()/1000-tElapsed;        
    }
    public function start() :void
    {
        status = RUNNING;
        tOffset = getTimer()/1000;                
    }
    public function wait( waitTime :Number ) :void
    {
        status = WAITING;
        tRestart = getTimer() + waitTime;
    }
    
    public function isRunning() :Boolean
    {
        if( status == RUNNING ) {
            return true;
        } else {
            return false;
        }
    }
    public function isStopped() :Boolean
    {
        if( status == STOPPED ) {
            return true;
        } else {
            return false;
        }
    }
    public function isEnd() :Boolean
    {
        if( prevVal >= end) {
            return true;
        } else {
            return false;
        }
    }
}
/**
 * LFO:指定した時間での周期的変動を記述するクラス
 */
class LFO {
    public static const SIN    :int = 1;
    public static const COS    :int = 2;
    public static const SAW    :int = 3;
    public static const TRI    :int = 4;
    public static const SQR    :int = 5;
    public static const ABSSIN :int = 6;
    public static const NOISE  :int = 7;
    private static const NOINIT  :int = 1;
    private static const RUNNING :int = 2;
    private static const WAITING :int = 3;
    private static const STOPPED :int = 4;
    private var period    :Number;
    private var amplitude :Number;
    private var phase     :Number;
    private var offset    :Number;
    private var type      :int = SIN;
    private var isStart   :Boolean;
    private var t_offset  :Number;
    private var status    :int = NOINIT;
    
    public function LFO( prd :Number, amp :Number,
                         of :Number = 0, ph :Number = 0)
    {
        period    = prd;
        amplitude = amp;
        offset    = of;
        phase     = ph;
    }
    public function setPeak( min :Number, max :Number) :void
    {
        offset = (min + max) / 2;
        if( min < max ) {
            amplitude    = (max - min) / 2;
        } else {
            amplitude    = (min - max) / 2;
        }        
    }
    public function setType( t :int ) :void
    {
        type = t;
    }
    public function val( mul :Number=1.0 ) :Number {
        if(status == NOINIT) {
            status = RUNNING;
            t_offset = getTimer() / 1000.0;
            return val();
        } else if(status == RUNNING　) {
            var t :Number = getTimer() / 1000.0 - t_offset;
            var temp :Number;
            switch(type) {
                case SIN :
                    return  offset + mul * amplitude * 
                            Math.sin(2.0 * Math.PI *( t/period + phase) );
                case COS :
                    return  offset + mul * amplitude *
                            Math.cos(2.0 * Math.PI *( t/period + phase) );
                case SAW :
                    temp = t / period + 0.5 + phase - 
                            Math.floor( t / period + 0.5 + phase ) - 0.5;
                    return  offset + 2.0 * mul * amplitude * temp;
                case TRI :
                    temp = t / period + phase - 
                            Math.floor (t / period + phase );
                    if( 0.0 <= temp && temp < 0.25 ) {
                        return offset + mul * amplitude * 4.0 * temp;
                    } else if( temp < 0.75 ) {
                        return offset + mul * amplitude * (  2.0 - 4.0 * temp);
                    } else {
                        return offset + mul * amplitude * ( -4.0 + 4.0 * temp);
                    }
                case SQR :
                    temp = t/period + phase - 
                            Math.floor( t / period + phase);
                    if( temp < 0.5 ){
                        return offset + mul * amplitude;
                    } else {
                        return offset - mul * amplitude;
                    }
                case ABSSIN :
                    return  offset + 
                        Math.abs(mul * amplitude * Math.sin(2.0*Math.PI *( t/period + phase)));
                case NOISE :
                    var p :PerlinNoise = new PerlinNoise(); 
                    return offset -mul * amplitude + 2.0 * mul * amplitude * p.noise(t/period+phase,1);
                default :
                    return 0.0;
            }
        } else {
            return 0.0;
        }        
    }
}    