/**
 * Copyright chomo ( http://wonderfl.net/user/chomo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oTdH
 */

// forked from sake's Spriteを球状に配置するだけ
/*
   Spriteを球状に配置しただけです。
   Z-sortはclockmakerさんのものを利用させてもらってます（http://wonderfl.kayac.com/code/32ddf17fbf8581122c192435d1cccc870d10b375）。
*/

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.Matrix3D;

	[SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="40")]

	public class SpriteSphere extends Sprite
	{
		private var container:Sprite;
		private var planeN:Number;
		private const planeW:Number=50;
		private const planeH:Number=50;
		private const radius:Number=150;


		public function SpriteSphere()
		{
			container=new Sprite();
			container.x=465 / 2;
			container.y=465 / 2;
			addChild(container);

			planeN=0;
			var H:int=(2 * radius * Math.PI) / 2 / planeH;
			var theta1:Number;
			var theta2:Number=90;

			for(var i:int=0; i < H; i++)
			{
				theta1=0;
				var pn:int=Math.floor((2 * radius * Math.cos(theta2 * Math.PI / 180) * Math.PI) / planeW);
				for(var j:int=0; j < pn; j++)
				{
					var sp:Sprite=new Sprite;
					sp.graphics.beginFill(Math.random() * 0xffffff, 0.7);
					sp.graphics.drawEllipse(-planeW / 2, -planeH / 2, planeW, planeH);
					sp.graphics.endFill();
					sp.rotationX=-theta2;
					sp.rotationY=theta1;
					sp.x=radius * Math.cos(theta2 * Math.PI / 180) * Math.sin(theta1 * Math.PI / 180);
					sp.y=radius * Math.sin(theta2 * Math.PI / 180);
					sp.z=radius * Math.cos(theta2 * Math.PI / 180) * Math.cos(theta1 * Math.PI / 180);
					theta1+=360 / pn;
					sp.name="sp" + planeN.toString();
					container.addChild(sp);
					planeN++;
				}
				theta2-=180 / H;
			}

			addEventListener(Event.ENTER_FRAME, onFrame);
		}

		private function onFrame(e:Event):void
		{
			container.rotationY++;

			var array:Array=[];

			for(var i:int=0; i < planeN; i++)
			{
				var sp:Sprite=container.getChildByName("sp" + i.toString())as Sprite;
				var mat:Matrix3D=sp.transform.getRelativeMatrix3D(this);
				array.push({sp:sp, z:mat.position.z});
			}

			array.sortOn("z", Array.NUMERIC | Array.DESCENDING);

			for(var i:int=0; i < planeN; i++)
			{
				var sp:Sprite=array[i].sp as Sprite;
				container.setChildIndex(sp, i);

				var b:Number=(array[i].z as Number) / 14;
				sp.filters=(b > 4) ? [new BlurFilter(b, b, 3)] : [];
			}
		}
	}
}


