/**
 * Copyright joanllenas ( http://wonderfl.net/user/joanllenas )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oTTi
 */

package {
    import flash.text.TextField;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            var myURL:String = "http://www.mydomain.com/myFile.xml";
            print( CacheUtils.avoidCache(myURL, CacheUtils.EVERY_MILLISECOND), 100 );
            myURL = "http://www.myDomain.com/myFolder/myFile.xml?myVar=anything&another=whatever";
            print( CacheUtils.avoidCache(myURL, CacheUtils.DAILY), 200 );
        }
        
        public function print(str:String, posY:Number):void
        {
            var tf:TextField = new TextField();
            tf.width = stage.stageWidth;
            tf.height = 100;
            tf.wordWrap = true;
            tf.text = str;
            tf.y = posY;
            addChild( tf );
        }

    }
}

class CacheUtils
{
    public static const EVERY_MILLISECOND:Function = function():String
    {
        return new Date().getTime().toString();
    };

    public static const DAILY:Function = function():String
    {
        var d:Date = new Date();
        return d.fullYear.toString() + d.month.toString() + d.date.toString();
    };

    public static var defaultCacheControlStrategy:Function = EVERY_MILLISECOND;


    public static function avoidCache(url:String, cacheControlStrategy:Function = null):String
    {
        cacheControlStrategy ||= defaultCacheControlStrategy;

        var separator:String = url.indexOf("?") > -1 ? "&" : "?";
        return url + separator + "cacheControl=" + String(cacheControlStrategy());
    }
}