/**
 * Copyright shapevent ( http://wonderfl.net/user/shapevent )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oTQW
 */

package {

	import flash.display.*;
	import flash.geom.*;
	import flash.events.*;

       public class BitmapAnimationTest extends MovieClip {
		private var circle:Shape;
		
		private var currFrame:Frame;
		
		private var canvas:BitmapData;
		private var loc:Point;


               public function BitmapAnimationTest(){
                  // init
			circle = new Shape();
			with(circle.graphics) beginFill(0x000000), drawCircle(20,20,20);
			
			// populate the linked list
			generateAnimation();
			
			canvas = new BitmapData(200,200,false, 0x000000);
			addChild(new Bitmap(canvas, "auto", true));
			loc = new Point(20, 20);
			
			addEventListener(Event.ENTER_FRAME, onLoop);
               }
               // private methods

		private function onLoop(evt:Event):void {
			// clear the canvas
			canvas.fillRect(canvas.rect, 0x000000);
			// draw the current frame
			canvas.copyPixels(currFrame.bitmap, currFrame.bitmap.rect, loc, null, null, true);
			// get the next frame of the animation
			currFrame = currFrame.next;
		}
		private function generateAnimation():void{
			var channel:uint = 0;
			var ct:ColorTransform = new ColorTransform();
			var increase:Boolean = true;
			var firstFrame:Frame;
		        var pFrame:Frame;
			for (var i:int = 0; i<40; i++){
				if (increase){
				   channel += 10;
				   if (channel == 200){
					  increase = false;   
				   }
				}else{
				   channel -= 10;
				}
				ct.color = channel << 16 | channel << 8 | channel;
				circle.transform.colorTransform = ct;
				// populate linked list
				currFrame = capture(circle); 
				if (pFrame){
				   pFrame.next = currFrame;
				}
				if (i == 0){
				   firstFrame = currFrame;
				}
				pFrame = currFrame;
			}
			// close the list
                       currFrame.next = firstFrame;
			currFrame = firstFrame;
		}
		private function capture(target:Shape):Frame{
			var frame:Frame = new Frame();
			frame.bitmap = new BitmapData(target.width, target.height, true, 0x00000000);
			frame.bitmap.draw(target, null, target.transform.colorTransform);
			return frame;
		}
       }
   }
       
      import flash.display.BitmapData;
      final class Frame{
          public var bitmap:BitmapData;
          public var next:Frame
      }

