/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oTOK
 */

package {
    import flash.text.TextField;
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {

            deb = new TextField();
             deb.width=320; deb.height=240;
             deb.mouseEnabled = false;
             deb.x=320; deb.y=16;
            addChild(deb);
                        
            
            mw = 16;
            mh = 4+4+4;
            vecGrid = Vector.<int>([
            1,1,2,3,4,5,6,7, 1,1,2,3,4,5,6,7,
            1,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,1,
            1,0,1,1,1,0,1,1, 1,1,0,1,1,1,0,1,
            1,0,1,0,0,0,0,0, 0,1,0,0,0,1,0,1,

            1,0,1,0,1,1,1,1, 0,1,0,1,0,1,0,1,
            1,0,1,0,0,0,0,0, 0,1,0,1,0,0,0,1,
            1,0,0,0,1,1,1,1, 0,0,0,1,0,1,0,1,
            1,0,1,0,0,0,0,1, 1,1,1,1,0,1,0,1,

            1,0,1,0,1,1,0,1, 0,0,0,0,0,1,0,1,
            1,0,1,0,0,1,0,1, 0,1,1,1,1,1,0,1,
            1,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,1,
            1,1,2,3,4,5,6,7, 1,1,2,3,4,5,6,7,
            ]);
            
            nump = 0;
            var num:int; var i:int;
            num = mw * mh;
            for (i=0;i<num;i+=1) { if (vecGrid[i]==0) { nump+=1; } }
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKdown);
            stage.addEventListener(KeyboardEvent.KEY_UP, onKup);
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
        
        public function onKdown(e:KeyboardEvent):void { vecKey[e.keyCode] = true; }
        public function onKup(e:KeyboardEvent):void { vecKey[e.keyCode] = false; }
        public function isKeyDown(k:int):Boolean { return vecKey[k]; }
        
        public var vecKey:Vector.<Boolean> = new Vector.<Boolean>(512, false);

        public var deb:TextField; 

        public var cw:Number = 16;
        public var ch:Number = 16;
        public var mw:int = 0;
        public var mh:int = 0;
        public var vecGrid:Vector.<int>;
        
        public var nump:int = 0;
        
        public var cx:Number = 16+8;
        public var cy:Number = 16+8;
        public var vx:Number = 0;
        public var vy:Number = 0;
               
               
        public function isWall(ax:Number, ay:Number):Boolean
        { 
          var tx:int; var ty:int;     tx = ax/cw; ty = ay/ch;
          if (tx < 0 || ty < 0 || tx >= mw || ty >= mh) { return false; }
          return vecGrid[tx+(ty*mw)] > 0;
        }//iswall
        
        public function getTile(ax:Number, ay:Number):int
        { 
          var tx:int; var ty:int;    tx = ax/cw; ty = ay/ch;
          if (tx < 0 || ty < 0 || tx >= mw || ty >= mh) { return -1; }
          return vecGrid[tx+(ty*mw)];
        }//iswall
        
        public function setTile(ax:Number, ay:Number, t:int):void
        { 
          var tx:int; var ty:int;    tx = ax/cw; ty = ay/ch;
          if (tx < 0 || ty < 0 || tx >= mw || ty >= mh) { return; }
          vecGrid[tx+(ty*mw)] = t;
        }//iswall
        

        public function onEnter(e:Event):void        
        {
            graphics.clear();
            graphics.lineStyle(2, 0);

           var wallDet:int = 0;
           if (isWall(cx+8+4,cy)) { wallDet |= 1; }
           if (isWall(cx-8-4,cy)) { wallDet |= 2; }
           if (isWall(cx,cy+8+4)) { wallDet |= 4; }
           if (isWall(cx,cy-8-4)) { wallDet |= 8; }
           
           if (isKeyDown(Keyboard.UP) && (wallDet&8)==0) { vy = -2; vx=0; }
           if (isKeyDown(Keyboard.DOWN) && (wallDet&4)==0) { vy = 2; vx=0; }
           if (isKeyDown(Keyboard.LEFT) && (wallDet&2)==0 ) { vy = 0; vx=-2; }
           if (isKeyDown(Keyboard.RIGHT) && (wallDet&1)==0 ) { vy = 0; vx=2; }
            
           var ax:Number; var ay:Number;
           ax = Math.floor(cx/cw)*cw;
           ay = Math.floor(cy/ch)*ch;

           
          // graphics.drawRect(ax,ay,cw,ch);
           
            if (vx != 0) { cy += ((ay+8)-cy)*0.5;  }           
            if (vy != 0) { cx += ((ax+8)-cx)*0.5;  }           
            
            /*
            for (i=0;i<4;i+=1)
            {
             if (isWall(cx+8+1,cy)) {cx-=1;}
             if (isWall(cx-8-1,cy)) {cx+=1;}
             if (isWall(cx,cy+8+1)) {cy-=1;}
             if (isWall(cx,cy-8-1)) {cy+=1;}
            }//nexti
            */
            
            if (vx>0&&isWall(cx+8,cy)) { vx=0;  }
            else if (vx<0&&isWall(cx-8,cy)) { vx=0;  }
            if (vy>0&&isWall(cx,cy+8)) { vy=0;  }
            else if (vy<0&&isWall(cx,cy-8)) { vy=0;  }
            
            cx+=vx;  cy+=vy;
            
            if (getTile(cx,cy)==0) { setTile(cx,cy, -1); nump -= 1;  } 
            deb.text = ""+nump;
            
            var t:int;
            var i:int; var k:int; var yt:int;
            for(i=0;i<mh;i+=1)
            {
             yt = i * mw;
             for (k=0;k<mw;k+=1)
             {
                t = vecGrid[yt+k];
                if (t < 0) { continue; }
                if (t == 0)
                {
                  graphics.drawRect(k*cw+6,i*ch+6,4,4);                    
                  continue;
                }
                
                graphics.beginFill(0, 1);
                 graphics.drawRect(k*cw,i*ch,cw,ch);
                graphics.endFill();
             }//nextk
            }//nexti
            
            graphics.drawCircle(cx,cy, 8);
            
            
        }//onenter
        
    }//classend
}