/**
 * Copyright kalevionni ( http://wonderfl.net/user/kalevionni )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oTNm
 */

// forked from kalevionni's Arrow, pointing to the cursor
package {
    import flash.display.*;
    import flash.events.*;
    
    public class FlashTest extends MovieClip {
        private var mousex:int;
        private var mousey:int;
        
        private var arr:Arrow;
        
        public function FlashTest() {
            
            WTrace.initTrace(stage);
            

            arr = new Arrow(3.5,0);
            arr.setPos(stage.stageWidth/2,stage.stageHeight/2);
            addChild(arr);
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE,onMouseMove);
            stage.addEventListener(KeyboardEvent.KEY_DOWN,onKeyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP,onKeyUp);
            stage.addEventListener(Event.ENTER_FRAME,onEnterFrame);
            
            


        }
        private var key_forward:Boolean;
        private var key_backward:Boolean;
        private var key_left:Boolean;
        private var key_right:Boolean;
        
        private function onKeyDown(evt:KeyboardEvent):void
        {
            switch(evt.keyCode)
            {
                case 87:  key_forward=true; break;
                case 83:  key_backward=true; break;
                case 68:  key_left=true; break;
                case 65:  key_right=true; break;
                defaut: break;
            }
            
            
            return;
        }

        private function onKeyUp(evt:KeyboardEvent):void
        {
            switch(evt.keyCode)
            {
                case 87:  key_forward=false; break;
                case 83:  key_backward=false; break;
                case 68:  key_left=false; break;
                case 65:  key_right=false; break;
                defaut: break;
            }
            
            
            return;
        }
                
        private function onMouseMove(evt:MouseEvent):void
        {
            mousex = evt.stageX;
            mousey = evt.stageY;
        }
        
        
        private var power:Number = 1;
        private var xspeed: Number = 0;
        private var yspeed: Number = 0;
        private var friction:Number = 0.90;
        
        private function onEnterFrame(evt:Event):void
        {
            var rx:Number = 0;
            var ry:Number = 0;
            
            var keys:Number = 0;
            
            power=2;
            
            if (key_forward) keys++;
            if (key_backward) keys++;
            if (key_left) keys++;
            if (key_right) keys++;
            
            if (keys >= 2) power/=Math.sqrt(2);

            if (key_forward) {yspeed-=power;}
            if (key_backward) {yspeed+=power;}
            if (key_left) { xspeed+=power;}
            if (key_right) { xspeed-=power;}            
            
            if (key_left) {arr.setRotation(arr.rotation+15)}
            
            xspeed *= friction;
            yspeed *= friction;
            
            //trace("Speed: " + (Math.sqrt(Math.pow(xspeed,2) + Math.pow(yspeed,2))));
            
            
            
            
   
            //arr.walk(Math.atan2(yspeed, xspeed)*180/Math.PI, Math.sqrt((yspeed*yspeed)+(xspeed*xspeed)) );
            arr.setPosDelta(xspeed,yspeed);
            arr.pointTo(mousex,mousey);
        }
        
    }
}

import flash.display.Sprite;
import flash.display.Graphics;
import flash.events.*;

class Arrow extends Sprite
{
    
    private var m_rotation:Number = 0;
    
    private function drawArrow(scale:Number = 1):void
    {
        //centrum point
        var c:Array = [4,3];
        
        //shape points
        var Points:Array = [
                               [0,2],
                               [5,2],
                               [5,0],
                               [8,3],
                               [5,6],
                               [5,4],
                               [0,4],
                               [0,2],
                            ];
        
        var g:Graphics = this.graphics;
        g.beginFill(0x000000);
        
        for(var x:int = 0;x < Points.length;x++)
        {
            if (x == 0) g.moveTo((Points[x][0]-c[0])*scale,(Points[x][1]-c[1])*scale);
            else g.lineTo((Points[x][0]-c[0])*scale,(Points[x][1]-c[1])*scale);
        }
        
    }
    public function Arrow(scale:Number = 1, rot:Number = 0):void
    {
        m_rotation = rot;
        drawArrow(scale);                
        this.alpha = 0.5;
        this.rotation = m_rotation;
        return;        
    }
    
    public function setRotation(r:Number):void
    {
        m_rotation = r;
        
        // this is for future modification for example if we
        // want to move the arrow slowly to a specified rotation
        // in an enter frame handler
        
        // for now, just set it
        this.rotation = m_rotation;
    }
    
    public function pointTo(stagex:uint, stagey:uint):void
    {
            //degrees = radians * 180/Math.PI
            var angl:Number;
            angl = Math.atan2(stagey-this.y,stagex-this.x) * 180 / Math.PI;
            this.setRotation(angl);

    }
    
    
    public function setPos(xx:Number, yy:Number):void
    {
        
        
        
        if (isNaN(xx) || isNaN(yy)) return;
        
        if (this.stage != null) {
          if (xx < 0) xx=0;
          if (yy < 0) yy=0;
          if (xx > this.stage.stageWidth) xx = this.stage.stageWidth;
          if (yy > this.stage.stageHeight) yy = this.stage.stageHeight;
        }
        
        this.x = xx;
        this.y = yy;
    }

    public function setPosDelta(xx:Number, yy:Number):void
    {
        setPos(this.x+xx, this.y+yy);
    }    
    
    public function walk(rad:Number=0,scale:Number=1):void
    {
        var dx:Number = 0;
        var dy:Number = 0;
        
        dx = Math.cos((this.rotation+rad)*Math.PI/180)*scale;
        dy = Math.sin((this.rotation+rad)*Math.PI/180)*scale;
        
        
        setPosDelta(dx,dy);
        
        
        
    }
    
}

/// dummy circle, you can delete it

class Circle extends Sprite
{
    public function Circle(size:Number):void
    {
        var g:Graphics = this.graphics;
        this.addEventListener(Event.ADDED_TO_STAGE, onAddedToStage);
        g.beginFill(0x000000);
        g.drawCircle(0,0,size);
        
        return;
    }
    
    private function onAddedToStage(evt:Event):void
    {
        return;
    }
    
}


///////  TRACE REPLACEMENT /////////////  INSERT THIS TO THE END OF YOUR FILE //////
import flash.display.Sprite;
import flash.display.Stage;
import flash.text.TextField;
import flash.text.TextFormat;


//global trace function
var trace:Function;

//wtreace class
class WTrace
{
        private static var FONT:String = "Fixedsys";
        private static var SIZE:Number = 12;
        

        private static var TextFields:Array = [];
        private static var trace_stage:Stage;
        
        public static function initTrace(stg:Stage):void
        {
            trace_stage = stg;
            trace = wtrace;
        }
        
        private static function scrollup():void
        {
            // maximum number of lines: 100
            if (TextFields.length > 100) 
            {
                var removeme:TextField = TextFields.shift();
                trace_stage.removeChild(removeme);
                removeme = null;
            }
            for(var x:Number=0;x<TextFields.length;x++)
            {
                (TextFields[x] as TextField).y -= SIZE*1.2;
            }
        }
    
        public static function wtrace(... args):void
        {
        
            var s:String="";
            var tracefield:TextField;
            
            for (var i:int;i < args.length;i++)
            {
                // imitating flash:
                // putting a space between the parameters
                if (i != 0) s+=" ";
                s+=args[i].toString();
            }
            

            tracefield= new TextField();
            tracefield.autoSize = "left";
            tracefield.text = s;
            tracefield.y = trace_stage.stageHeight - 20;

            var tf:TextFormat = new TextFormat(FONT, SIZE);
            
            tracefield.setTextFormat(tf);
            

            trace_stage.addChild(tracefield);

            scrollup();                      
            TextFields.push(tracefield);
            
        }
    
}




