/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oSyW
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    
    import flash.geom.Point;
    
    [SWF(width = "465", height = "465", frameRate = "60")]
    
    
    /**
     * ...
     * @author 
     */
    public class Main extends Sprite 
    {
        public static const WIDTH:int = 465;
        public static const HEIGHT:int = 465;
        private var canvas:BitmapData;
        private var p1:Path;
        private var p2:Path;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            canvas = new BitmapData(WIDTH, HEIGHT, true, 0);
            addChild( new Bitmap(canvas) );
            
            p1 = new Path();
            p1.x = 50; p1.y = HEIGHT / 2;
            addChild( p1 );
            
            p2 = new Path();
            p2.x = 415; p2.y = HEIGHT / 2;
            addChild( p2 );
            
            addEventListener( Event.ENTER_FRAME, EnterFrameHandler );
        }
        
        private function EnterFrameHandler( e:Event ) : void
        {        
            canvas.lock();
            canvas.fillRect(canvas.rect, 0);
            BresenhamDraw( new Point(p1.x, p1.y), new Point(p2.x, p2.y), canvas );
            canvas.unlock();
        }
        
        
        private function BresenhamDraw( p1:Point, p2:Point, canvas:BitmapData ) : void
        {
            var x1:int, y1:int, x2:int, y2:int;
            var dx:int, dy:int;
            var rev:Boolean = Math.abs( p2.y - p1.y ) > Math.abs( p2.x - p1.x );
            if ( rev )
            {
                x1 = p1.y;
                y1 = p1.x;
                x2 = p2.y;
                y2 = p2.x;
            }else
            {
                x1 = p1.x;
                y1 = p1.y;
                x2 = p2.x;
                y2 = p2.y;                
            }
            
            if ( x2 < x1 )
            {
                var tmp:int = x1;
                x1 = x2;
                x2 = tmp;
                
                tmp = y1;
                y1 = y2;
                y2 = tmp;
            }
            
            dx = x2 - x1;
            dy = y2 - y1;
            var minus:Boolean = false;
            var step:int = 1;
            if ( dy < 0 )
            {
                dy *= -1;
                step = -1;
            }            
            var e:Number = (( rev ) ? dy : dx) / 2;
            
            var x:int = x1, y:int = y1;
            for ( x = x1; x <= x2; x++ )
            {
                if ( rev )    canvas.setPixel32( y, x, 0xFF000000 );
                else        canvas.setPixel32( x, y, 0xFF000000 );
                
                e = e - dy;
                if ( e < 0 )
                {
                    y = y + step;
                    e = e + dx;
                }
            }            
        }        
    }
    
}

import flash.display.Sprite;
import flash.events.MouseEvent;

class Path extends Sprite {
    
    public function Path() {
        graphics.beginFill(0xFF0000);
        graphics.drawCircle(0, 0, 10);
        graphics.endFill();
        
        addEventListener( MouseEvent.MOUSE_DOWN, MouseDown );
        addEventListener( MouseEvent.MOUSE_UP, MouseUp );
        
        this.buttonMode = true;
    }
    
    public function MouseDown( e:MouseEvent ) : void
    {
        this.startDrag();
    }
    
    public function MouseUp( e:MouseEvent ) : void
    {
        this.stopDrag();
    }
}