/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oSy4
 */

// forked from tkinjo's ターゲットの周りを飛ぶキューブ
package  
{
	/**
	 * インボリュート曲線を Lines3D で描く 
	 * 
	 * 
	 * 
	 * --- 参考 ---
	 * 
	 * matsu4512 - Papervisionの勉強(Lines3Dの使い方)
	 * http://wonderfl.kayac.com/code/d98b906c1082ea5d24e50475204243b2c973541b
	 */
	
	import flash.events.Event;
	import org.papervision3d.core.geom.Lines3D;
	import org.papervision3d.materials.special.LineMaterial;
	import org.papervision3d.view.BasicView;
	
	[SWF(width=465,height=465,frameRate=60,backgroundColor=0xffffff)]
	/**
	 * ...
	 * @author tkinjo
	 */
	public class Main extends BasicView
	{
		private const a:Number = 30;
		private const radius:Number = -1000;
		
		
		/**
		 * ラジアン角に対するインボリュート曲線の x 座標を返します。
		 * 
		 * @param	a
		 * @param	theta
		 * @return
		 */
		private function involuteX( theta:Number, a:Number = 1 ):Number {
			
			return a * ( Math.cos( theta) + theta * Math.sin( theta ) );
		}
		
		/**
		 * ラジアン角に対するインボリュート曲線の y 座標を返します。
		 * 
		 * @param	a
		 * @param	theta
		 * @return
		 */
		private function involuteY( theta:Number, a:Number = 1 ):Number {
			
			return a * ( Math.sin( theta ) - theta * Math.cos( theta) );
		}
		
		public function Main() 
		{
			var lineMaterial:LineMaterial = new LineMaterial();
			var lines:Lines3D = new Lines3D( lineMaterial );
			
			var prevX:Number = 0;
			var prevY:Number = 0;
			var prevZ:Number = 0;
			for ( var angle:uint; angle < 360; angle++ ) {
				
				var theta:Number = angleToRadian( angle );
				var x:Number = involuteX( theta, a );
				var y:Number = angle;
				var z:Number = involuteY( theta, a );
				
				lines.addNewLine( 3, prevX, prevY, prevZ, x, y, z );
				
				prevX = x;
				prevY = y;
				prevZ = z;
			}
			scene.addChild( lines );
			camera.target = null;
			
			startRendering();
			
			addEventListener( Event.ENTER_FRAME, enterFrameHandler );
		}
		
		/**
		 * 
		 * @param	angle
		 * @return
		 */
		private function angleToRadian( angle:Number ):Number {
			
			return angle * Math.PI / 180;
		}
		
		
		/**
		 * 
		 * @param	event
		 */
		private function enterFrameHandler( event:Event ):void {
			
			var thetaXZ:Number=360 * ( ( mouseX + stage.stageWidth / 2 ) / stage.stageWidth ) * Math.PI / 180;
			var thetaYZ:Number=360 * ( ( mouseY + stage.stageHeight / 2 ) / stage.stageHeight ) * Math.PI / 180;
			camera.x = radius * Math.cos( thetaYZ ) * Math.sin( thetaXZ );
			camera.y = -radius * Math.sin( thetaYZ );
			camera.z = radius * Math.cos( thetaYZ ) * Math.cos( thetaXZ );
			camera.rotationX = thetaYZ * 180 / Math.PI;
			camera.rotationY = thetaXZ * 180 / Math.PI;
		}
	}
	
}