/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oSAp
 */

// forked from mikelito33bdx's クルクル
//flashとおやつの会の宿題：第一回01
package {
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	
	/**
	 * ...
	 * @author mikelito33bdx
	 */
	public class Main extends Sprite {
		
		private var _btn:Sprite;
		private var _circles:Array;
		private var _rotations:Array;
		
		public function Main():void {
			//_circles = new Array();と同じ意味。
			//こちらの方が処理が軽いらしい
			_circles = [];
			_rotations = [];
			
			//ボタン用テキスト
			var tf:TextField = new TextField();
			tf.text = "CLICK";
			tf.textColor = 0x000000;
			tf.selectable = false;
			tf.x = stage.stageWidth / 2 - 20;
			tf.y = stage.stageHeight / 2 - 10;
			addChild(tf);
			
			//ボタン
			_btn = new Sprite();
			_btn.graphics.beginFill(0x000000, 0.5);
			_btn.graphics.drawCircle(stage.stageWidth / 2, stage.stageHeight / 2, 30);
			_btn.graphics.endFill();
			_btn.buttonMode = true;
			addChild(_btn);	
			//クリックで円を描く
			_btn.addEventListener(MouseEvent.CLICK, onClick);
			
			this.addEventListener(Event.ENTER_FRAME, onEnter);
		}
		
		private function onClick(e:MouseEvent):void {
			var myColor:Number = Math.random();
			var myAlpha:Number = Math.random()*0.5 + 0.3;
			var myPosX:Number = Math.random() * stage.stageWidth / 2;
			var myPosY:Number = Math.random() * stage.stageHeight / 2;
			var circle:Sprite = new Sprite();
			circle.graphics.beginFill(myColor * 0xFFFFFF, myAlpha);
			circle.graphics.drawCircle(myPosX, myPosY, 10);
			circle.graphics.endFill();
			circle.x = stage.stageWidth / 2;
			circle.y = stage.stageHeight / 2;
			addChild(circle);
			//SpriteをArrayに入れる。
			_circles.push(circle);
			//一回のEnterFrameあたりの回転角度も入れる
			_rotations.push(Math.random());
		}
		
		private function onEnter(e:Event):void {
			var n:int = _circles.length;
			for (var i:int = 0; i < n; i++ ) {
				_circles[i].rotation += _rotations[i];
			}
		}
	}
}