/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oS5v
 */

/// @mxmlc -swf-version 30
package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	/** @author www.wad1m.com, twitter:@_wad1m */
	[SWF(width="465", height="465")]
	public class WFL_oS5v extends Sprite 
	{
		static public const R:Rectangle = new Rectangle( 0, 0, 465, 465 );
		public function WFL_oS5v() 
			{if (stage) init();else addEventListener(Event.ADDED_TO_STAGE, init);}
			private function init(e:Event = null):void {
			stage.addEventListener('rightMouseDown', function(e:*):void{randomizePosition(); });
			stage.color = 0;stage.frameRate = 30; stage.align = 'tl'; stage.scaleMode = 'noScale'; 
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			
			graphics.beginFill(0x414141);
			graphics.drawRect(0, 0, R.width, R.height);
			graphics.endFill();
			
			var circle:Circle;
			var circles_count:int = 40;
			var circles:Vector.<Circle> = new Vector.<Circle>( circles_count, true );
			for (var circles_index:int = 0; circles_index < circles_count; ++circles_index ) {
				circle = new Circle( circles_index.toString() );
				addChild( circle );
				circles[ circles_index ] = circle;
			}
			
			function randomizePosition():void
			{
				for (var circles_index:int = 0; circles_index < circles_count; ++circles_index ) 
				{
					circle = circles[ circles_index ];
					circle.x = R.width * Math.random();
					circle.y = R.height * Math.random();
				}
			};
			randomizePosition();
			
			stage.addEventListener('mouseDown', function(e:*):void
			{
				var mp:Point = new Point( stage.mouseX, stage.mouseY );
				var sorted:Array = [];
				
				for (circles_index = 0; circles_index < circles_count; circles_index++) 
				{
					var p:Point = circles[circles_index].pos;
					var l:Number = Point.distance( p, mp );
					if( l <= Circle.RADIUS ) sorted.push( { distance: l, i: circles_index } );
				}
				
				if ( sorted.length == 0 ) return;
				
				sorted.sortOn( 'distance', Array.NUMERIC | Array.DESCENDING );
				
				circle = circles[ sorted[ sorted.length - 1 ].i ];
				
				circle.startDrag( circle.drag = true, R );
				
				// bring circle on top of display list 
				addChild( circle );
			});
			
			stage.addEventListener('mouseUp', function(e:*):void {
				
				for (circles_index = 0; circles_index < circles_count; circles_index++) 
				{
					circle = circles[ circles_index ];
					if ( circle.drag )  {
						circle.drag = false;
						circle.stopDrag();
					}
				}
			});
		}
		
	}
	
}
import flash.display.Sprite;
import flash.geom.Point;
import flash.text.TextField;

class Circle extends Sprite
{
	static public const RADIUS:Number = 40;
	
	public function get pos():Point { return new Point( x, y ); }
	
	public var drag:Boolean = false;
	
	private var label:TextField;
	
	public function Circle( text:String )
	{
		graphics.lineStyle( 2, 0x00FFF9 );
		graphics.beginFill( 0x00FFF9, 0.5 );
		graphics.drawCircle( 0, 0, RADIUS );
		graphics.endFill();
		graphics.lineStyle();
		graphics.beginFill( 0xFAFF1C, 1 );
		graphics.drawCircle( 0, 0, RADIUS * 0.25 );
		graphics.endFill();
		useHandCursor = buttonMode = true;
		label = new TextField();
		label.mouseEnabled = false;
		label.autoSize = 'left';
		label.text = text;
		label.x = -label.width / 2;
		label.y = -label.height / 2;
		addChild( label );
	}
}