/**
 * Copyright lizhi ( http://wonderfl.net/user/lizhi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oQH5
 */

package  
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.ColorTransform;
	import sliz.miniui.Link;
	/**
	 * ...
	 * @author sliz http://game-develop.net/blog
	 */
	public class Wind extends Sprite 
	{
		private var p:Particle;
		private var view:Bitmap;
		private var pen:Shape = new Shape();
		private var ct:ColorTransform = new ColorTransform(1, 1, 1, 1, 50, 50, 50);
		public function Wind() 
		{
			view = new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xffffff));
			addChild(view);
			var c:int = 200;
			while (c-->0) {
				var temp:Particle = new Particle();
				temp.data = c;
				if (p) {
					temp.next = p;
				}
				p = temp;
			}
			addEventListener(Event.ENTER_FRAME, update);
			var link:Link = new Link("Wind @author sliz");
			addChild(link);
			link.x = 10;
			link.y = 10;
		}
		
		private function update(e:Event):void 
		{
			var graphics:Graphics = pen.graphics;
			graphics.clear();
			graphics.lineStyle(0);
			var x:Number = mouseX
			var y:Number = mouseY;
			var temp:Particle = p;
			while (temp) {
				temp.x += (x - temp.x) * 0.9;
				temp.y += (y - temp.y) * 0.9;
				var d:Number = Number(temp.data);
				graphics.drawEllipse(temp.x-d/2, temp.y, d,d/3);
				x = temp.x + (Math.random() * d - d / 2) / 4;
				y = temp.y - 3;
				temp = temp.next;
			}
			view.bitmapData.colorTransform(view.bitmapData.rect, ct);
			view.bitmapData.draw(pen);
		}
	}
}
class Particle 
{
	public var x:Number=0;
	public var y:Number = 0;
	public var data:Object;
	public var next:Particle;
}