/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oPTv
 */

package {
    import flash.display.Sprite;
    import flash.text.*;
    import flash.events.*;
    import flash.net.*;
    import com.adobe.serialization.json.JSON;
    
    public class UndoQuiz extends Sprite {
        private var _ct : int;
        private var _ul : URLLoader;
        private var _tf : TextField;
        private var _min : Number;
        private var _minct : int;
        
        public function UndoQuiz() {
            _tf = new TextField();
            addChild(_tf);
            _tf.width = 465;
            _tf.height = 465;
            
            _ct = 0;
            _min = Number.MAX_VALUE;
            _minct = -1;
            start();
        }
        
        private function start() : void
        {
            _ul = new URLLoader();
            _ul.addEventListener(Event.COMPLETE, onComplete);
            _ul.addEventListener(IOErrorEvent.IO_ERROR, onIOError);
            _ul.load(new URLRequest(
                "http://ajax.googleapis.com/ajax/services/search/web?q=" + _ct.toString() + "&v=1.0"
                ));
        }
        
        private function onComplete(e : Event) : void
        {
            _ul.removeEventListener(Event.COMPLETE, onComplete);
            _ul.removeEventListener(IOErrorEvent.IO_ERROR, onIOError);
            
            var data : String = _ul.data;
            var obj : Object = JSON.decode(data);
            
            var rc : Number = obj.responseData.cursor.estimatedResultCount;
            _tf.appendText(_ct.toString() + " : " + rc.toString() + "\t");
            if(_min > rc){
                _min = rc;
                _minct = _ct;
            }
            
            _ct++;
            if(_ct <= 100){
                if(_ct % 6 == 0)_tf.appendText("\n");
                start();
            }else{
                _tf.appendText("\n" + "MIN : " + _minct.toString() + " : " + _min.toString());
            }
        }

        private function onIOError(e : IOErrorEvent) : void
        {
            _tf.appendText(e.text);
            _ul.removeEventListener(Event.COMPLETE, onComplete);
            _ul.removeEventListener(IOErrorEvent.IO_ERROR, onIOError);
        }
    }
}