/**
 * Copyright clockmaker ( http://wonderfl.net/user/clockmaker )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oPN7
 */

// forked from uwi's uint vs int
// muta244のツールキットを借り
package {

import flash.display.*;
import flash.geom.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;
import flash.net.*;
import flash.system.*;
import jp.nium.core.debug.Logger;
import mx.logging.LogLogger;


public class Main extends Sprite
{
    static private const _NUM_TIMES:uint = 2000;
    
    private function _init():void
    {
        _debug(
            "各テスト " + _NUM_TIMES + " 回処理させた計算結果 [単位 ： ミリ秒]\n" +
            "(誤差は多少生じます)\n\n" +
            "Player Version : " + Capabilities.version + "\n" + 
            "Debug Player : " + Capabilities.isDebugger + "\n"
        );
        
        _measure("trace", function ():void
        {
            for (var i:int = _NUM_TIMES - 1; i >= 0; i--) {
                trace(i);
            }
        });
        
        _measure("LocalConnection", function ():void
        {
            var conn:LocalConnection = new LocalConnection();
            
            for (var i:uint = _NUM_TIMES - 1; i > 0; i--) {
                conn.send("myConnection", "lcHandler", i);
            }
        });
        
        _measure("Logger (jp.nium.core.debug - use trace)", function ():void
        {
            for (var i:uint = _NUM_TIMES - 1; i > 0; i--) {
                Logger.info(i);
            }
        });
        
        _measure("LogLogger (mx.logging - no trace)", function ():void
        {
            var logger:LogLogger = new LogLogger("");
            for (var i:uint = _NUM_TIMES - 1; i > 0; i--) {
                logger.debug(i.toString());
            }
        });
        
        _debug("\n結果については言及しませんので, 各自ご判断ください.");
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    public function Main():void
    {
        _setup();
        _init();
    }
    
    private function _measure(title:String, func:Function, ...params):void
    {
        _time = getTimer();
        func.apply(null, params);
        _time = getTimer() - _time;
        
        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth - 40;
        _field.height = stage.stageHeight - 60;
        _field.x = 20;
        _field.y = 60;
        _field.multiline = true;
        _field.wordWrap = true;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
        
        var button:Sprite = new Sprite();
        button.graphics.lineStyle(1, 0xBBBBBB);
        button.graphics.beginFill(0xEEEEEE);
        button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
        button.graphics.endFill();
        
        addChild(button);
        
        button.x = 20;
        button.y = 20;
        button.mouseChildren = false;
        button.buttonMode = true;
        
        var field:TextField = new TextField();
        field.width = 100;
        field.height = 20;
        field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
        
        button.addChild(field);
        
        button.addEventListener(MouseEvent.CLICK, function ():void
        {
            _field.text = "";
            _init();
        });
    }
}

}
