/**
 * Copyright axcel_work ( http://wonderfl.net/user/axcel_work )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oPEm
 */

package {
    import com.bit101.components.CheckBox;
    import com.bit101.components.HUISlider;
    import com.bit101.components.Label;
    import com.bit101.components.VUISlider;

    import org.si.sion.SiONDriver;
    import org.si.sion.events.SiONTrackEvent;
    import org.si.sound.DrumMachine;
    import org.si.sound.events.SoundObjectEvent;

    import flash.display.Sprite;
    import flash.events.Event;

    /**
     * @author axcelwork
     */
    public class Index extends Sprite {
        private var driver:SiONDriver = new SiONDriver();
        private var _sionDrum:DrumMachine;
        
        private var _bassSlider:HUISlider;
        private var _hihatSlider:HUISlider;
        private var _snareSlider:HUISlider;
        private var _volumeSlider:VUISlider;
        
        private var _debug:PadCanvas;

        private var isSound1:Boolean = false;
        private var isSound2:Boolean = false;
        private var isSound3:Boolean = false;

        
        /**
         * 
         */
        public function Index() {
            
            if(stage) this.atInit();
            else this.addEventListener(Event.ADDED_TO_STAGE, atInit);
        }

        private function atInit(e:Event = null):void {
            trace("[Info] スタート");
            
            this.stage.scaleMode = "noScale";
            this.stage.align = "left";            
            
            this._bassSlider = new HUISlider(this, 80, 0, "", bassChange);
            this._bassSlider.width = 300;
            this._bassSlider.maximum = 31;
            this._bassSlider.labelPrecision = 0;

            this._hihatSlider = new HUISlider(this, 80, 40, "", hihatChange);
            this._hihatSlider.width = 300;
            this._hihatSlider.maximum = 17;
            this._hihatSlider.labelPrecision = 0;

            this._snareSlider = new HUISlider(this, 80, 20, "", snareChange);
            this._snareSlider.width = 300;
            this._snareSlider.maximum = 18;
            this._snareSlider.labelPrecision = 0;
            
            this._volumeSlider = new VUISlider(this, 0, 0, "Volume", voluneChange);
            this._volumeSlider.maximum = 100;
            this._volumeSlider.value = 50;
            this._volumeSlider.labelPrecision = 0;
            

            new Label(this, 55, 0, "Bass");
            new Label(this, 55, 20, "Snare");
            new Label(this, 55, 40, "Hihat");

            new CheckBox(this, 355, 5, "mute", selectBass);
            new CheckBox(this, 355, 25, "mute", selectSnare);
            new CheckBox(this, 355, 45, "mute", selectHihat);
            
            
            driver.play();
            this._sionDrum = new DrumMachine(this._bassSlider.value, this._hihatSlider.value, this._snareSlider.value, 0, 0, 0);
            this._sionDrum.addEventListener(SiONTrackEvent.NOTE_ON_FRAME, hoge);
            this._sionDrum.play();
            
            
            
            
            // debug
            this._debug = new PadCanvas();
            this._debug.x = this.stage.stageWidth >> 2;
            this._debug.y = this.stage.stageHeight >> 2;
            this.stage.addChild(this._debug);
        }
        
        private function hoge(e:SoundObjectEvent):void{
            this._debug.update(e.track.trackNumber);
        }
        
        
        private function voluneChange(e:Event):void{
            this._sionDrum.volume = this._volumeSlider.value/ 100;
        }
        
        private function bassChange(e:Event):void{
            this._sionDrum.bassPatternNumber = this._bassSlider.value;
        }
        private function hihatChange(e:Event):void{
            this._sionDrum.hihatPatternNumber = this._hihatSlider.value;
        }
        private function snareChange(e:Event):void{
            this._sionDrum.snarePatternNumber = this._snareSlider.value;
        }
        
        
        
        private function selectBass(e:Event):void {
            this.isSound1 = !this.isSound1;
            if(this.isSound1) { this._sionDrum.bassVolume = 0; }
            else { this._sionDrum.bassVolume = 1; }
        }
        private function selectSnare(e:Event):void {
            this.isSound2 = !this.isSound2;
            if(this.isSound2) { this._sionDrum.snareVolume = 0; }
            else { this._sionDrum.snareVolume = 1; }
        }
        private function selectHihat(e:Event):void {
            this.isSound3 = !this.isSound3;
            if(this.isSound3) { this._sionDrum.hihatVolume = 0; }
            else { this._sionDrum.hihatVolume = 1; }
        }
    }
}

import fl.motion.easing.*;

import com.flashdynamix.motion.Tweensy;
import com.flashdynamix.motion.TweensyTimeline;

import flash.display.Sprite;

/**
 * @author axcelwork
     */
    class PadCanvas extends Sprite {
        private var _bassPad:Sprite;
        private var _hihatPad:Sprite;
        private var _snarePad:Sprite;

        
        
        public function PadCanvas() {
            
            this._bassPad = new Sprite();
            this._bassPad.graphics.lineStyle(5, 0xcccccc);
            this._bassPad.graphics.drawCircle(0, 0, 10);
            this._bassPad.graphics.endFill();
            
            this._hihatPad = new Sprite();
            this._hihatPad.graphics.lineStyle(5, 0xfff159);
            this._hihatPad.graphics.drawCircle(0, 0, 10);
            this._hihatPad.graphics.endFill();
            
            this._snarePad = new Sprite();
            this._snarePad.graphics.lineStyle(5, 0x5969ff);
            this._snarePad.graphics.drawCircle(0, 0, 10);
            this._snarePad.graphics.endFill();
            
            
            this._bassPad. x = 0;
            this._hihatPad.x = 50;
            this._snarePad.x = 100;
            
            
            this.addChild(this._bassPad);
            this.addChild(this._hihatPad);
            this.addChild(this._snarePad);
        }

        
        public function update(num:int):void {
            var tween:TweensyTimeline;
            
            switch(num) {
                case 0:
                    tween = Tweensy.to(this._bassPad, {scaleX: 1.2, scaleY: 1.2}, 0.05, Quadratic.easeOut);
                    tween.onComplete = end0;
                    break;
                case 1:
                    tween = Tweensy.to(this._hihatPad, {scaleX: 1.2, scaleY: 1.2}, 0.05, Quadratic.easeOut);
                    tween.onComplete = end1;
                break;
                case 2:
                    tween = Tweensy.to(this._snarePad, {scaleX: 1.2, scaleY: 1.2}, 0.05, Quadratic.easeOut);
                    tween.onComplete = end2;
                break;
                
                
            }
            
        }
        
        private function end0():void{
            Tweensy.to(this._bassPad, {scaleX: 1.0, scaleY: 1.0}, 0.05, Quadratic.easeOut);
        }
        private function end1():void{
            Tweensy.to(this._hihatPad, {scaleX: 1.0, scaleY: 1.0}, 0.05, Quadratic.easeOut);
        }
        private function end2():void{
            Tweensy.to(this._snarePad, {scaleX: 1.0, scaleY: 1.0}, 0.05, Quadratic.easeOut);
        }
        
        
    }
