/**
 * Copyright hakerlab ( http://wonderfl.net/user/hakerlab )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oP64
 */

// forked from ProjectNya's 煙もくもく (1)
////////////////////////////////////////////////////////////////////////////////
// 煙もくもく (1)
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var label:Label;
        private var smokes:Smokes;
        private var playBtn:Btn;
        private var stopBtn:Btn;

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            label = new Label(200, 20, 48, Label.CENTER);
            addChild(label);
            label.x = 132;
            label.y = 182;
            label.textColor = 0xFFFFFF;
            label.text = "smoke";
            label.alpha = 0.5;
            //
            var rect:Rectangle = new Rectangle(0, 0, 160, 450);
            smokes = new Smokes(rect);
            addChild(smokes);
            smokes.x = 152;
            smokes.y = 0;
            //smokes.alpha = 0.5;
            //
            playBtn = new Btn();
            playBtn.x = 192;
            playBtn.y = 440;
            addChild(playBtn);
            playBtn.init({id: 0, label: "play", type: 2});
            playBtn.addEventListener(MouseEvent.CLICK, play, false, 0, true);
            stopBtn = new Btn();
            stopBtn.x = 272;
            stopBtn.y = 440;
            addChild(stopBtn);
            stopBtn.init({id: 1, label: "stop", type: 2});
            stopBtn.addEventListener(MouseEvent.CLICK, stop, false, 0, true);
            stopBtn.enabled = false;
        }
        private function play(evt:MouseEvent):void {
            smokes.start();
            playBtn.clicked = true;
            stopBtn.enabled = true;
        }
        private function stop(evt:MouseEvent):void {
            smokes.stop();
            playBtn.clicked = false;
            stopBtn.enabled = false;
        }
        
    }

}


//////////////////////////////////////////////////
// Smokesクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.events.Event;
import flash.display.BlendMode;
import flash.geom.Matrix;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.ColorTransform;
import flash.utils.Timer;
import flash.events.TimerEvent;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.events.TweenEvent;
import org.libspark.betweenas3.easing.*;

class Smokes extends Sprite {
    private var rect:Rectangle;
    private var area:Rectangle;
    private var bitmapData:BitmapData;
    private var bitmap:Bitmap;
    private var particles:Array;
    private static var radian:Number = Math.PI/180;
    private var timer:Timer;
    private static var interval:uint = 20;
    private static var point:Point = new Point();

    public function Smokes(r:Rectangle) {
        rect = r;
        var bw:uint = rect.width;
        var bh:uint = rect.height;
        area = new Rectangle(bw*0.3, bh*0.75, bw*0.4, bh*0.25 - 32);
        init();
        blendMode = BlendMode.SCREEN;
    }

    private function init():void {
        bitmapData = new BitmapData(rect.width, rect.height, true, 0x00000000);
        bitmap = new Bitmap(bitmapData);
        addChild(bitmap);
        particles = new Array();
    }
    public function start():void {
        timer = new Timer(interval);
        timer.addEventListener(TimerEvent.TIMER, create, false, 0, true);
        timer.start();
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    public function stop():void {
        if (timer) {
            timer.stop();
            timer = null;
        }
    }
    private function create(evt:TimerEvent):void {
        for (var n:uint = 0; n < 3; n++) {
            var smoke:Smoke = new Smoke();
            smoke.vx = 0;
            smoke.vy = -10;
            var px:Number = area.x + Math.random()*area.width;
            var py:Number = area.y + Math.random()*area.height;
            var r:Number = Math.atan2(smoke.vy, smoke.vx);
            r += 20*(0.5 - Math.random())*radian;
            var tx:Number = Math.cos(r)*(Math.random() + 0.5)*area.width*1.5;
            var ty:Number = Math.sin(r)*(Math.random() + 0.5)*area.height*2.25;
            var nx:Number = tx*0.3*Math.random();
            var ny:Number = ty*0.3*Math.random();
            var cx:Number = nx + (tx - nx)*0.5;
            var cy:Number = ny + (ty - ny)*0.5;
            var itween:ITween = BetweenAS3.bezier(smoke, 
                {x: px + tx, y: py + ty, scaleX: 2.5, scaleY: 2.5, alpha: 0, blur: 16}, 
                {x: px + nx, y: py + ny, scaleX: 0.8, scaleY: 0.8, alpha: 0, blur: 4}, 
                {x: px + cx, y: py + cy, scaleX: 0.8, scaleY: 0.8, alpha: 1.2, blur: 0}, 
            1, Cubic.easeOut);
            itween.addEventListener(TweenEvent.COMPLETE, complete, false, 0, true);
            itween.play();
            particles.push(smoke);
        }
    }
    public function update(evt:Event = null):void {
        bitmapData.lock();
        bitmapData.fillRect(rect, 0x00000000);
        for (var n:uint = 0; n < particles.length; n++) {
            var smoke:Smoke = particles[n];
            if (smoke) {
                var matrix:Matrix = new Matrix();
                matrix.scale(smoke.scaleX, smoke.scaleY);
                matrix.translate(smoke.x, smoke.y);
                var colorTrans:ColorTransform = new ColorTransform();
                colorTrans.alphaMultiplier = smoke.alpha;
                bitmapData.draw(smoke, matrix, colorTrans);
            }
        }
        bitmapData.unlock();
    }
    private function complete(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, complete);
        //
        var smoke:Smoke = Smoke(evt.target.target);
        particles.shift();
        smoke = null;
        if (particles.length < 1) {
            update();
            removeEventListener(Event.ENTER_FRAME, update);
        }
    }

}


//////////////////////////////////////////////////
// Smokeクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;
import flash.filters.BlurFilter;

class Smoke extends Sprite {
    private static var radius:uint = 16;
    public var px:Number = 0;
    public var py:Number = 0;
    public var vx:Number = 0;
    public var vy:Number = 0;
    private var _blur:Number = 0;

    public function Smoke() {
        draw();
    }

    private function draw():void {
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(radius*2, radius*2, 0, -radius, -radius);
        var colors:Array = [0xFFFFFF, 0xFFFFFF, 0xFFFFFF];
        var alphas:Array = [1, 0.7, 0];
        var ratios:Array = [0, 161, 255];
        graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        graphics.drawCircle(0, 0, radius);
        graphics.endFill();
    }
    public function get blur():Number {
        return _blur;
    }
    public function set blur(param:Number):void {
        _blur = param;
        filters = [new BlurFilter(_blur, _blur, 1)];
    }

}


//////////////////////////////////////////////////
// Labelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

class Label extends Sprite {
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 20;
    private var _height:uint = 20;
    private var size:uint = 12;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;

    public function Label(w:uint, h:uint, s:uint = 12, align:String = LEFT) {
        _width = w;
        _height = h;
        size = s;
        draw(align);
    }

    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:uint):void {
        txt.textColor = param;
    }

}


//////////////////////////////////////////////////
// Btnクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;

class Btn extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var txt:TextField;
    private var label:String = "";
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 60;
    private static var _height:uint = 20;
    private static var corner:uint = 5;
    private var type:uint = 1;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var upColor:uint = 0x666666;
    private static var overColor:uint = 0x333333;
    private static var offColor:uint = 0x999999;
    private static var gColor:uint = 0x0099FF;
    private var blueGlow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private var _clicked:Boolean = false;
    private var _enabled:Boolean = true;

    public function Btn() {
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        if (option.type != undefined) type = option.type;
        draw();
    }
    private function draw():void {
        switch (type) {
        case 1 :
            bColor = 0xFFFFFF;
            sColor = 0x000000;
            upColor = 0x666666;
            overColor = 0x333333;
            offColor = 0x999999;
            break;
        case 2 :
            bColor = 0x000000;
            sColor = 0xFFFFFF;
            upColor = 0x666666;
            overColor = 0x999999;
            offColor = 0x333333;
            break;
        }
        blueGlow = new GlowFilter(gColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        txt = new TextField();
        addChild(shade);
        addChild(bottom);
        addChild(light);
        addChild(base);
        addChild(txt);
        createBase(shade, _width, _height, corner, sColor);
        shade.filters = [shadeGlow];
        createBase(bottom, _width, _height, corner, sColor, 0.3);
        createBase(light, _width, _height, corner, gColor);
        light.filters = [blueGlow];
        createBase(base, _width, _height, corner, bColor);
        txt.x = -_width*0.5;
        txt.y = -_height*0.5;
        txt.width = _width;
        txt.height = _height - 1;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 12;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.text = label;
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
    }
    private function release(evt:MouseEvent):void {
        _up();
    }
    private function click(evt:MouseEvent):void {
    }
    private function _up():void {
        txt.y = -_height*0.5;
        txt.textColor = upColor;
        base.y = -1;
        light.visible = false;
        light.y = -1;
    }
    private function _over():void {
        txt.y = -_height*0.5;
        txt.textColor = overColor;
        base.y = -1;
        light.visible = true;
        light.y = -1;
    }
    private function _down():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = overColor;
        base.y = 0;
        light.visible = true;
        light.y = 0;
    }
    private function _off():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = offColor;
        base.y = 0;
        light.visible = false;
        light.y = 0;
    }
    public function get clicked():Boolean {
        return _clicked;
    }
    public function set clicked(param:Boolean):void {
        _clicked = param;
        enabled = !_clicked;
        if (_clicked) {
            _down();
        } else {
            _up();
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _off();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
            removeEventListener(MouseEvent.CLICK, click);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -h*0.5, w, h, c*2);
        target.graphics.endFill();
    }

}
