/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oP04
 */

// forked from siouxcitizen's PV3DのTriangleMesh3Dの練習03　ピラミッド型の作成
//PV3DのTriangleMesh3Dの練習04　フラットシェーディング練習
//やっと初めてのフラットシェーディング練習できました(TriangleMesh3Dの必要ないですが。。。)。
//
//↓今回のコードを作成するにあたって以下のコードを参考にさせて頂きました
//forked from: forked from: Mesh Clock
//http://wonderfl.net/c/iO9S
package
{
    import flash.events.Event;
    import org.papervision3d.core.geom.TriangleMesh3D;
    import org.papervision3d.core.geom.renderables.Triangle3D;
    import org.papervision3d.core.geom.renderables.Vertex3D;
    import org.papervision3d.core.math.NumberUV;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.view.BasicView;

    [SWF(width="640", height="480", backgroundColor="#000000", frameRate="60")]
    public class TriangleMesh3DExample extends BasicView
    {
        private var mesh : TriangleMesh3D;
        private var size : int = 200;//オブジェクトの長さ
        private var light:PointLight3D

        public function TriangleMesh3DExample() {
            //光源設定
            light = new PointLight3D();
            light.y = -8000;
            light.x = -8000;
            light.z = -8000;

            //マテリアル設定
            var material : FlatShadeMaterial = new FlatShadeMaterial(light, 0xffff99, 0xff9900);
            material.doubleSided = true;

            //TriangleMesh3Dオブジェクト生成
            mesh = new TriangleMesh3D( material, [], [], null ); //配列部分は↓下記で設定
            scene.addChild(mesh);

            //頂点定義
            var v0 : Vertex3D = new Vertex3D(-size, -size, size);
            var v1 : Vertex3D = new Vertex3D(size, -size, size);

            var v2 : Vertex3D = new Vertex3D(0, size, 0);

            var v3 : Vertex3D = new Vertex3D(-size, -size, -size);
            var v4 : Vertex3D = new Vertex3D(size, -size, -size);

            mesh.geometry.vertices.push( v0 );
            mesh.geometry.vertices.push( v1 );
            mesh.geometry.vertices.push( v2 );
            mesh.geometry.vertices.push( v3 );
            mesh.geometry.vertices.push( v4 );
            //面定義
            var uvA : NumberUV = new NumberUV( 0, 0 );
            var uvC : NumberUV = new NumberUV( 1, 0 );
            var uvB : NumberUV = new NumberUV( 0, 1 );

            mesh.geometry.faces.push( new Triangle3D( mesh, new Array(v0,v1,v2), null, new Array(uvA,uvC,uvB) ));
            mesh.geometry.faces.push( new Triangle3D( mesh, new Array(v3,v4,v2), null, new Array(uvA,uvC,uvB) ));
            mesh.geometry.faces.push( new Triangle3D( mesh, new Array(v3,v0,v2), null, new Array(uvA,uvC,uvB) ));
            mesh.geometry.faces.push( new Triangle3D( mesh, new Array(v1,v4,v2), null, new Array(uvA,uvC,uvB) ));
            mesh.geometry.ready = true;

            startRendering();
        }

        override protected function onRenderTick(event:Event=null):void {
            mesh.rotationX=viewport.mouseX;
            mesh.rotationY=viewport.mouseY;
            super.onRenderTick(event);
        }
    }
}