/**
 * Copyright megant ( http://wonderfl.net/user/megant )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oO4M
 */

// forked from m-saitoo's flash on 2011-12-14
package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.utils.*;
        import flash.text.*;    
        import flash.filters.*;

    [SWF(width=465, height=465, backgroundColor=0xFDEA9B, frameRate=60)]
    public class Liquid extends Sprite {
        private const NUM_PARTICLES:uint = 100000;
        private var particles:Vector.<Particle> = new Vector.<Particle>(NUM_PARTICLES, true);
        private var screen:BitmapData;
        private var densityMap:BitmapData;
        private var timer:Timer;
        private var seed:Number = Math.floor(Math.random() * 0xFFFF);
        private var offset:Array = [new Point(), new Point()];
        private var colotTrans:ColorTransform = new ColorTransform(0.8, 0.8, 0.8);
    
                private var text:TextField=new TextField();

        public function Liquid() {
            for (var i:uint=0; i<NUM_PARTICLES; i++) {
                particles[i] = new Particle(Math.random() * 465, Math.random() * 465);
            }
            densityMap = new BitmapData(233, 233, false, 0x000000);
            screen = new BitmapData(465, 465, false, 0xFDEA9B);
            addChild(new Bitmap(screen));
            // addChild(new Bitmap(densityMap));
                        addEventListener(Event.ENTER_FRAME, loop);
            timer = new Timer(100, 0);
            timer.addEventListener(TimerEvent.TIMER, reset);
            timer.start();

                        text.text="This is the text";
                        text.textColor=0xffffff
                        // text.filters=[new GlowFilter(0xffffff,1,8,8,20)]

            reset();
        }
        private function loop(event:Event):void {
            screen.lock();
            //screen.colorTransform(screen.rect, colotTrans);
                        screen.fillRect(screen.rect,0x660000)
            for each (var p:Particle in particles) {
                var c:uint = densityMap.getPixel(p.px >> 1, p.py >> 1);
                               var aa:Number=(c!=0xFFFFFF)?0.92:0.05;
                               
                               p.px += p.vx += p.ax +=((0xFF & c     ) - 0x80) * 0.0005;
                   p.py += p.vy += p.ay +=((0xFF & c >> 8) - 0x80) * 0.0005;

                p.ax *= 0.96; p.ay *= 0.96;
                p.vx *= aa; p.vy *= aa;
                screen.setPixel(
                    p.px = ((p.px > 464) ? 0 : (p.px < 0) ? 464 : p.px),
                    p.py = ((p.py > 464) ? 0 : (p.py < 0) ? 464 : p.py),
                    0xaa8800+((0x55*Math.random())<<16));
            }
    screen.applyFilter(screen,screen.rect,new Point(),new BlurFilter(1,1))

            screen.unlock();
        }
        private function reset(event:Event=null):void {
    
                        var mat:Matrix=new Matrix();
                        mat.scale(4,4)
                        
            densityMap.perlinNoise(117, 117, 2, seed, false, true, 6, false, offset);
                        densityMap.draw(text,mat);
            offset[0].x += 1.5;
            offset[1].y += 1.0;
            //colotTrans.redMultiplier  = Math.cos(timer.currentCount * 0.0131) * 0.2 + 0.7;
            //colotTrans.blueMultiplier = Math.sin(timer.currentCount * 0.0572) * 0.2 + 0.7;
        }
    }
}

class Particle {
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var ax:Number = 0;
    public var ay:Number = 0;
    public var px:Number;
    public var py:Number;
    public function Particle(px:Number, py:Number) {
        this.px = px;
        this.py = py;
    }
}

