/**
 * Copyright yooyke ( http://wonderfl.net/user/yooyke )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oNx7
 */

// forked from nextyukke's 01. 繰り返し (ENTER_FRAME)
package {
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private const SIZE:Number = 100;
        private const SIZE_D2:Number = SIZE / 2;
        private const SPEED:Number = 2;
        
        private var rect1_:Sprite;
        private var rect2_:Sprite;
        private var vector1_:Number = SPEED;
        private var vector2_:Number = -SPEED;
        
        public function FlashTest() {
            // write as3 code here..
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        // 矩形の衝突計算
        private function rect(x1:Number, y1:Number, w1:Number, h1:Number, x2:Number, y2:Number, w2:Number, h2:Number):Boolean {
            return x1 <= x2 + w2 && x2 <= x1 + w1 && y1 <= y2 + h2 && y2 <= y1 + h1;
        }
        
        // 毎回呼ばれる場所
        private function onEnterFrame(e:Event):void {
            rect1_.x += vector1_;
            if (rect1_.x > stage.stageWidth - SIZE_D2 || rect1_.x < SIZE_D2) {
                vector1_ *= -1;
            }
            
            rect2_.x += vector2_;
            if (rect2_.x > stage.stageWidth - SIZE_D2 || rect2_.x < SIZE_D2) {
                vector2_ *= -1;
            }
            
            // 当たるか調べる
            var hit:Boolean = rect(rect1_.x, rect1_.y, rect1_.width, rect1_.height, rect2_.x, rect2_.y, rect2_.width, rect2_.height);
            
            // 当たった
            if (hit) {
                drawRect(rect1_, 0xff0000);
                drawRect(rect2_, 0xff0000);
            }
            // 当たってない
            else {
                drawRect(rect1_, 0x00ff00);
                drawRect(rect2_, 0x00ff00);
            }
        }
        
        private function init(e:Event=null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            rect1_ = createRect(80, 120, 0x00ff00);
            addChild(rect1_);
            
            rect2_ = createRect(400, 180, 0x00ff00);
            addChild(rect2_);

            addEventListener(Event.ENTER_FRAME, onEnterFrame)
        }
        
        private function createRect(x:Number, y:Number, color:uint):Sprite {
            var sp:Sprite = new Sprite();
            drawRect(sp, color);
            sp.x = x;
            sp.y = y;
            return sp;
        }
        
        private function drawRect(sp:Sprite, color:uint):void {
            sp.graphics.clear();
            sp.graphics.beginFill(color, 0.5);
            sp.graphics.drawRect(-SIZE_D2, -SIZE_D2, SIZE, SIZE);
            sp.graphics.endFill();
        }
    }
}