/**
 * Copyright Kay ( http://wonderfl.net/user/Kay )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oNQP
 */

// forked from Kay's forked from: FontLoader
// forked from mash's FontLoader
// thanks to the free font authors!
/*
 * limitの長さを超える文字列は長体をかけて表示します。 
 * INPUT : Focus In
 * OUTPUT : Focus Out
 */
package {
    import flash.events.*;
    import flash.text.*;
    import flash.display.*;
    import net.wonderfl.utils.FontLoader;

    public class FlashTest extends Sprite {
        
        private var loader :FontLoader = new FontLoader;
        private var input_txt:TextField = new TextField();
        private var shape:Shape = new Shape();
        private const FONT:String = "UmeUgo"; 
        private var fields:Array = new Array();
        private var limit:Number = 300;
        
        public function FlashTest() {
            loader.load( FONT );
            loader.addEventListener( Event.COMPLETE, setInputForm);
        }
        
        private function setInputForm(e:Event):void {
            loader.removeEventListener( Event.COMPLETE, setInputForm);
            input_txt.x = 10;
            input_txt.y = 100;
            input_txt.border = true;
            input_txt.background = true;
            input_txt.backgroundColor = 0xffffff;
            input_txt.embedFonts=true;
            input_txt.multiline=false;
            input_txt.width = stage.stageWidth-20;
            input_txt.height = 30;
            input_txt.type = TextFieldType.INPUT;
            var format:TextFormat = new TextFormat();
            format.font= FONT;
            format.size=26;
            format.kerning = true;
            input_txt.defaultTextFormat=format;
            input_txt.addEventListener(FocusEvent.FOCUS_OUT,setExample);
            input_txt.addEventListener(FocusEvent.FOCUS_IN,fieldReset);
            input_txt.text = '長いものは巻きこんじゃえ！';
            shape.graphics.beginFill(0x66cccc,0.5);
            shape.graphics.drawRect(0,0,limit,stage.stageHeight);
            shape.x = (stage.stageWidth-limit) /2;
            addChild(shape);
            addChild(input_txt);
        }
        
        private function fieldReset(e:FocusEvent):void {
            input_txt.text = "";
        }
        
        private function setExample(e:FocusEvent):void {
            var offset:Number = 40;
            var field:TextField = new TextField();
            field.width = limit+offset;    // 右が切れないように
            field.height = 40;
            field.x = (stage.stageWidth-limit)/2;
            field.y = input_txt.y + input_txt.height;
            field.type = TextFieldType.DYNAMIC;
            field.embedFonts=true;
            field.defaultTextFormat=input_txt.defaultTextFormat;
            field.multiline=false;
            field.selectable = false;
            field.text = input_txt.text;
            // 長い文字列には長体をかける
            // ……はできないのでTextFieldを縮めます
            var textWidth:Number = field.textWidth;
            var ratio:Number = textWidth > limit ? limit / textWidth : 1;
            field.width = limit / ratio + offset;
            field.scaleX = ratio;
            addChild(field);
            for (var i:int = 0; i < fields.length; i++) {
                fields[i].y += input_txt.height;
            }
            fields.push(field);
            if (fields.length > 10) removeChildAt(1);
        }
    }
}