/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oNMg
 */

package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    
    [SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="60")] 
    /**
     * ...
     * @author tkinjo
     */
    public class Main extends Sprite 
    {
        private var animateText:AnimateText = new AnimateText();
        
        
        public function Main():void 
        {
            addChild( animateText );
            
            animateText.texts = [ "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbb", "ccccc" ];
            animateText.width = stage.stageWidth;
            animateText.height = stage.stageHeight;
            animateText.addEventListener(Event.COMPLETE, function( event:Event ):void { trace( "comp" ); } );
            animateText.play();
            
            stage.addEventListener(MouseEvent.CLICK, clickHandler);
        }
        
        private function clickHandler( event:MouseEvent ):void {
            
            if ( !animateText.animating )
                animateText.play();
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.text.*;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.easing.Expo;
import org.libspark.betweenas3.events.TweenEvent;
import org.libspark.betweenas3.tweens.ITween;

class AnimateText extends TextField {
    
    /**
     * ...
     * @eventType flash.events.Event.COMPLETE
     */
    [Event(name = "complete", type = "flash.events.Event")] 
    
    private const CHARACTERS:Array = [ 
        "0123456789", 
        "abcdefghijklmnopqrstuvwxyz", 
        "ABCDEFGHIJKLMNOPQRSTUVWXYZ", 
        "!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~" 
    ];
    
    public var texts:Array;
    public var processingTextsIndex:uint = 0;
    
    public var useCharacterTypes:uint = CharacterType.NUMBER + CharacterType.ALPHABET_SMALL + CharacterType.ALPHABET_LARGE;
    
    public var tweenAheadCharPosition:uint = 0;
    public var tweenCharPosition:uint = 0;
    
    private var tween:ITween;
    
    private var tweenDelay:Number = 0.1;
    private var tweenTime:Number = 1;
    
    private var _animating:Boolean;
    public function get animating():Boolean { return _animating; }
    
    public function AnimateText():void {
        
        super();
    }
    
    public function play():void {
        
        _animating = true;
        
        tween = BetweenAS3.parallel( 
            BetweenAS3.tween( this, { tweenAheadCharPosition:texts[ processingTextsIndex ].length }, { tweenAheadCharPosition:0 }, tweenTime, Expo.easeOut ), 
            BetweenAS3.delay( BetweenAS3.tween( this, { tweenCharPosition:texts[ processingTextsIndex ].length }, { tweenCharPosition:0 }, tweenTime, Expo.easeOut ), tweenDelay )
        );
        
        tween.addEventListener(TweenEvent.UPDATE, tweenUpdateHandler);
        tween.addEventListener(TweenEvent.COMPLETE, tweenCompleteHandler);
        tween.play();
    }
    
    private function tweenUpdateHandler( event:TweenEvent ):void {
        
        text = texts[ processingTextsIndex ].substring( 0, tweenCharPosition );
        appendText( randomText( tweenAheadCharPosition - tweenCharPosition ) );
    }
    
    private function tweenCompleteHandler( event:TweenEvent ):void {
        
        if ( processingTextsIndex + 1 < texts.length ) {
            
            processingTextsIndex++;
            play();
            
        } else {
        
            processingTextsIndex = 0;
            _animating = false;
        }
        
        dispatchEvent( new Event( Event.COMPLETE ) );
    }
    
    public function randomText( textLength:Number = 10 ):String {
        
        var randomText:String = "";
        
        var useCharactersLength:uint = useCharacters.length;
        
        for( var i:uint = 0; i < textLength; i++ )
            randomText += useCharacters.charAt( uint( Math.random() * useCharactersLength ) );
        
        return randomText;
    }
    
    private function get useCharacters():String {
        
        var useCharacters:String = "";
        
        for ( var i:uint = 0; i < CHARACTERS.length; i++ ) {
            
            if ( useCharacterTypes & Math.pow( 2, i ) )
                useCharacters += CHARACTERS[ i ];
        }
        
        return useCharacters;
    }
    
}

class CharacterType {
    
    public static const NUMBER:uint = 1;
    public static const ALPHABET_SMALL:uint = 2;
    public static const ALPHABET_LARGE:uint = 4;
    public static const SYMBOL:uint = 8;
}